/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class EndianDataInputStream
extends FilterInputStream
implements DataInput {
    private boolean bigEndian = true;

    public EndianDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public EndianDataInputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.bigEndian = bl;
    }

    public final boolean getBigEndian() {
        return this.bigEndian;
    }

    public final void setBigEndian(boolean bl) {
        this.bigEndian = bl;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = this.in.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)this.in.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return this.bigEndian ? (short)((n2 << 8) + (n << 0)) : (short)((n << 8) + (n2 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return this.bigEndian ? (n2 << 8) + (n << 0) : (n << 8) + (n2 << 0);
    }

    @Override
    public char readChar() throws IOException {
        int n;
        int n2 = this.in.read();
        if ((n2 | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return this.bigEndian ? (char)((n2 << 8) + (n << 0)) : (char)((n << 8) + (n2 << 0));
    }

    @Override
    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return this.bigEndian ? (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0) : (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public long readUnsignedInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return this.bigEndian ? ((long)n4 & 0xFFL) << 24 | (long)((n3 & 0xFF) << 16) | (long)((n2 & 0xFF) << 8) | (long)(n & 0xFF) : ((long)n & 0xFFL) << 24 | (long)((n2 & 0xFF) << 16) | (long)((n3 & 0xFF) << 8) | (long)(n4 & 0xFF);
    }

    @Override
    public long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        return this.bigEndian ? ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL) : ((long)n2 << 32) + ((long)n & 0xFFFFFFFFL);
    }

    public BigInteger readUnsignedLong() throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger2 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger3 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger4 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger5 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger6 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger7 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger8 = BigInteger.valueOf(this.in.read());
        BigInteger bigInteger9 = bigInteger.shiftLeft(56).or(bigInteger2.shiftLeft(48));
        BigInteger bigInteger10 = bigInteger3.shiftLeft(40).or(bigInteger4.shiftLeft(32));
        BigInteger bigInteger11 = bigInteger5.shiftLeft(24).or(bigInteger6.shiftLeft(16));
        BigInteger bigInteger12 = bigInteger7.shiftLeft(8).or(bigInteger8);
        BigInteger bigInteger13 = bigInteger9.or(bigInteger10).or(bigInteger11).or(bigInteger12);
        return bigInteger13;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

