/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.UnsupportedEncodingException;
import pervasive.database.IntelIOBuffer;

class IntelSeqIOBuffer {
    private IntelIOBuffer m_iobuffer;
    private int m_idx = 0;

    IntelSeqIOBuffer(int n, String string) {
        this.m_iobuffer = new IntelIOBuffer(n, string);
    }

    public byte[] getBufferData() {
        return this.m_iobuffer.getBufferData();
    }

    public void setBufferData(byte[] byArray) {
        this.m_iobuffer.setBufferData(byArray);
        this.m_idx = 0;
    }

    public int getOffset() {
        return this.m_idx;
    }

    public void setOffset(int n) {
        this.m_idx = n;
    }

    public int findNullByte(int n) {
        return this.m_iobuffer.findNullByte(n);
    }

    public final byte readByte() {
        byte by = this.m_iobuffer.readByte(this.m_idx);
        ++this.m_idx;
        return by;
    }

    public final void writeByte(byte by) {
        this.m_iobuffer.writeByte(by, this.m_idx);
        ++this.m_idx;
    }

    public final byte[] readBytes(int n) {
        byte[] byArray = this.m_iobuffer.readBytes(this.m_idx, n);
        this.m_idx += byArray.length;
        return byArray;
    }

    public final void readBytes(byte[] byArray, int n) {
        this.m_iobuffer.readBytes(byArray, this.m_idx, n);
        this.m_idx += n;
    }

    public final void writeBytes(byte[] byArray) {
        this.m_iobuffer.writeBytes(byArray, this.m_idx);
        this.m_idx += byArray.length;
    }

    public final void writeBytes(byte[] byArray, int n) {
        this.m_iobuffer.writeBytes(byArray, this.m_idx, n);
        this.m_idx += n;
    }

    public final String readString() {
        String string = this.m_iobuffer.readString(this.m_idx, 0);
        this.m_idx += string.length() + 1;
        return string;
    }

    public final void writeString(String string) {
        try {
            byte[] byArray = string.getBytes("US-ASCII");
            this.writeBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.writeByte((byte)0);
    }

    public final short readShort() {
        short s = this.m_iobuffer.readShort(this.m_idx);
        this.m_idx += 2;
        return s;
    }

    public final void writeShort(short s) {
        this.m_iobuffer.writeShort(s, this.m_idx);
        this.m_idx += 2;
    }

    public final int readInteger() {
        int n = this.m_iobuffer.readInteger(this.m_idx);
        this.m_idx += 4;
        return n;
    }

    public final void writeInteger(int n) {
        this.m_iobuffer.writeInteger(n, this.m_idx);
        this.m_idx += 4;
    }

    public final long readLong() {
        long l = this.m_iobuffer.readLong(this.m_idx);
        this.m_idx += 8;
        return l;
    }

    public final void writeLong(long l, int n) {
        this.m_iobuffer.writeLong(l, this.m_idx);
        this.m_idx += 8;
    }

    public final short readUnsignedByte() {
        short s = this.m_iobuffer.readUnsignedByte(this.m_idx);
        ++this.m_idx;
        return s;
    }

    public final void writeUnsignedByte(short s) {
        this.m_iobuffer.writeUnsignedByte(s, this.m_idx);
        ++this.m_idx;
    }

    public final int readUnsignedShort() {
        int n = this.m_iobuffer.readUnsignedShort(this.m_idx);
        this.m_idx += 2;
        return n;
    }

    public final void writeUnsignedShort(int n) {
        this.m_iobuffer.writeUnsignedShort(n, this.m_idx);
        this.m_idx += 2;
    }
}

