/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import pervasive.database.CharsetUtils;
import pervasive.database.MessageCatalog;

abstract class IOBuffer {
    protected byte[] m_buf;
    protected String m_charsetName;
    private static ThreadLocal threadLocal = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new GregorianCalendar();
        }
    };

    public abstract short readShort(int var1);

    public abstract void writeShort(short var1, int var2);

    public abstract int readInteger(int var1);

    public abstract void writeInteger(int var1, int var2);

    public abstract long readLong(int var1);

    public abstract void writeLong(long var1, int var3);

    public abstract float readFloat(int var1);

    public abstract void writeFloat(float var1, int var2);

    public abstract double readDouble(int var1);

    public abstract void writeDouble(double var1, int var3);

    public abstract double readBfloat(int var1, int var2);

    public abstract void writeBfloat(double var1, int var3, int var4);

    IOBuffer(byte[] byArray, String string) {
        this.m_buf = byArray;
        this.m_charsetName = string;
    }

    IOBuffer(int n, String string) {
        this.m_buf = new byte[n];
        this.m_charsetName = string;
    }

    public int getSize() {
        return this.m_buf.length;
    }

    public void setSize(int n) {
        byte[] byArray = new byte[n];
        int n2 = this.m_buf.length > n ? n : this.m_buf.length;
        System.arraycopy(this.m_buf, 0, byArray, 0, n2);
        this.m_buf = byArray;
    }

    public byte[] getBufferData() {
        return this.m_buf;
    }

    public void setBufferData(byte[] byArray) {
        this.m_buf = byArray;
    }

    public int findNullByte(int n) {
        while (this.m_buf[n] != 0 && n < this.m_buf.length) {
            ++n;
        }
        if (n >= this.m_buf.length) {
            n = -1;
        }
        return n;
    }

    public int findUnicodeNullByte(int n) {
        while (this.readShort(n) != 0 && n < this.m_buf.length) {
            n += 2;
        }
        if (n >= this.m_buf.length) {
            n = -1;
        }
        return n;
    }

    public final byte[] readBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_buf, n, byArray, 0, n2);
        return byArray;
    }

    public final void readBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(this.m_buf, n, byArray, 0, byArray.length < n2 ? byArray.length : n2);
    }

    public final void writeBytes(byte[] byArray, int n) {
        this.writeBytes(byArray, n, byArray.length);
    }

    public final void writeBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, 0, this.m_buf, n, byArray.length < n2 ? byArray.length : n2);
    }

    public String readString(int n, int n2) {
        if (n2 == 0) {
            n2 = this.findNullByte(n) - n;
        }
        return CharsetUtils.createStringFromBytes(this.m_buf, n, n2, this.m_charsetName);
    }

    public void writeString(String string, int n, int n2) {
        if (n + n2 > this.m_buf.length) {
            n2 = this.m_buf.length - n;
        }
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        int n3 = this.writeStringBytes(string, n, n2);
        Arrays.fill(this.m_buf, n += n3, n + (n2 - n3), (byte)32);
    }

    public String readWString(int n, int n2) {
        if (n2 == 0) {
            n2 = this.findUnicodeNullByte(n) - n;
        }
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            cArray[i] = (char)this.readShort(n + n3);
            n3 += 2;
        }
        return new String(cArray);
    }

    public void writeWString(String string, int n, int n2) {
        if (n2 % 2 != 0) {
            --n2;
        }
        int n3 = n2;
        if (n2 == 0 || n2 > string.length()) {
            n2 = string.length() * 2;
        }
        int n4 = 0;
        if (n2 > this.m_buf.length - n) {
            if ((this.m_buf.length - n) % 2 != 0) {
                n4 = 1;
            }
            n2 = this.m_buf.length - n - n4;
        }
        char[] cArray = new char[n2 / 2];
        string.getChars(0, n2 / 2, cArray, 0);
        int n5 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            this.writeShort((short)cArray[i], n + n5);
            n5 += 2;
        }
        while (n3 > n2 && n2 + n < this.m_buf.length) {
            this.writeShort((short)32, n2 + n);
            n2 += 2;
        }
    }

    public final byte readByte(int n) {
        return this.m_buf[n];
    }

    public final void writeByte(byte by, int n) {
        this.m_buf[n] = by;
    }

    public Date readDate(int n) {
        Calendar calendar = (Calendar)threadLocal.get();
        calendar.clear();
        calendar.set(this.readShort(n + 2), this.m_buf[n + 1] - 1, this.m_buf[n]);
        return calendar.getTime();
    }

    public void readDate(Date date, int n) {
        Calendar calendar = (Calendar)threadLocal.get();
        calendar.setTime(date);
        calendar.set(this.readShort(n + 2), this.m_buf[n + 1] - 1, this.m_buf[n]);
        date.setTime(calendar.getTime().getTime());
    }

    public short readDay(int n) {
        return this.m_buf[n];
    }

    public short readMonth(int n) {
        return this.m_buf[n + 1];
    }

    public short readYear(int n) {
        return this.readShort(n + 2);
    }

    public void writeDate(Date date, int n) {
        Calendar calendar = (Calendar)threadLocal.get();
        calendar.setTime(date);
        this.m_buf[n] = (byte)calendar.get(5);
        this.m_buf[n + 1] = (byte)(calendar.get(2) + 1);
        this.writeShort((short)calendar.get(1), n + 2);
    }

    public void writeDay(int n, int n2) {
        this.m_buf[n2] = (byte)n;
    }

    public void writeMonth(int n, int n2) {
        this.m_buf[n2 + 1] = (byte)n;
    }

    public void writeYear(int n, int n2) {
        this.writeShort((short)n, n2 + 2);
    }

    public Date readTime(int n) {
        Calendar calendar = (Calendar)threadLocal.get();
        calendar.set(1970, 0, 1, this.m_buf[n + 3], this.m_buf[n + 2], this.m_buf[n + 1]);
        calendar.add(14, this.m_buf[n] * 10);
        return calendar.getTime();
    }

    public void readTime(Date date, int n) {
        Calendar calendar = (Calendar)threadLocal.get();
        calendar.setTime(date);
        calendar.set(11, this.m_buf[n + 3]);
        calendar.set(12, this.m_buf[n + 2]);
        calendar.set(13, this.m_buf[n + 1]);
        calendar.add(14, this.m_buf[n] * 10);
        date.setTime(calendar.getTime().getTime());
    }

    public void writeTime(Date date, int n) {
        Calendar calendar = (Calendar)threadLocal.get();
        calendar.setTime(date);
        long l = date.getTime();
        int n2 = (int)(l % 1000L / 10L);
        this.m_buf[n] = (byte)(n2 / 10);
        this.m_buf[n + 1] = (byte)calendar.get(13);
        this.m_buf[n + 2] = (byte)calendar.get(12);
        this.m_buf[n + 3] = (byte)calendar.get(11);
    }

    public short readMS(int n) {
        return (short)(this.readDay(n) * 10);
    }

    public short readSec(int n) {
        return this.readMonth(n);
    }

    public short readMinute(int n) {
        return this.m_buf[n + 2];
    }

    public short readHour(int n) {
        return this.m_buf[n + 3];
    }

    public void writeMS(int n, int n2) {
        this.writeDay(n / 10, n2);
    }

    public void writeSec(int n, int n2) {
        this.writeMonth(n, n2);
    }

    public void writeMinute(int n, int n2) {
        this.m_buf[n2 + 2] = (byte)n;
    }

    public void writeHour(int n, int n2) {
        this.m_buf[n2 + 3] = (byte)n;
    }

    public boolean readLogical(int n, int n2, int n3) {
        boolean bl = false;
        short s = 0;
        s = n2 == 1 ? this.m_buf[n] : this.readShort(n);
        if (s == n3) {
            bl = true;
        }
        return bl;
    }

    public void writeLogical(boolean bl, int n, int n2, int n3) {
        int n4 = 0;
        if (bl) {
            n4 = n3;
        }
        if (n2 == 1) {
            this.m_buf[n] = (byte)n4;
        } else {
            this.writeShort((short)n4, n);
        }
    }

    public String readLString(int n, int n2) {
        int n3 = this.m_buf[n];
        int n4 = n2 < (n3 &= 0xFF) ? n2 : n3;
        return CharsetUtils.createStringFromBytes(this.m_buf, n + 1, n4, this.m_charsetName);
    }

    public void writeLString(String string, int n, int n2) {
        int n3;
        if (n2 > 255) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "writeLString", "nLen", Integer.toString(n2)));
        }
        int n4 = n3 = n2 < string.length() ? n2 : string.length();
        if (n3 != string.length()) {
            string = string.substring(0, n3);
        }
        int n5 = this.writeStringBytes(string, n + 1, 255);
        this.m_buf[n] = (byte)n5;
    }

    public String readZString(int n, int n2) {
        int n3 = this.findNullByte(n);
        if ((n3 -= n) > n2) {
            n3 = n2;
        }
        return CharsetUtils.createStringFromBytes(this.m_buf, n, n3, this.m_charsetName);
    }

    public void writeZString(String string, int n, int n2) {
        int n3 = this.writeStringBytes(string, n, n2);
        int n4 = n2 - n3;
        Arrays.fill(this.m_buf, n += n3, n + n4, (byte)0);
    }

    public String readWZString(int n, int n2) {
        int n3 = this.findUnicodeNullByte(n);
        if ((n3 -= n) > n2) {
            n3 = n2;
        }
        char[] cArray = new char[n3 / 2];
        int n4 = 0;
        for (int i = 0; i < n3 / 2; ++i) {
            cArray[i] = (char)this.readShort(n + n4);
            n4 += 2;
        }
        return new String(cArray);
    }

    public void writeWZString(String string, int n, int n2) {
        if (n2 % 2 != 0) {
            --n2;
        }
        char[] cArray = new char[n2 / 2];
        int n3 = n2 < string.length() ? n2 : string.length() * 2;
        string.getChars(0, n3 / 2, cArray, 0);
        int n4 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            this.writeShort((short)cArray[i], n + n4);
            n4 += 2;
        }
    }

    public double readCurrency(int n) {
        double d = this.readLong(n);
        return d /= 10000.0;
    }

    public void writeCurrency(double d, int n) {
        this.writeLong(this.doubleToLong(d, 4), n);
    }

    public short readUnsignedByte(int n) {
        return (short)(this.readByte(n) & 0xFF);
    }

    public void writeUnsignedByte(short s, int n) {
        this.writeByte((byte)s, n);
    }

    public int readUnsignedShort(int n) {
        return this.readShort(n) & 0xFFFF;
    }

    public void writeUnsignedShort(int n, int n2) {
        this.writeShort((short)n, n2);
    }

    public long readUnsignedInt(int n) {
        return (long)this.readInteger(n) & 0xFFFFFFFFL;
    }

    public void writeUnsignedInt(long l, int n) {
        this.writeInteger((int)l, n);
    }

    public BigInteger readUnsignedLong(int n) {
        long l = this.readLong(n);
        BigInteger bigInteger = new BigInteger(Long.toString(l));
        if (l < 0L) {
            bigInteger = bigInteger.add(new BigInteger("18446744073709551616"));
        }
        return bigInteger;
    }

    public void writeUnsignedLong(BigInteger bigInteger, int n) {
        this.writeLong(bigInteger.longValue(), n);
    }

    private byte[] getBufferBytes(int n, int n2) {
        return this.readBytes(n, n2);
    }

    private void setBufferBytes(byte[] byArray, int n, int n2) {
        this.writeBytes(byArray, n, n2);
    }

    public String readDecimalStr(int n, int n2, int n3) {
        return this.readDecimalBigDecimal(n, n2, n3).toString();
    }

    public long readDecimalLong(int n, int n2, int n3) {
        Double d = new Double(this.readDecimalDouble(n, n2, n3));
        return d.longValue();
    }

    public int readDecimalInt(int n, int n2, int n3) {
        Double d = new Double(this.readDecimalDouble(n, n2, n3));
        return d.intValue();
    }

    public float readDecimalFloat(int n, int n2, int n3) {
        Double d = new Double(this.readDecimalDouble(n, n2, n3));
        return d.floatValue();
    }

    public double readDecimalDouble(int n, int n2, int n3) {
        return this.decToDouble(this.getBufferBytes(n, n2), 5, n2, n3);
    }

    public BigDecimal readDecimalBigDecimal(int n, int n2, int n3) {
        return this.decToBigDecimal(this.getBufferBytes(n, n2), 5, n2, n3);
    }

    public void writeDecimal(String string, int n, int n2, int n3) throws NumberFormatException {
        this.writeDecimal(new BigDecimal(string), n, n2, n3);
    }

    public void writeDecimal(long l, int n, int n2) {
        this.setBufferBytes(this.doubleToDec(5, n2, l, 0), n, n2);
    }

    public void writeDecimal(int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(5, n3, n, 0), n2, n3);
    }

    public void writeDecimal(float f, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(5, n2, f, n3), n, n2);
    }

    public void writeDecimal(double d, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(5, n2, d, n3), n, n2);
    }

    public void writeDecimal(BigDecimal bigDecimal, int n, int n2, int n3) {
        this.setBufferBytes(this.bigDecimalToDec(5, n2, bigDecimal, n3), n, n2);
    }

    public String readMoneyStr(int n, int n2) {
        return this.readDecimalStr(n, n2, 2);
    }

    public float readMoneyFloat(int n, int n2) {
        return this.readDecimalFloat(n, n2, 2);
    }

    public double readMoneyDouble(int n, int n2) {
        return this.readDecimalDouble(n, n2, 2);
    }

    public BigDecimal readMoneyBigDecimal(int n, int n2) {
        return this.readDecimalBigDecimal(n, n2, 2);
    }

    public void writeMoney(String string, int n, int n2) throws NumberFormatException {
        this.writeDecimal(string, n, n2, 2);
    }

    public void writeMoney(float f, int n, int n2) {
        this.writeDecimal(f, n, n2, 2);
    }

    public void writeMoney(double d, int n, int n2) {
        this.writeDecimal(d, n, n2, 2);
    }

    public void writeMoney(BigDecimal bigDecimal, int n, int n2) {
        this.writeDecimal(bigDecimal, n, n2, 2);
    }

    public String readNumericStr(int n, int n2, int n3) {
        return Double.toString(this.readNumericDouble(n, n2, n3));
    }

    public long readNumericLong(int n, int n2, int n3) {
        Double d = new Double(this.readNumericDouble(n, n2, n3));
        return d.longValue();
    }

    public int readNumericInt(int n, int n2, int n3) {
        Double d = new Double(this.readNumericDouble(n, n2, n3));
        return d.intValue();
    }

    public float readNumericFloat(int n, int n2, int n3) {
        Double d = new Double(this.readNumericDouble(n, n2, n3));
        return d.floatValue();
    }

    public double readNumericDouble(int n, int n2, int n3) {
        return this.decToDouble(this.getBufferBytes(n, n2), 8, n2, n3);
    }

    public BigDecimal readNumericBigDecimal(int n, int n2, int n3) {
        return this.decToBigDecimal(this.getBufferBytes(n, n2), 8, n2, n3);
    }

    public void writeNumeric(String string, int n, int n2, int n3) throws NumberFormatException {
        this.writeNumeric(new BigDecimal(string), n, n2, n3);
    }

    public void writeNumeric(long l, int n, int n2) {
        this.setBufferBytes(this.doubleToDec(8, n2, l, 0), n, n2);
    }

    public void writeNumeric(int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(8, n3, n, 0), n2, n3);
    }

    public void writeNumeric(float f, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(8, n2, f, n3), n, n2);
    }

    public void writeNumeric(double d, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(8, n2, d, n3), n, n2);
    }

    public void writeNumeric(BigDecimal bigDecimal, int n, int n2, int n3) {
        this.setBufferBytes(this.bigDecimalToDec(8, n2, bigDecimal, n3), n, n2);
    }

    public BigDecimal readSTSBigDecimal(int n, int n2, int n3) {
        return this.decToBigDecimal(this.getBufferBytes(n, n2), 17, n2, n3);
    }

    public double readSTSDouble(int n, int n2, int n3) {
        return this.decToDouble(this.getBufferBytes(n, n2), 17, n2, n3);
    }

    public float readSTSFloat(int n, int n2, int n3) {
        return (float)this.readSTSDouble(n, n2, n3);
    }

    public float readSTSLong(int n, int n2, int n3) {
        return (long)this.readSTSDouble(n, n2, n3);
    }

    public int readSTSInt(int n, int n2, int n3) {
        return (int)this.readSTSDouble(n, n2, n3);
    }

    public String readSTSStr(int n, int n2, int n3) {
        return this.readSTSBigDecimal(n, n2, n3).toString();
    }

    public void writeSTS(BigDecimal bigDecimal, int n, int n2, int n3) {
        this.setBufferBytes(this.bigDecimalToDec(17, n2, bigDecimal, n3), n, n2);
    }

    public void writeSTS(double d, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(17, n2, d, n3), n, n2);
    }

    public void writeSTS(float f, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(17, n2, f, n3), n, n2);
    }

    public void writeSTS(int n, int n2, int n3, int n4) {
        this.setBufferBytes(this.doubleToDec(17, n3, n, 0), n2, n3);
    }

    public void writeSTS(long l, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(17, n2, l, 0), n, n2);
    }

    public void writeSTS(String string, int n, int n2, int n3) throws NumberFormatException {
        this.writeSTS(new BigDecimal(string), n, n2, n3);
    }

    public BigDecimal readSABigDecimal(int n, int n2, int n3) {
        return this.decToBigDecimal(this.getBufferBytes(n, n2), 18, n2, n3);
    }

    public double readSADouble(int n, int n2, int n3) {
        return this.decToDouble(this.getBufferBytes(n, n2), 18, n2, n3);
    }

    public float readSAFloat(int n, int n2, int n3) {
        return (float)this.readSADouble(n, n2, n3);
    }

    public float readSALong(int n, int n2, int n3) {
        return (long)this.readSADouble(n, n2, n3);
    }

    public int readSAInt(int n, int n2, int n3) {
        return (int)this.readSADouble(n, n2, n3);
    }

    public String readSAStr(int n, int n2, int n3) {
        return this.readSABigDecimal(n, n2, n3).toString();
    }

    public void writeSA(BigDecimal bigDecimal, int n, int n2, int n3) {
        this.setBufferBytes(this.bigDecimalToDec(18, n2, bigDecimal, n3), n, n2);
    }

    public void writeSA(double d, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(18, n2, d, n3), n, n2);
    }

    public void writeSA(float f, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(18, n2, f, n3), n, n2);
    }

    public void writeSA(int n, int n2, int n3, int n4) {
        this.setBufferBytes(this.doubleToDec(18, n3, n, 0), n2, n3);
    }

    public void writeSA(long l, int n, int n2, int n3) {
        this.setBufferBytes(this.doubleToDec(18, n2, l, 0), n, n2);
    }

    public void writeSA(String string, int n, int n2, int n3) throws NumberFormatException {
        this.writeSA(new BigDecimal(string), n, n2, n3);
    }

    byte[] bigDecimalToDec(int n, int n2, BigDecimal bigDecimal, int n3) {
        byte by;
        bigDecimal = bigDecimal.setScale(n3, 0);
        byte[] byArray = new byte[n2];
        byte[] byArray2 = bigDecimal.toString().getBytes();
        boolean bl = byArray2[0] == 45;
        int n4 = byArray2.length - 1;
        int n5 = byArray.length - 1;
        if (n == 8) {
            byArray[n5] = byArray2[n4] == 48 ? (bl ? 125 : 123) : (bl ? (byte)(byArray2[n4] + 25) : (byte)(byArray2[n4] + 16));
            --n5;
            --n4;
        } else if (n == 17) {
            byArray[n5--] = bl ? 45 : 43;
        } else if (n == 18) {
            byArray[n5] = bl ? (byte)(byArray2[n4] + 64) : byArray2[n4];
            --n5;
            --n4;
        } else {
            by = (byte)(byArray2[n4] - 48);
            by = (byte)(by << 4);
            by = bl ? (byte)(by | 0xD) : (byte)(by | 0xF);
            byArray[n5] = by;
            --n5;
            --n4;
        }
        by = 0;
        while (n4 >= 0) {
            if (byArray2[n4] == 46 || byArray2[n4] == 45) {
                --n4;
                continue;
            }
            if (n == 5) {
                byte by2 = (byte)(byArray2[n4] - 48);
                if (by == 0) {
                    byArray[n5] = by2;
                } else {
                    int n6 = n5--;
                    byArray[n6] = (byte)(byArray[n6] | by2 << 4);
                }
                by = by == 0 ? (byte)1 : 0;
            } else {
                byArray[n5] = byArray2[n4];
                --n5;
            }
            --n4;
        }
        if (n == 5 && by != 0) {
            --n5;
        }
        while (n5 >= 0) {
            if (n != 5) {
                byArray[n5--] = 48;
                continue;
            }
            byArray[n5--] = 0;
        }
        return byArray;
    }

    byte[] doubleToDec(int n, int n2, double d, int n3) {
        byte[] byArray = new byte[n2];
        long l = this.doubleToLong(d, n3);
        int n4 = 0;
        n4 += n2 - 1;
        if (n == 17) {
            if (l < 0L) {
                byArray[n4--] = 45;
                l = -l;
            } else {
                byArray[n4--] = 43;
            }
        } else {
            boolean bl;
            if (l < 0L) {
                bl = true;
                l = -l;
            } else {
                bl = false;
            }
            int n5 = (int)(l % 10L);
            l /= 10L;
            if (n == 8) {
                n5 = n5 == 0 ? (bl ? 125 : 123) : (bl ? (int)((byte)(n5 + 73)) : (int)((byte)(n5 + 64)));
            } else if (n == 5) {
                n5 = (byte)(n5 << 4);
                n5 = bl ? (int)((byte)(n5 | 0xD)) : (int)((byte)(n5 | 0xF));
            } else {
                n5 = bl ? (int)((byte)(n5 | 0x70)) : (int)((byte)(n5 | 0x30));
            }
            byArray[n4--] = n5;
        }
        for (int i = n2; i > 1; --i) {
            byArray[n4] = (byte)(l % 10L);
            l /= 10L;
            if (n == 5) {
                int n6 = n4--;
                byArray[n6] = (byte)(byArray[n6] | (byte)(l % 10L << 4));
                l /= 10L;
                continue;
            }
            int n7 = n4--;
            byArray[n7] = (byte)(byArray[n7] | 0x30);
        }
        return byArray;
    }

    BigDecimal decToBigDecimal(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (n4 = n2; n4 > 1; --n4) {
            if (n == 5) {
                stringBuffer.append((byArray[n5] & 0xF0) >> 4);
            }
            stringBuffer.append(byArray[n5++] & 0xF);
        }
        n4 = byArray[n5];
        if (n == 17) {
            if (n4 == 45) {
                stringBuffer.insert(0, "-");
            }
        } else if (n == 8) {
            if (n4 == 125) {
                stringBuffer.append("0");
                stringBuffer.insert(0, "-");
            } else if (n4 == 123) {
                stringBuffer.append("0");
            } else if (n4 <= 73) {
                stringBuffer.append(n4 & 0xF);
            } else if (n4 <= 82) {
                stringBuffer.append(n4 - 73);
                stringBuffer.insert(0, "-");
            }
        } else if (n == 5) {
            stringBuffer.append((n4 & 0xF0) >> 4);
            if ((n4 & 0xF) == 13) {
                stringBuffer.insert(0, "-");
            }
        } else {
            stringBuffer.append(n4 & 0xF);
            if ((n4 & 0x70) == 112) {
                stringBuffer.insert(0, "-");
            }
        }
        return new BigDecimal(new BigInteger(stringBuffer.toString()), n3);
    }

    double decToDouble(byte[] byArray, int n, int n2, int n3) {
        long l = 0L;
        int n4 = 0;
        for (int i = n2; i > 1; --i) {
            if (n == 5) {
                l = 10L * l + (long)((byArray[n4] & 0xF0) >>> 4);
            }
            l = 10L * l + (long)(byArray[n4++] & 0xF);
        }
        byte by = byArray[n4];
        if (n == 17) {
            if (by == 45) {
                l = -l;
            }
        } else {
            l *= 10L;
            if (n == 8) {
                if (by == 125) {
                    l = -l;
                } else if (by <= 73) {
                    l += (long)(by & 0xF);
                } else if (by <= 82) {
                    l = -(l + (long)(by - 73));
                }
            } else if (n == 5) {
                l += (long)((by & 0xF0) >>> 4);
                if ((by & 0xF) == 13) {
                    l = -l;
                }
            } else {
                l += (long)(by & 0xF);
                if ((by & 0x70) == 112) {
                    l = -l;
                }
            }
        }
        return this.longToDouble(l, n3);
    }

    double longToDouble(long l, int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= 10;
        }
        return (double)l / (double)n2;
    }

    long doubleToLong(double d, int n) {
        while (n > 0) {
            d *= 10.0;
            --n;
        }
        return (long)(d + (d > 0.0 ? 0.5 : -0.5));
    }

    int writeStringBytes(String string, int n, int n2) {
        int n3;
        byte[] byArray = CharsetUtils.getStringBytes(string, this.m_charsetName);
        int n4 = string.length() - 1;
        for (n3 = byArray.length; n3 > n2; n3 -= CharsetUtils.getStringBytes(String.valueOf(string.charAt(n4--)), this.m_charsetName).length) {
        }
        this.writeBytes(byArray, n, n3);
        return n3;
    }
}

