/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.IOException;
import java.io.OutputStream;
import pervasive.database.PsqlException;
import pervasive.database.SCursor;

class BLOBOutputStream
extends OutputStream {
    private final int CHUNKSIZE = 1024;
    private SCursor _scursor;
    private int _chunkOffset = -1;
    private int _bytesWritten = 0;

    BLOBOutputStream(int n, SCursor sCursor) {
        this._chunkOffset = n;
        this._scursor = sCursor;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this._scursor.updateChunk(this._chunkOffset, n2, byArray2);
            this._chunkOffset += n2;
            this._bytesWritten += n2;
        }
        catch (PsqlException psqlException) {
            throw new IOException(psqlException.getMessage());
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    int getBytesWritten() {
        return this._bytesWritten;
    }
}

