/*
 * This system procedure is used to return the list of columns
 * and the corresponding column for the given table(s).
 */
 
CREATE PROCEDURE psp_columns (
	in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
	in :table_name      VARCHAR(255),             -- Name of the table
	in :column_name     VARCHAR(255)=NULL         -- Name of the column
)
RETURNS (
	TABLE_QUALIFIER     VARCHAR (20), 	-- Name of the database that contains the table
	TABLE_OWNER         VARCHAR (20), 	-- Owner of the table
	TABLE_NAME          VARCHAR (255),	-- Table Name
	COLUMN_NAME         VARCHAR(255),	-- Column name
	DATA_TYPE           SMALLINT,		-- Datatype of Column
	TYPE_NAME           VARCHAR (32),	-- Datatype Name
	PRECISION           INTEGER,		-- Precision
	LENGTH              INTEGER, 		-- Length
	SCALE               SMALLINT,		-- Scale
	RADIX               SMALLINT,		-- Radix
	NULLABLE            SMALLINT,		-- Nullable flag
	REMARKS             VARCHAR(255),	-- Remarks
	COLUMN_DEF          VARCHAR(255)        -- Column Defaults
)
as 
BEGIN 

    -- Check if the database qualifier specified is a blank string
    if (rtrim(:database_qual) = '') then
	SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
    end if;
    
    -- Check if the table_name is null
    if (:table_name is null) then
    	SIGNAL 'S1000', 'Table name cannot be null'; 
    end if;
    
    -- Check if the table_name specified is a blank string
    if (rtrim(:table_name) = '') then
	SIGNAL 'S1000', 'Table name cannot be a blank string'; 
    end if;

    -- Check if the table_name specified is a blank string
    if (rtrim(:column_name) = '') then
	SIGNAL 'S1000', 'Column name cannot be a blank string'; 
    end if;

    SET :database_qual = IFNULL(:database_qual, DATABASE());

    SET :column_name = IFNULL(:column_name,'%'); 

    SELECT "TABLE_QUALIFIER",
           "TABLE_OWNER",
           "TABLE_NAME",
           "COLUMN_NAME",
           "DATA_TYPE",
           "TYPE_NAME",
           "PRECISION",
           "LENGTH",
           "SCALE",
           "RADIX",
           "NULLABLE",
           "REMARKS",
           "COLUMN_DEF"
    FROM DBO.fSQLColumns ( :database_qual, :table_name, :column_name );

END; -- End of stored procedure.

