/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Enumeration;
import java.util.Set;
import pervasive.database.BufferMetaData;
import pervasive.database.ColumnDef;
import pervasive.database.Consts;
import pervasive.database.IndexMetaData;
import pervasive.database.MessageCatalog;
import pervasive.database.Table;

public class TableMetaData
extends BufferMetaData
implements Consts {
    Table m_parent;
    boolean m_vartable = false;
    int m_permpagesize = 4096;
    int m_permextradups = 0;
    int m_permprealloc = 0;
    int m_permfileflags = 0;
    int m_pagesize = 4096;
    int m_extradups = 0;
    int m_prealloc = 0;
    int m_fileflags = 0;
    private boolean m_previousWasBit = false;
    static int[] m_dlen = new int[]{1, 2, 4, 4, 4, 6, 6, 2, 6, 4, 2, 2, 2, 5, 2, 2, 1, 6, 6, 8, 8};

    TableMetaData(Table table) {
        super(table);
        this.m_parent = table;
    }

    public String getTableName() {
        return this.m_parent.m_tname;
    }

    public String getDataFileName() {
        return this.m_parent.m_dfname;
    }

    public String getDataFilePath() {
        return this.m_parent.m_datapath;
    }

    public int getIndexCount() {
        return this.m_parent.m_indcount;
    }

    public String[] getIndexNames() {
        Set set = this.m_parent.m_indnames.keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    public int findIndex(String string) {
        Object v = this.m_parent.m_indnames.get(string);
        if (v == null) {
            return -1;
        }
        return this.m_parent.m_indexes.indexOf(this.m_parent.m_indnames.get(string));
    }

    public IndexMetaData getIndexDef(int n) {
        return (IndexMetaData)this.m_parent.m_indexes.elementAt(n);
    }

    public IndexMetaData getIndexDef(String string) {
        return (IndexMetaData)this.m_parent.m_indnames.get(string);
    }

    public int getDataFileFlag() {
        return this.m_fileflags;
    }

    public int getBaseRowLength() {
        return this.m_highoffs;
    }

    public int getPageSize() {
        return this.m_pagesize;
    }

    public int getExtraDupPtrs() {
        return this.m_extradups;
    }

    public int getPreAlloc() {
        return this.m_prealloc;
    }

    void addColumn(int n, String string, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        int n5 = n + n3 - 1;
        if (this.m_hcol.containsKey(string)) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "addColumn", "cName", string));
        }
        if (n2 == 12 || n2 == 13) {
            if (this.m_vartable) {
                throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "addColumn", "dType", Integer.toString(n2)));
            }
            if (n < this.m_highoffs) {
                throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "addColumn", "offset", Integer.toString(n)));
            }
            this.m_vartable = true;
        } else if (this.m_vartable && n >= this.m_highoffs) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "addColumn", "offset", Integer.toString(n)));
        }
        ColumnDef columnDef = new ColumnDef(string, n, n2, n3, n4, bl, bl2);
        boolean bl4 = n2 == 16;
        boolean bl5 = bl3 = this.m_previousWasBit && bl4;
        if (n >= this.m_highoffs || bl3) {
            this.m_vcol.addElement(columnDef);
            this.m_highoffs = n + n3;
            this.m_previousWasBit = bl4;
        } else {
            ColumnDef columnDef2;
            int n6 = 0;
            do {
                columnDef2 = (ColumnDef)this.m_vcol.elementAt(n6++);
            } while (columnDef2.m_recordOffset + columnDef2.m_length <= n);
            if (columnDef2.m_recordOffset > n5) {
                this.m_vcol.insertElementAt(columnDef, n6 - 1);
            }
        }
        this.m_hcol.put(string, columnDef);
    }

    ColumnDef getColumnByOffset(int n) {
        ColumnDef columnDef = null;
        Enumeration enumeration = this.m_vcol.elements();
        while (enumeration.hasMoreElements()) {
            columnDef = (ColumnDef)enumeration.nextElement();
            if (columnDef.m_recordOffset != n) continue;
            return columnDef;
        }
        return null;
    }

    void resetValues() {
        this.m_pagesize = this.m_permpagesize;
        this.m_extradups = this.m_permextradups;
        this.m_prealloc = this.m_permprealloc;
        this.m_fileflags = this.m_permfileflags;
    }

    void setValues() {
        this.m_permpagesize = this.m_pagesize;
        this.m_permextradups = this.m_extradups;
        this.m_permprealloc = this.m_prealloc;
        this.m_permfileflags = this.m_fileflags;
    }
}

