/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.ParamDesc;
import com.pervasive.jdbc.lna.VarData;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class ParamInfo
extends ParamDesc {
    private short d_paramNum;
    private Object d_value;
    private int d_lengthOrIndicator;

    public ParamInfo() {
    }

    public ParamInfo(ParamDesc paramDesc) {
        this.d_sqlDataType = paramDesc.d_sqlDataType;
        this.d_precision = paramDesc.d_precision;
        this.d_scale = paramDesc.d_scale;
        this.d_paramType = paramDesc.d_paramType;
        this.d_nullable = paramDesc.d_nullable;
        this.d_unsigned = paramDesc.d_unsigned;
        this.d_cDataType = paramDesc.d_cDataType;
        this.d_maxSize = paramDesc.d_maxSize;
    }

    public ParamInfo(ParamDesc paramDesc, short s, short s2) {
        this(paramDesc);
        this.d_paramNum = s;
        this.d_paramType = s2;
    }

    @Override
    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_paramNum = lNAResponse.readShort();
        this.d_paramType = lNAResponse.readShort();
        this.d_sqlDataType = lNAResponse.readShort();
        this.d_precision = lNAResponse.readInt();
        this.d_scale = lNAResponse.readShort();
        this.d_maxSize = lNAResponse.readInt();
        this.d_value = VarData.readFrom(lNAResponse);
        this.selectBinding();
    }

    public void writeTo(LNARequest lNARequest) throws IOException {
        lNARequest.writeShort(this.d_paramNum);
        lNARequest.writeShort(this.d_paramType);
        lNARequest.writeShort(this.d_sqlDataType);
        if (this.d_sqlDataType == 1 || this.d_sqlDataType == 12 || this.d_sqlDataType == -1 || this.d_sqlDataType == -8 || this.d_sqlDataType == -9 || this.d_sqlDataType == -10) {
            lNARequest.writeInt(0);
            lNARequest.writeShort(this.d_scale);
            lNARequest.writeInt(this.d_precision + 1);
        } else {
            lNARequest.writeInt(this.d_precision);
            lNARequest.writeShort(this.d_scale);
            lNARequest.writeInt(this.d_maxSize);
        }
        if (this.d_cDataType == 1 && (this.d_sqlDataType == 2 || this.d_sqlDataType == 3)) {
            if (this.d_value != null) {
                if (this.d_value instanceof Boolean) {
                    VarData.writeTo(lNARequest, this.d_cDataType, (Boolean)this.d_value == true ? "1" : "0");
                } else {
                    VarData.writeTo(lNARequest, this.d_cDataType, this.d_value.toString());
                }
            } else {
                VarData.writeTo(lNARequest, this.d_cDataType, null);
            }
        } else {
            VarData.writeTo(lNARequest, this.d_cDataType, this.d_value);
        }
    }

    public void writeDataAtExec(LNARequest lNARequest) throws IOException {
        lNARequest.writeShort(this.d_paramNum);
        lNARequest.writeShort(this.d_paramType);
        lNARequest.writeShort(this.d_sqlDataType);
        lNARequest.writeInt(this.d_precision);
        lNARequest.writeShort(this.d_scale);
        lNARequest.writeInt(this.d_maxSize);
        lNARequest.writeShort(this.d_cDataType);
        lNARequest.writeInt(this.d_lengthOrIndicator);
    }

    public short getParamNum() {
        return this.d_paramNum;
    }

    public void setParamNum(short s) {
        this.d_paramNum = s;
    }

    public short getParamType() {
        return this.d_paramType;
    }

    public void setParamType(short s) {
        this.d_paramType = s;
    }

    public Object getValue() {
        return this.d_value;
    }

    public void setValue(Object object) {
        this.d_value = object;
    }

    public void setDataType(short s) {
        switch (s) {
            case 91: 
            case 92: 
            case 93: {
                this.d_sqlDataType = 1;
                break;
            }
            case -15: {
                this.d_sqlDataType = (short)-8;
                break;
            }
            case -9: {
                this.d_sqlDataType = (short)-9;
                break;
            }
            case -16: {
                this.d_sqlDataType = (short)-10;
                break;
            }
            default: {
                this.d_sqlDataType = s;
            }
        }
        this.selectBinding();
    }

    public void setScale(short s) {
        this.d_scale = s;
    }

    public boolean hasLongData() {
        return this.d_value instanceof InputStream || this.d_value instanceof Reader;
    }

    public void setIndicator(int n) {
        this.d_lengthOrIndicator = n;
    }
}

