/*******************************************************************************
 * Copyright (c) 2000, 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Ecplise Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Pervasive Software, Inc. - Added Dynamic properties
 *******************************************************************************/
package com.pervasive.open.eclipse.dynamicproperties.internal;

import java.util.HashMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.registry.RegistryReader;

/**
 * This class loads property pages from the registry.
 */
public class DynamicPropertyPagesRegistryReader extends RegistryReader {
    public static final String ATT_NAME_FILTER = "nameFilter";//$NON-NLS-1$
    public static final String ATT_FILTER_NAME = "name";//$NON-NLS-1$
    public static final String ATT_FILTER_VALUE = "value";//$NON-NLS-1$
    public static final String ATT_CLASS = "class";//$NON-NLS-1$

    private static final String TAG_PAGE = "dynamicpages";//$NON-NLS-1$
    private static final String TAG_FILTER="filter";//$NON-NLS-1$
    private static final String ATT_NAME = "name";//$NON-NLS-1$
    private static final String ATT_ID = "id";//$NON-NLS-1$
    private static final String ATT_ICON = "icon";//$NON-NLS-1$
    private static final String ATT_OBJECTCLASS = "objectClass";//$NON-NLS-1$
    private static final String ATT_ADAPTABLE = "adaptable";//$NON-NLS-1$
    
    private static final String P_TRUE = "true";//$NON-NLS-1$
    
    private HashMap filterProperties; 
    private DynamicPropertyPageContributorManager manager;
/**
 * The constructor.
 */
public DynamicPropertyPagesRegistryReader(DynamicPropertyPageContributorManager manager) {
    this.manager = manager;
}
/**
 * Parses child element and processes it 
 */
private void processChildElement(IConfigurationElement element) {
    String tag = element.getName();
    if (tag.equals(TAG_FILTER)) {
        String key = element.getAttribute(ATT_FILTER_NAME);
        String value = element.getAttribute(ATT_FILTER_VALUE);
        if (key == null || value == null)
            return;
        if (filterProperties==null) 
            filterProperties = new HashMap();
        filterProperties.put(key, value);
    }
}

/**
 * Reads static property page specification.
 */
private void processPageElement(IConfigurationElement element) {
    String pluginId = element.getDeclaringExtension().getNamespace();
    String pageId = element.getAttribute(ATT_ID);
    String pageClassName = element.getAttribute(ATT_CLASS);
    String objectClassName = element.getAttribute(ATT_OBJECTCLASS);

    if (pageId==null) {
        logMissingAttribute(element, ATT_ID);
        return;
    }
    if (objectClassName == null) {
        logMissingAttribute(element, ATT_OBJECTCLASS);
        return;
    }
    if (pageClassName == null) {
        logMissingAttribute(element, ATT_CLASS);
        return;
    }

    filterProperties = null;
    IConfigurationElement[] children = element.getChildren();
    for (int i=0; i<children.length; i++) {
        processChildElement(children[i]);
    }
    

    IPropertyPageContributor contributor = 
        new DynamicPageContributor(
            pluginId,
            pageId, 
            filterProperties, 
            objectClassName,
            element);
    registerContributor(objectClassName, contributor);
//    try {
        /*IWorkbenchPropertyPage ppage = null;
        ppage = (IWorkbenchPropertyPage)WorkbenchPlugin.createExtension(
            pageElement, PropertyPagesRegistryReader.ATT_CLASS);*/
        /*Class clazz = Class.forName(pageClassName);
        IDynamicPropertyPageCreator pageCreator = (IDynamicPropertyPageCreator) clazz.newInstance(); 
        IPropertyPageContributor[] contribs = pageCreator.getPageContributions();
        for (int i = 0; i < contribs.length; i++) {
            registerContributor(objectClassName, contribs[i]);
        }
    }
    catch (Exception ex) {        
    }*/
}
/**
 * Reads the next contribution element.
 * 
 * public for dynamic UI
 */
public boolean readElement(IConfigurationElement element) {
    if (element.getName().equals(TAG_PAGE)) {
        processPageElement(element);
        readElementChildren(element);
        return true;
    }
    if (element.getName().equals(TAG_FILTER)) {
        return true;
    }

    return false;
}
/**
 * Creates object class instance and registers the contributor with the
 * property page manager.
 */
private void registerContributor(String objectClassName, IPropertyPageContributor contributor) {
    manager.registerContributor(contributor, objectClassName);
}
/**
 *  Reads all occurances of propertyPages extension in the registry.
 */
public void registerPropertyPages(IExtensionRegistry registry) {
    readRegistry(registry, "com.pervasive.open.eclipse", "dynamicPropertyPages");
}
}
