/*******************************************************************************
 * Copyright (c) 2000, 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Ecplise Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Pervasive Software, Inc. - Added Dynamic properties
 *******************************************************************************/
package com.pervasive.open.eclipse.dynamicproperties.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;

/**
 */
public class DynamicPropertyPageContributorManager extends PropertyPageContributorManager

{
    private static DynamicPropertyPageContributorManager sharedInstance = null;

    /**
     * The constructor.
     */
    public DynamicPropertyPageContributorManager()
    {
        super();
        loadContributors();
    }

    /**
     * Ideally, shared instance should not be used and manager should be located
     * in the workbench class.
     */
    public static DynamicPropertyPageContributorManager getDynamicManager()
    {
        if (sharedInstance == null) {
            sharedInstance = new DynamicPropertyPageContributorManager();
        }
        
        return sharedInstance;
    }

    /**
     * Loads property page contributors from the registry.
     */
    private void loadContributors()
    {
        DynamicPropertyPagesRegistryReader dynamicReader = new DynamicPropertyPagesRegistryReader(this);

        dynamicReader.registerPropertyPages(Platform.getExtensionRegistry());        
    }
    
    //***********************************************************************
    // TODO:  Uncomment this method when moving to a new Eclipse version.  This 
    //        method in PropertyPageContributorManager has changed and no longer
    //        calls "contributePropertyPages" but instead calls "contributePropertyPage" on
    //        the IPropertyPageContributor.
    
    public boolean contribute(PropertyPageManager manager, Object object) {

        List result = getContributors(object);

        if (result == null || result.size() == 0) {
            return false;
        }

        // Build the category nodes
        List catNodes = buildList(result);
        Iterator resultIterator = catNodes.iterator();

        // K(PageNode) V(PreferenceNode - property page)
        Map catPageNodeToPages = new HashMap();

        // Allow each contributor to add its page to the manager.
        boolean actualContributions = false;
        while (resultIterator.hasNext()) {
            PageNode next = (PageNode) resultIterator
                    .next();
            IPropertyPageContributor ppcont = next.page;
            if (!ppcont.isApplicableTo(object)) {
                continue;
            }
            if (ppcont instanceof DynamicPageContributor) {
                actualContributions = ((DynamicPageContributor)ppcont).contributePropertyPages(manager, object);
            } else {
                PreferenceNode page = ppcont.contributePropertyPage(manager, object);
                if (page != null) {
                    catPageNodeToPages.put(next, page);
                    actualContributions = true;
                }
            }
        }

        // Fixup the parents in each page
        if (actualContributions) {
            resultIterator = catNodes.iterator();
            while (resultIterator.hasNext()) {
                PageNode next = (PageNode) resultIterator.next();
                PreferenceNode child = (PreferenceNode) catPageNodeToPages.get(next);
                if (child == null)
                    continue;
                PreferenceNode parent = null;
                if (next.parent != null) {
                    parent = (PreferenceNode) catPageNodeToPages.get(next.parent);
                }
               
                if (parent == null) {
                    manager.addToRoot(child);
                } else {
                    parent.add(child);
                }
            }
        }
        return actualContributions;
    }

    /**
     * Build the list of nodes to be sorted.
     * @param nodes
     * @return List of PageNode
     */
    private List<PageNode> buildList(List<RegistryPageContributor> nodes) {
        
        HashMap<String, PageNode> map = new HashMap<String, PageNode>();
        
        Iterator<RegistryPageContributor> iter = nodes.iterator();
        while (iter.hasNext()){
            RegistryPageContributor page = iter.next();
            map.put(page.getPageId(), new PageNode(page));
        }
        
        Iterator<PageNode> values = map.values().iterator();
        List<PageNode> list = new ArrayList<PageNode>();
        
        while (values.hasNext()) {
           
            PageNode node = values.next();
            list.add(node);
            
            if (node.getCategory() == null) {
                continue;
            }
            
            node.setParent(map.get(node.getCategory()));
        }
        
        return list;
    }
    
    class PageNode {
        
        private PageNode parent;
        private RegistryPageContributor page;

        PageNode(RegistryPageContributor page) {
            this.page = page;
        }
        
        String getCategory() {
            return page.getCategory();
        }

        void setParent(PageNode parent) {
            
            if (parent != null) {
                this.parent = parent;
            }
        }
    }
}
