/*******************************************************************************
 * Copyright (c) 2000, 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Ecplise Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Pervasive Software, Inc. - Added Dynamic properties
 *******************************************************************************/
package com.pervasive.open.eclipse.dynamicproperties.internal;

import java.util.HashMap;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.IWorkbenchRegistryConstants;

import com.pervasive.open.eclipse.dynamicproperties.IDynamicPropertyPageContributor;

/**
 */
public class DynamicPageContributor extends RegistryPageContributor 
{
    private IConfigurationElement pageElement;
 
    /**
     * PropertyPageContributor constructor.
     */
    public DynamicPageContributor(String pluginId, String pageId,
            HashMap filterProperties, String objectClassName,
            IConfigurationElement pageElement)
    {
    	super(pluginId, pageElement);
        this.pageElement = pageElement;
    }
    
    public String getPageName() {
    	String pageName = pageElement.getAttribute(IWorkbenchRegistryConstants.ATT_NAME); 
    	if (pageName == null)
			pageName = "xxxx";  //  Trick to make "Information" Prop Page 1st.
		return pageName;
	}
    
    /**
     * Implements the interface by creating property page specified with the
     * configuration element.
     */
    public boolean contributePropertyPages(PropertyPageManager mng,
            Object element)
    {
        try {
            IDynamicPropertyPageContributor contributor = null;
            contributor = (IDynamicPropertyPageContributor) WorkbenchPlugin
                    .createExtension(pageElement,
                        IWorkbenchRegistryConstants.ATT_CLASS);
            
            contributePropertyPages(mng, (IAdaptable) element, contributor, null);
           
            return true;
        }
        catch (Exception ex) {

        }

        return false;
    }

    private void contributePropertyPages(
        PropertyPageManager mng, 
        IAdaptable element,
        IDynamicPropertyPageContributor contributor, 
        String parentId)
    {
        String[] pageIds = contributor.getPropertyPages(element, parentId);
        
        if (pageIds == null) return;
        
        for (int i = 0; i < pageIds.length; i++) {
            DynamicPropertyPageNode node = 
                new DynamicPropertyPageNode(
                        contributor, 
                        element, 
                        pageIds[i], 
                        contributor.getLabel(pageIds[i]), 
                        contributor.getImage(pageIds[i]));
            
            if (parentId != null) {
                mng.addTo(parentId, node);
                contributePropertyPages(mng, element, 
                    contributor, parentId + '.' + pageIds[i]);
            }
            else {
                mng.addToRoot(node);
                contributePropertyPages(mng, element, 
                    contributor, pageIds[i]);
            }           
        }
    }
    
}

