/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.text.MessageFormat;
import java.util.ResourceBundle;

class MessageCatalog {
    private static ResourceBundle bundle = ResourceBundle.getBundle("pervasive.database.resources.Messages");
    private static ThreadLocal threadLocal = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new MessageFormat("");
        }
    };

    private MessageCatalog() {
    }

    static String getIllegalArgumentMsg(Object object, String string, String string2, String string3) {
        return MessageCatalog.getMsg("illegal.argument.msg", new Object[]{object.getClass().getName(), string, string2, string3});
    }

    static String getUnsupportedConversionMsg(Object object, String string, int n, String string2) {
        return MessageCatalog.getMsg("unsupported.conversion.msg", new Object[]{object.getClass().getName(), string, new Integer(n), string2});
    }

    static String getUnsupportedConversionMsg2(Object object, String string, int n) {
        return MessageCatalog.getMsg("unsupported.conversion.msg2", new Object[]{object.getClass().getName(), string, new Integer(n)});
    }

    static String getConversionExMsg(Object object, Exception exception, String string, int n, String string2) {
        return MessageCatalog.getMsg("conversion.ex.msg", new Object[]{object.getClass().getName(), exception.getLocalizedMessage(), string, new Integer(n), string2});
    }

    static String getObjectClosedMsg(Object object) {
        return MessageCatalog.getMsg("object.closed.msg", object.getClass().getName());
    }

    static String getMissingFieldsMsg(Object object) {
        return MessageCatalog.getMsg("missing.fields.msg", object.getClass().getName());
    }

    static String getInvalidPositionMsg(Object object, int n) {
        return MessageCatalog.getMsg("invalid.position.msg", new Object[]{object.getClass().getName(), Integer.toString(n)});
    }

    static String getTransactionMsg() {
        return MessageCatalog.getMsg("transaction.msg");
    }

    static String getDictionaryNotFoundMsg(String string) {
        return MessageCatalog.getMsg("dictionary.not.found.msg", string);
    }

    static String getTableNotFoundMsg(String string) {
        return MessageCatalog.getMsg("table.not.found.msg", string);
    }

    static String getInvalidTableMsg(String string, String string2) {
        return MessageCatalog.getMsg("invalid.table.msg", new Object[]{string, string2});
    }

    static String getNoDataFileOwnerMsg() {
        return MessageCatalog.getMsg("no.data.file.owner.msg");
    }

    static String getTableOpenMsg(String string, String string2) {
        return MessageCatalog.getMsg("table.open.msg", new Object[]{string, string2 != null ? string2 : MessageCatalog.getMsg("no.owner.msg")});
    }

    static String getInvalidDataPathMsg(String string) {
        return MessageCatalog.getMsg("invalid.data.path.msg", string);
    }

    static String getEOFMsg() {
        return MessageCatalog.getMsg("eof.msg");
    }

    static String getDefaultOperationErrorMsg() {
        return MessageCatalog.getMsg("default.operation.error.msg");
    }

    static String getDefaultRemappedMsg() {
        return MessageCatalog.getMsg("default.remapped.msg");
    }

    static String getConnectionMsg() {
        return MessageCatalog.getMsg("connection.msg");
    }

    static String getServerConnectionMsg(String string) {
        return MessageCatalog.getMsg("connection.server.msg", new Object[]{string});
    }

    static String getIOMsg() {
        return MessageCatalog.getMsg("io.msg");
    }

    static String getDBNAMESMsg() {
        return MessageCatalog.getMsg("dbnames.msg");
    }

    static String getNamedDBNotFoundMsg(String string) {
        return MessageCatalog.getMsg("named.db.not.found.msg", string);
    }

    static String getArgumentToLongMsg(Object object, String string, Integer n) {
        return MessageCatalog.getMsg("argument.too.long.msg", new Object[]{object.getClass().getName(), string, n});
    }

    static String getOverflowMsg(Object object, String string, String string2, String string3) {
        return MessageCatalog.getMsg("overflow.msg", new Object[]{object.getClass().getName(), string, string2, string3});
    }

    static String getIOBufferOverflowMsg() {
        return MessageCatalog.getMsg("iobuffer.overflow.msg");
    }

    static String getTimestampFormatErrorMsg() {
        return MessageCatalog.getMsg("timestamp.format.error.msg");
    }

    static String getNonNullableColumnMsg(String string) {
        return MessageCatalog.getMsg("nonnullable.column.msg", string);
    }

    static String getNullValueErrorMsg(String string) {
        return MessageCatalog.getMsg("null.value.error.msg", string);
    }

    static String getInvalidFilterMsg() {
        return MessageCatalog.getMsg("invalid.filter.msg");
    }

    static String getComparisonNotSupportedMsg() {
        return MessageCatalog.getMsg("comparison.not.supported.msg");
    }

    static String getUnsupportedEncodingMsg(String string) {
        return MessageCatalog.getMsg("unsupported.encoding.msg", string);
    }

    static String getMsg(String string) {
        return bundle.getString(string);
    }

    static String getMsg(String string, Object object) {
        return MessageCatalog.getMsg(string, new Object[]{object});
    }

    static String getMsg(String string, Object[] objectArray) {
        String string2 = MessageCatalog.getMsg(string);
        if (objectArray != null) {
            MessageFormat messageFormat = (MessageFormat)threadLocal.get();
            messageFormat.applyPattern(string2);
            return messageFormat.format(objectArray);
        }
        return string2;
    }
}

