/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.io.IOException;
import java.io.InputStream;
import pervasive.database.PsqlException;
import pervasive.database.XCursor;

class BLOBInputStream
extends InputStream {
    private int _address;
    private int _chunkOffset;
    private XCursor _scursor;
    private int _available;

    BLOBInputStream(int n, int n2, XCursor xCursor, int n3) {
        this._address = n;
        this._chunkOffset = n2;
        this._scursor = xCursor;
        this._available = n3;
    }

    @Override
    public int read() throws IOException {
        if (this._available <= 0) {
            return -1;
        }
        int n = 0;
        try {
            byte[] byArray = this._scursor.getChunk(this._address, this._chunkOffset, 1);
            n = byArray[0];
            ++this._chunkOffset;
            --this._available;
        }
        catch (PsqlException psqlException) {
            throw new IOException(psqlException.getMessage());
        }
        return n &= 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._available <= 0) {
            return -1;
        }
        byte[] byArray2 = null;
        try {
            byArray2 = this._scursor.getChunk(this._address, this._chunkOffset, n2);
        }
        catch (PsqlException psqlException) {
            throw new IOException(psqlException.getMessage());
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this._chunkOffset += n2;
        this._available -= n2;
        return byArray2.length;
    }

    @Override
    public int available() throws IOException {
        return this._available;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
        super.mark(n);
    }
}

