/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Hashtable;
import java.util.Vector;
import pervasive.database.BufferMetaData;
import pervasive.database.CharsetUtils;
import pervasive.database.ColumnDef;
import pervasive.database.Consts;
import pervasive.database.DBURI;
import pervasive.database.DBUtil;
import pervasive.database.Database;
import pervasive.database.IBTRV;
import pervasive.database.IndexDef;
import pervasive.database.IndexMetaData;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlException;
import pervasive.database.PsqlOperationException;
import pervasive.database.PsqlUnsupportedEncodingException;
import pervasive.database.RowSet;
import pervasive.database.SCursor;
import pervasive.database.Session;
import pervasive.database.TableDDFInfo;
import pervasive.database.TableMetaData;

public class Table
implements Consts {
    int m_indcount = 0;
    String m_tname;
    String m_dfname;
    String m_owner;
    Database m_parent;
    TableMetaData m_meta;
    Vector m_rowsets = new Vector();
    Vector m_indexes = new Vector();
    Hashtable m_indnames = new Hashtable();
    SCursor m_cursor;
    String m_datapath;
    private IBTRV m_btrv;
    private int[] m_BLOBColumns = null;
    private String m_charsetName;
    private short m_tableFlag = 0;
    private Vector m_fieldFlagVector = new Vector();
    private final short TRUE_NULL_TABLE = (short)64;
    private final short NULLABLE_COLUMN = (short)4;
    private final short BINARY_COLUMN = (short)4096;

    Table(Database database, String string, String string2, String[] stringArray, String string3, IBTRV iBTRV) throws PsqlException {
        this.m_parent = database;
        this.m_tname = string;
        this.m_owner = string2;
        this.m_btrv = iBTRV;
        this.m_charsetName = string3;
        this.m_meta = new TableMetaData(this);
        this.m_cursor = database.createSCursor(64129);
        try {
            TableDDFInfo tableDDFInfo = this.m_btrv.getTableDDFInfo(this.m_tname);
            this.m_dfname = tableDDFInfo.dataPath;
            this.m_tableFlag = (short)tableDDFInfo.flags;
            this.buildColumnMD(tableDDFInfo.columnInfo);
            DBURI dBURI = DBURI.createTableURI(this.m_parent.getDatabaseURI().getHost(), this.m_parent.getDatabaseURI().getDBName(), this.m_tname);
            DBUtil.openDBResource(this.m_cursor, dBURI, string2);
            this.buildIndexes(this.m_cursor, tableDDFInfo);
            DBUtil.openDBResource(this.m_cursor, dBURI, string2);
        }
        catch (PsqlException psqlException) {
            this.m_cursor.close();
            throw psqlException;
        }
    }

    public Database getDatabase() {
        return this.m_parent;
    }

    public Session getSession() {
        return this.getDatabase().getSession();
    }

    public void setCharsetName(String string) throws PsqlUnsupportedEncodingException {
        if (!CharsetUtils.isSupportedCharsetName(string)) {
            throw new PsqlUnsupportedEncodingException(string);
        }
        this.m_charsetName = string;
    }

    public String getCharsetName() {
        return this.m_charsetName;
    }

    public TableMetaData getTableMetaData() {
        return this.m_meta;
    }

    public RowSet createRowSet() throws PsqlException {
        return this.createRowSet(0, 0, false);
    }

    public RowSet createRowSet(boolean bl) throws PsqlException {
        return this.createRowSet(0, 0, bl);
    }

    public RowSet createRowSet(int n, int n2) throws PsqlException {
        return this.createRowSet(n, n2, false);
    }

    public RowSet createRowSet(int n, int n2, boolean bl) throws PsqlException {
        RowSet rowSet = new RowSet(this, this.m_btrv, this.m_owner, n, n2, bl, this.m_charsetName, this.m_indexes.isEmpty() ? null : (BufferMetaData)this.m_indexes.firstElement());
        this.m_rowsets.addElement(rowSet);
        return rowSet;
    }

    public void setDataFileOwner(String string, int n) throws PsqlException {
        this.setDataFileOwner(string, n, 0);
    }

    public void setDataFileLongOwner(String string, int n) throws PsqlException {
        this.setDataFileOwner(string, n, 17000);
    }

    private void setDataFileOwner(String string, int n, int n2) throws PsqlException {
        int n3 = string.length() + 1;
        this.m_cursor.setDZString(0, n3, string);
        this.m_cursor.setKZString(0, n3, string);
        this.m_cursor.setDataSize(n3);
        int n4 = this.m_cursor.BTRV(29 + n2, n);
        if (n4 > 0) {
            throw new PsqlOperationException(29, n4);
        }
    }

    public void clearDataFileOwner() throws PsqlException {
        if (this.m_owner == null) {
            throw new PsqlException(MessageCatalog.getNoDataFileOwnerMsg());
        }
        int n = this.m_cursor.BTRV(30);
        if (n > 0) {
            throw new PsqlOperationException(29, n);
        }
    }

    public void close() {
        for (int i = this.m_rowsets.size() - 1; i >= 0; --i) {
            ((RowSet)this.m_rowsets.lastElement()).close();
        }
        this.m_cursor.close();
    }

    void childClosed(RowSet rowSet) {
        this.m_rowsets.removeElement(rowSet);
    }

    private void buildColumnMD(TableDDFInfo.ColumnDDFInfo[] columnDDFInfoArray) throws PsqlException {
        for (int i = 0; i < columnDDFInfoArray.length; ++i) {
            this.m_meta.addColumn(columnDDFInfoArray[i].offset, columnDDFInfoArray[i].name.trim(), columnDDFInfoArray[i].type, columnDDFInfoArray[i].size, columnDDFInfoArray[i].decimal, this.isNullableColumn((short)columnDDFInfoArray[i].flags), this.isBinaryColumn((short)columnDDFInfoArray[i].flags));
        }
    }

    private void buildIndexes(SCursor sCursor, TableDDFInfo tableDDFInfo) throws PsqlException {
        this.getIndexMD(sCursor, tableDDFInfo);
    }

    private void getIndexMD(SCursor sCursor, TableDDFInfo tableDDFInfo) throws PsqlException {
        int n = 16;
        int n2 = 18;
        int n3 = 20;
        int n4 = 26;
        int n5 = 30;
        sCursor.setDataSize(2000);
        sCursor.setKeySize(10);
        sCursor.setKeyNumber(0);
        int n6 = sCursor.BTRV(15);
        if (n6 > 0 && n6 == 22) {
            sCursor.setDataSize(64129);
            n6 = sCursor.BTRV(15);
            if (n6 > 0) {
                throw new PsqlOperationException(15, n6);
            }
        }
        this.m_meta.m_fileflags = sCursor.getDInt2(10);
        for (int i = sCursor.getDInt2(4); i > 0; --i) {
            short s;
            boolean bl = true;
            byte by = sCursor.getDBytes(n5, 1)[0];
            int n7 = 0;
            do {
                short s2 = sCursor.getDInt2(n);
                short s3 = sCursor.getDInt2(n2);
                s = sCursor.getDInt2(n3);
                int n8 = sCursor.getDBytes(n4, 1)[0] & 0xFF;
                TableDDFInfo.IndexDDFInfo indexDDFInfo = null;
                String string = null;
                if (n8 != 255) {
                    indexDDFInfo = this.findIndexDDFInfo(by, n7++, tableDDFInfo.indexInfo);
                    string = indexDDFInfo.name;
                    n8 = this.m_meta.getColumnDef(indexDDFInfo.columnName).getType();
                }
                if (n8 == 255) {
                    n += 16;
                    n2 += 16;
                    n3 += 16;
                    n4 += 16;
                    n5 += 16;
                    continue;
                }
                int n9 = s & 0x6CB;
                int n10 = indexDDFInfo.flags;
                ColumnDef columnDef = this.m_meta.getColumnByOffset(s2 - 1);
                IndexDef indexDef = columnDef == null ? new IndexDef(null, s2 - 1, n8, s3, 0, false, false, n9, n10) : new IndexDef(columnDef.getColumnName(), s2 - 1, n8, s3, 0, columnDef.isNullable(), columnDef.isBinary(), n9, n10);
                if (bl) {
                    if (this.m_indexes.size() < by) {
                        this.m_indexes.setSize(by + 1);
                    }
                    IndexMetaData indexMetaData = new IndexMetaData(this, indexDef, true, string);
                    this.m_indexes.insertElementAt(indexMetaData, by);
                    if (string != null) {
                        this.m_indnames.put(string, indexMetaData);
                    }
                    ++this.m_indcount;
                    bl = false;
                } else {
                    ((IndexMetaData)this.m_indexes.elementAt(by)).addOrig(indexDef);
                }
                n += 16;
                n2 += 16;
                n3 += 16;
                n4 += 16;
                n5 += 16;
            } while ((s & 0x10) != 0);
        }
    }

    private TableDDFInfo.IndexDDFInfo findIndexDDFInfo(int n, int n2, TableDDFInfo.IndexDDFInfo[] indexDDFInfoArray) {
        for (int i = 0; i < indexDDFInfoArray.length; ++i) {
            if (indexDDFInfoArray[i].index != n || indexDDFInfoArray[i].segment != n2) continue;
            return indexDDFInfoArray[i];
        }
        return null;
    }

    private boolean isTrueNullTable() {
        return (this.m_tableFlag & 0x40) == 64;
    }

    private boolean isNullableColumn(short s) {
        if (this.isTrueNullTable()) {
            return (s & 4) == 4;
        }
        return false;
    }

    private boolean isBinaryColumn(short s) {
        return (s & 0x1000) > 0;
    }

    private String findFullPath(SCursor sCursor, String[] stringArray) throws PsqlException {
        int n = 0;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i] + this.m_dfname;
            if (this.m_owner != null && this.m_owner.length() > 0) {
                sCursor.setDZString(0, this.m_owner.length() + 1, this.m_owner);
            }
            sCursor.setKZString(0, string2.length() + 1, string2);
            sCursor.setKeySize(string2.length() + 1);
            n = sCursor.BTRV(0);
            if (n == 0) {
                string = string2;
                break;
            }
            if (n == 12) continue;
            throw new PsqlOperationException(0, n, MessageCatalog.getTableOpenMsg(string2, this.m_owner));
        }
        if (string == null) {
            throw new PsqlOperationException(0, n, MessageCatalog.getInvalidDataPathMsg(this.m_parent.m_dataPath));
        }
        return string;
    }
}

