/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import pervasive.database.IOBuffer;
import pervasive.database.MessageCatalog;

class IntelIOBuffer
extends IOBuffer {
    IntelIOBuffer(int n, String string) {
        super(n, string);
    }

    IntelIOBuffer(byte[] byArray, String string) {
        super(byArray, string);
    }

    @Override
    public final short readShort(int n) {
        int n2 = 0;
        int n3 = 0;
        short s = 0;
        n2 = this.m_buf[n] < 0 ? this.m_buf[n] + 256 : this.m_buf[n];
        int n4 = n3 = this.m_buf[n + 1] < 0 ? this.m_buf[n + 1] + 256 : this.m_buf[n + 1];
        if (n2 < 0) {
            n2 <<= 8;
            n2 >>>= 8;
        }
        s = (short)(s | n2);
        s = (short)(s | n3 << 8);
        return s;
    }

    @Override
    public final void writeShort(short s, int n) {
        this.m_buf[n] = (byte)(s >>> 0 & 0xFF);
        this.m_buf[n + 1] = (byte)(s >>> 8 & 0xFF);
    }

    @Override
    public final int readInteger(int n) {
        int n2;
        int n3 = this.m_buf[n] < 0 ? this.m_buf[n] + 256 : this.m_buf[n];
        int n4 = this.m_buf[++n] < 0 ? this.m_buf[n] + 256 : this.m_buf[n];
        int n5 = this.m_buf[++n] < 0 ? this.m_buf[n] + 256 : this.m_buf[n];
        int n6 = n2 = this.m_buf[++n] < 0 ? this.m_buf[n] + 256 : this.m_buf[n];
        if (n3 < 0) {
            n3 <<= 24;
            n3 >>>= 24;
        }
        if (n4 < 0) {
            n4 <<= 24;
            n4 >>>= 24;
        }
        if (n5 < 0) {
            n5 <<= 24;
            n5 >>>= 24;
        }
        if (n2 < 0) {
            n2 <<= 24;
            n2 >>>= 24;
        }
        return (n2 << 24) + (n5 << 16) + (n4 << 8) + (n3 << 0);
    }

    @Override
    public final void writeInteger(int n, int n2) {
        this.m_buf[n2] = (byte)(n >>> 0 & 0xFF);
        this.m_buf[n2 + 1] = (byte)(n >>> 8 & 0xFF);
        this.m_buf[n2 + 2] = (byte)(n >>> 16 & 0xFF);
        this.m_buf[n2 + 3] = (byte)(n >>> 24 & 0xFF);
    }

    @Override
    public final long readLong(int n) {
        long l = this.m_buf[n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l2 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l3 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l4 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l5 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l6 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l7 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        long l8 = this.m_buf[++n] < 0 ? (long)(this.m_buf[n] + 256) : (long)this.m_buf[n];
        return (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + (l << 0);
    }

    @Override
    public final void writeLong(long l, int n) {
        this.m_buf[n] = (byte)(l >>> 0 & 0xFFL);
        this.m_buf[n + 1] = (byte)(l >>> 8 & 0xFFL);
        this.m_buf[n + 2] = (byte)(l >>> 16 & 0xFFL);
        this.m_buf[n + 3] = (byte)(l >>> 24 & 0xFFL);
        this.m_buf[n + 4] = (byte)(l >>> 32 & 0xFFL);
        this.m_buf[n + 5] = (byte)(l >>> 40 & 0xFFL);
        this.m_buf[n + 6] = (byte)(l >>> 48 & 0xFFL);
        this.m_buf[n + 7] = (byte)(l >>> 56 & 0xFFL);
    }

    @Override
    public final float readFloat(int n) {
        return Float.intBitsToFloat(this.readInteger(n));
    }

    @Override
    public final void writeFloat(float f, int n) {
        this.writeInteger(Float.floatToIntBits(f), n);
    }

    @Override
    public final double readDouble(int n) {
        return Double.longBitsToDouble(this.readLong(n));
    }

    @Override
    public final void writeDouble(double d, int n) {
        this.writeLong(Double.doubleToLongBits(d), n);
    }

    @Override
    public final double readBfloat(int n, int n2) {
        int n3;
        if (n2 != 4 && n2 != 8) {
            return 0.0;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[8];
        System.arraycopy(this.m_buf, n, byArray, 0, n2);
        if (byArray[n2 - 1] == 0) {
            return 0.0;
        }
        for (n3 = 0; n3 < 8; ++n3) {
            byArray2[n3] = 0;
        }
        byte by = (byte)(byArray[n2 - 2] & 0x80);
        short s = byArray[n2 - 1];
        if (s < 0) {
            s = (short)(s + 256);
        }
        int n4 = s - 129 + 1023;
        int n5 = n2 - 2;
        byArray[n5] = (byte)(byArray[n5] & 0x7F);
        byte by2 = 0;
        int n6 = 8 - n2;
        for (n3 = n2 - 2; n3 >= 0; --n3) {
            byte by3 = (byte)(byArray[n3] & 7);
            int n7 = n3;
            byArray[n7] = (byte)(byArray[n7] >> 3);
            byArray2[n3 + n6] = byArray[n3];
            int n8 = n3 + n6;
            byArray2[n8] = (byte)(byArray2[n8] & 0x1F);
            int n9 = n3 + n6;
            byArray2[n9] = (byte)(byArray2[n9] | by2);
            by2 = (byte)(by3 << 5);
        }
        if (n2 == 4) {
            byArray2[3] = (byte)(byArray2[3] | by2);
        }
        byArray2[6] = (byte)(byArray2[6] | (byte)(n4 << 4));
        byArray2[7] = (byte)(n4 >>> 4 | by);
        IntelIOBuffer intelIOBuffer = new IntelIOBuffer(byArray2, this.m_charsetName);
        long l = intelIOBuffer.readLong(0);
        return Double.longBitsToDouble(l);
    }

    @Override
    public final void writeBfloat(double d, int n, int n2) {
        IntelIOBuffer intelIOBuffer = new IntelIOBuffer(8, this.m_charsetName);
        long l = Double.doubleToLongBits(d);
        intelIOBuffer.writeLong(l, 0);
        this.writeBF(intelIOBuffer.getBufferData(), n, n2, d);
    }

    private final void writeBF(byte[] byArray, int n, int n2, double d) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            this.m_buf[n3 + n] = 0;
        }
        if (d == 0.0) {
            return;
        }
        byte by = (byte)(byArray[7] & 0x80);
        byte by2 = (byte)(byArray[6] >>> 4 & 0xF);
        int n4 = ((byArray[7] & 0x7F) << 4) + by2;
        if ((n4 -= 1023) > 127 || n4 < -128) {
            throw new IllegalArgumentException(MessageCatalog.getOverflowMsg(this, "writeBF", "BTR_BFLOAT(" + n2 + ")", new Double(d).toString()));
        }
        n4 += 129;
        for (n3 = n2 - 2; n3 >= 0; --n3) {
            this.m_buf[n3 + n] = (byte)(byArray[n3 + (8 - n2)] << 4);
            by2 = n3 + (7 - n2) < 0 ? (byte)0 : (byte)(byArray[n3 + (7 - n2)] >>> 4 & 0xF);
            int n5 = n3 + n;
            this.m_buf[n5] = (byte)(this.m_buf[n5] | by2);
        }
        for (n3 = 0; n3 < n2 - 2; ++n3) {
            this.m_buf[n3 + n] = by2 = (byte)(this.m_buf[n3 + n] >>> 1 & 0x7F);
            int n6 = n3 + n;
            this.m_buf[n6] = (byte)(this.m_buf[n6] | this.m_buf[n3 + n + 1] << 7);
        }
        this.m_buf[n + (n2 - 2)] = by2 = (byte)(this.m_buf[n + (n2 - 2)] >>> 1 & 0x7F);
        int n7 = n + (n2 - 2);
        this.m_buf[n7] = (byte)(this.m_buf[n7] | by);
        this.m_buf[n + (n2 - 1)] = (byte)n4;
    }
}

