/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlMalformedURIException;

public final class DBURI {
    private static String TABLE = "table";
    private static String DBFILE = "dbfile";
    private static String FILE = "file";
    private static String PROMPT = "prompt";
    private static String PASSWORD = "pwd";
    private String m_dbURIStr;
    private String m_escapedURIStr;
    private String m_protocol;
    private String m_host;
    private String m_user;
    private String m_password;
    private String m_dbname;
    private HashMap<String, String> m_params = new HashMap();

    public DBURI(String string) throws PsqlMalformedURIException {
        this.m_dbURIStr = string;
        try {
            StringTokenizer stringTokenizer = null;
            try {
                stringTokenizer = new StringTokenizer(string, "/:", true);
            }
            catch (NullPointerException nullPointerException) {
                throw new PsqlMalformedURIException(MessageCatalog.getMsg("malformed.database.uri", string));
            }
            try {
                this.m_protocol = stringTokenizer.nextToken();
            }
            catch (Exception exception) {
                throw new PsqlMalformedURIException(MessageCatalog.getMsg("missing.protocol.name.msg", string));
            }
            if (!stringTokenizer.hasMoreTokens() || stringTokenizer.nextToken().compareTo(":") != 0) {
                throw new PsqlMalformedURIException(MessageCatalog.getMsg("missing.protocol.name.msg", string));
            }
            if (!this.m_protocol.equalsIgnoreCase("btrv")) {
                throw new PsqlMalformedURIException(MessageCatalog.getMsg("unsupported.uri.protocol.msg", this.m_protocol));
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("File" + string.substring(this.m_protocol.length()));
            int n = stringBuilder.indexOf("@");
            if (n >= 0) {
                this.m_user = stringBuilder.substring(7, n);
                stringBuilder.delete(7, n);
            }
            URL uRL = new URL(stringBuilder.toString());
            this.m_host = this.fixIPv6Host(uRL.getHost());
            if (this.m_host.length() == 0) {
                this.m_host = null;
            }
            this.m_dbname = uRL.getPath();
            if (this.m_dbname.length() > 0) {
                this.m_dbname = this.m_dbname.substring(1);
            }
            this.parseQueryStr(uRL.getQuery());
        }
        catch (MalformedURLException malformedURLException) {
            throw new PsqlMalformedURIException(malformedURLException.getMessage());
        }
    }

    public DBURI(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.m_user = string;
        this.m_host = this.fixIPv6Host(string2);
        this.m_dbname = string3;
        this.m_params.put(PASSWORD, string4);
        this.m_params.put(TABLE, string5);
        this.m_params.put(DBFILE, string6);
        this.m_params.put(FILE, string7);
        this.m_params.put(PROMPT, string8);
    }

    public static DBURI createLoginURI(String string, String string2, String string3, String string4) {
        return new DBURI(string, string2, string3, string4, null, null, null, null);
    }

    public static DBURI createTableURI(String string, String string2, String string3) {
        return new DBURI(null, string, string2, null, string3, null, null, null);
    }

    public static DBURI createDBFileURI(String string, String string2, String string3) {
        return new DBURI(null, string, string2, null, null, string3, null, null);
    }

    public static DBURI createFileURI(String string, String string2, String string3) {
        return new DBURI(null, string, string2, null, null, null, string3, null);
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getDBName() {
        return this.m_dbname;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPassword() {
        return this.getParamValue(PASSWORD);
    }

    public String getPrompt() {
        return this.getParamValue(PROMPT);
    }

    public String getTable() {
        return this.getParamValue(TABLE);
    }

    public String getDBFile() {
        return this.getParamValue(DBFILE);
    }

    public String getFile() {
        return this.getParamValue(FILE);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DBURI)) {
            return false;
        }
        return object.toString().equals(this.toString());
    }

    public String toString() {
        return this.toStringInternal(false);
    }

    public String toEscapedString() {
        return this.toStringInternal(true);
    }

    private String toStringInternal(boolean bl) {
        int n;
        int n2;
        Object object;
        if (!bl && this.m_dbURIStr != null) {
            return this.m_dbURIStr;
        }
        if (bl && this.m_escapedURIStr != null) {
            return this.m_escapedURIStr;
        }
        StringBuilder stringBuilder = new StringBuilder("btrv://");
        if (this.m_user != null && this.m_user.length() > 0) {
            stringBuilder.append(this.m_user + "@");
        }
        if (this.m_host != null) {
            if (bl) {
                int n3;
                char c;
                boolean bl2;
                object = this.m_host;
                n2 = ((String)object).indexOf(":");
                n = -1;
                if (n2 >= 0 && (n = ((String)object).indexOf(":", n2 + 1)) >= 0 && !(bl2 = Character.isDigit(c = ((String)object).charAt((n3 = ((String)object).indexOf("%25")) + 3)))) {
                    object = ((String)object).replaceFirst("%", "%25");
                }
                stringBuilder.append((String)object);
            } else {
                stringBuilder.append(this.m_host);
            }
        }
        stringBuilder.append('/' + (this.m_dbname != null ? this.m_dbname : ""));
        object = this.m_params.entrySet().iterator();
        n2 = 1;
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
            if (n2 != 0) {
                stringBuilder.append('?');
                n2 = 0;
            } else {
                stringBuilder.append('&');
            }
            stringBuilder.append(string + "=" + string2);
        }
        for (n = stringBuilder.length() - 1; n >= 0 && stringBuilder.charAt(n) == '/'; --n) {
            stringBuilder.deleteCharAt(n);
        }
        if (bl) {
            this.m_escapedURIStr = stringBuilder.toString();
            return this.m_escapedURIStr;
        }
        this.m_dbURIStr = stringBuilder.toString();
        return this.m_dbURIStr;
    }

    private String getParamValue(String string) {
        return this.m_params.get(string.toLowerCase());
    }

    private void parseQueryStr(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            this.putParam(stringTokenizer.nextToken());
        }
    }

    private void putParam(String string) {
        int n = string.indexOf("=");
        if (n <= 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.m_params.put(string2.toLowerCase(), string3);
    }

    private String fixIPv6Host(String string) {
        int n;
        String string2 = string;
        if (string2 != null && -1 == (n = string2.indexOf("["))) {
            int n2 = string2.indexOf(":");
            int n3 = -1;
            if (n2 >= 0 && (n3 = string2.indexOf(":", n2 + 1)) >= 0) {
                string2 = "[" + string2 + "]";
            }
        }
        return string2;
    }
}

