/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.common.ObjectConverter;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.ParamDesc;
import com.pervasive.jdbc.lna.ParamDescSet;
import com.pervasive.jdbc.lna.ParamInfoSet;
import com.pervasive.jdbc.v2.Connection;
import com.pervasive.jdbc.v2.ParameterMetaData;
import com.pervasive.jdbc.v2.ResultSet;
import com.pervasive.jdbc.v2.ResultSetMetaData;
import com.pervasive.jdbc.v2.Statement;
import com.pervasive.util.convert.CalendarConverter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    protected String d_sql;
    protected ColumnInfoSet d_cis;
    protected ParamDescSet d_pds;
    protected ParamInfoSet d_pis;
    protected Vector<ParamInfoSet> d_pisBatch;

    PreparedStatement(Connection connection, String string, int n, int n2) throws SQLException {
        super(connection, n, n2);
        this.d_sql = string;
        this.d_cis = new ColumnInfoSet();
        this.d_pds = new ParamDescSet();
        this.d_lnaStmt.prepare(this.d_sql, this.d_cis, this.d_pds);
        this.d_pis = new ParamInfoSet(this.d_pds);
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        this.execute();
        if (this.d_curResults == null) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_QUERY, "24000", 0);
        }
        return this.d_curResults;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        if (this.d_updateCount == -1) {
            throw new SQLException(LocalStrings.ERR_SQL_NOT_UPDATE, "S1000", 0);
        }
        return this.d_updateCount;
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.d_pis.setInParameter(n, null);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = -7;
            this.d_pis.getItem(n - 1).setDataType((short)-7);
            this.d_pis.getItem(n - 1).setBindType((short)5);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Boolean(bl)));
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 5;
            this.d_pis.getItem(n - 1).setDataType((short)5);
            this.d_pis.getItem(n - 1).setBindType((short)5);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Byte(by)));
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 5;
            this.d_pis.getItem(n - 1).setDataType((short)5);
            this.d_pis.getItem(n - 1).setBindType((short)5);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Short(s)));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        int n3 = this.d_pis.getItem(n - 1).getDataType();
        if (n3 == 0) {
            n3 = 4;
            this.d_pis.getItem(n - 1).setDataType((short)4);
            this.d_pis.getItem(n - 1).setBindType((short)4);
        }
        if (n3 == 5) {
            if (n2 > Short.MAX_VALUE) {
                this.d_pis.getItem(n - 1).setBindType((short)-17);
            } else {
                this.d_pis.getItem(n - 1).selectBinding();
            }
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Integer(n2), false));
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = -5;
            this.d_pis.getItem(n - 1).setDataType((short)-5);
            this.d_pis.getItem(n - 1).setBindType((short)-25);
        }
        if (n2 == 4) {
            if (l > Integer.MAX_VALUE) {
                this.d_pis.getItem(n - 1).setBindType((short)-18);
            } else {
                this.d_pis.getItem(n - 1).selectBinding();
            }
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Long(l), false));
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 8;
            this.d_pis.getItem(n - 1).setDataType((short)8);
            this.d_pis.getItem(n - 1).setBindType((short)8);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Float(f)));
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 8;
            this.d_pis.getItem(n - 1).setDataType((short)8);
            this.d_pis.getItem(n - 1).setBindType((short)8);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, new Double(d)));
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 3;
            this.d_pis.getItem(n - 1).setDataType((short)3);
            this.d_pis.getItem(n - 1).setBindType((short)1);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, bigDecimal));
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        short s = this.d_pis.getItem(n - 1).getDataType();
        if (s == 0) {
            s = 1;
            this.d_pis.getItem(n - 1).setDataType((short)1);
            this.d_pis.getItem(n - 1).setBindType((short)1);
        }
        if (s == -3 || s == -4) {
            this.setUnicodeStream(n, new StringBufferInputStream(string), string.length());
        } else if (s == -1 || s == -10) {
            this.setUnicodeStream(n, new StringReader(string), string.length());
        } else {
            this.d_pis.setInParameter(n, this.convertObject(n, string));
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = -2;
            this.d_pis.getItem(n - 1).setDataType((short)-2);
            this.d_pis.getItem(n - 1).setBindType((short)-2);
        }
        this.d_pis.setInParameter(n, byArray);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 9;
            this.d_pis.getItem(n - 1).setDataType((short)9);
            this.d_pis.getItem(n - 1).setBindType((short)9);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, date));
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 10;
            this.d_pis.getItem(n - 1).setDataType((short)10);
            this.d_pis.getItem(n - 1).setBindType((short)10);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, time));
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        int n2 = this.d_pis.getItem(n - 1).getDataType();
        if (n2 == 0) {
            n2 = 11;
            this.d_pis.getItem(n - 1).setDataType((short)11);
            this.d_pis.getItem(n - 1).setBindType((short)11);
        }
        this.d_pis.setInParameter(n, this.convertObject(n, timestamp));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.d_pis.getItem(n - 1).getDataType();
        if (n3 == 0) {
            n3 = -1;
            this.d_pis.getItem(n - 1).setDataType((short)-1);
            this.d_pis.getItem(n - 1).setBindType((short)1);
        }
        this.d_pis.setInParameter(n, inputStream);
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.d_pis.getItem(n - 1).getDataType();
        if (n3 == 0) {
            n3 = -1;
            this.d_pis.getItem(n - 1).setDataType((short)-1);
            this.d_pis.getItem(n - 1).setBindType((short)1);
        }
        this.d_pis.setInParameter(n, inputStream);
    }

    public void setUnicodeStream(int n, StringReader stringReader, int n2) throws SQLException {
        int n3 = this.d_pis.getItem(n - 1).getDataType();
        if (n3 == 0) {
            n3 = -1;
            this.d_pis.getItem(n - 1).setDataType((short)-1);
            this.d_pis.getItem(n - 1).setBindType((short)1);
        }
        this.d_pis.setInParameter(n, stringReader);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.d_pis.getItem(n - 1).getDataType();
        if (n3 == 0) {
            n3 = -4;
            this.d_pis.getItem(n - 1).setDataType((short)-4);
            this.d_pis.getItem(n - 1).setBindType((short)-2);
        }
        this.d_pis.setInParameter(n, inputStream);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.d_pis.clearParameterValues();
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case 3: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new BigDecimal(object.toString()), 3, n3);
                break;
            }
            case 2: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new BigDecimal(object.toString()), 2, n3);
                break;
            }
            case -5: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Long(new BigDecimal(object.toString()).setScale(n3).longValue()), -5, n3);
                break;
            }
            case 4: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Integer(new BigDecimal(object.toString()).setScale(n3).intValue()), 4, n3);
                break;
            }
            case 5: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Integer(new BigDecimal(object.toString()).setScale(n3).intValue()), 5, n3);
                break;
            }
            case -6: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Integer(new BigDecimal(object.toString()).setScale(n3).intValue()), -6, n3);
                break;
            }
            case -1: {
                this.d_pis.setInParameter(n, object.toString(), -1, n3);
                break;
            }
            case -16: {
                this.d_pis.setInParameter(n, object.toString(), -10, n3);
                break;
            }
            case -4: {
                this.d_pis.setInParameter(n, object.toString().getBytes(), -4, n3);
                break;
            }
            case 12: {
                this.d_pis.setInParameter(n, object.toString(), 12, n3);
                break;
            }
            case 1: {
                this.setString(n, object.toString());
                break;
            }
            case -7: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Boolean(new BigDecimal(object.toString()).setScale(n3).intValue() == 1));
                break;
            }
            case 16: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Boolean(new BigDecimal(object.toString()).setScale(n3).intValue() == 1));
                break;
            }
            case -2: {
                this.setBytes(n, object.toString().getBytes());
                break;
            }
            case -3: {
                this.d_pis.setInParameter(n, object.toString().getBytes(), -3, n3);
                break;
            }
            case 9: 
            case 91: {
                try {
                    this.setDate(n, com.pervasive.util.convert.ObjectConverter.convertDate(object));
                    break;
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
            }
            case 10: 
            case 92: {
                try {
                    this.setTime(n, com.pervasive.util.convert.ObjectConverter.convertTime(object));
                    break;
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
            }
            case 11: 
            case 93: {
                try {
                    this.setTimestamp(n, com.pervasive.util.convert.ObjectConverter.convertTimestamp(object));
                    break;
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
            }
            case 7: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Float(new BigDecimal(object.toString()).floatValue()), 7, n3);
                break;
            }
            case 6: 
            case 8: {
                object = this.covertBoolAndStrToNum(object);
                this.d_pis.setInParameter(n, new Double(new BigDecimal(object.toString()).doubleValue()), 8, n3);
                break;
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw new SQLException(LocalStrings.ERR_SQL_INVALID_DATA_TYPE);
            }
            default: {
                this.setString(n, object.toString());
            }
        }
    }

    Object covertBoolAndStrToNum(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? new Integer(1) : new Integer(0);
        }
        if (object instanceof String) {
            if (((String)object).equalsIgnoreCase("true")) {
                return new Integer(1);
            }
            if (((String)object).equalsIgnoreCase("false")) {
                return new Integer(0);
            }
        }
        return object;
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, (int)this.d_pds.getItem(n - 1).getScale());
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        ParamDesc paramDesc = this.d_pds.getItem(n - 1);
        switch (paramDesc.getDataType()) {
            case -11: 
            case 1: {
                this.setObject(n, object, 1, (int)paramDesc.getScale());
                break;
            }
            case -8: {
                this.setObject(n, object, -15, (int)paramDesc.getScale());
                break;
            }
            case 12: {
                this.setObject(n, object, 12, (int)paramDesc.getScale());
                break;
            }
            case -9: {
                this.setObject(n, object, -9, (int)paramDesc.getScale());
                break;
            }
            case 2: {
                this.setObject(n, object, 2, (int)paramDesc.getScale());
                break;
            }
            case 3: {
                this.setObject(n, object, 3, (int)paramDesc.getScale());
                break;
            }
            case 4: {
                this.setObject(n, object, 4, (int)paramDesc.getScale());
                break;
            }
            case -5: {
                this.setObject(n, object, -5, (int)paramDesc.getScale());
                break;
            }
            case 5: {
                this.setObject(n, object, 5, (int)paramDesc.getScale());
                break;
            }
            case -6: {
                this.setObject(n, object, -6, (int)paramDesc.getScale());
                break;
            }
            case 6: {
                this.setObject(n, object, 6, (int)paramDesc.getScale());
                break;
            }
            case 8: {
                this.setObject(n, object, 8, (int)paramDesc.getScale());
                break;
            }
            case 7: {
                this.setObject(n, object, 7, (int)paramDesc.getScale());
                break;
            }
            case 9: {
                this.setObject(n, object, 91, (int)paramDesc.getScale());
                break;
            }
            case 10: {
                this.setObject(n, object, 92, (int)paramDesc.getScale());
                break;
            }
            case 11: {
                this.setObject(n, object, 93, (int)paramDesc.getScale());
                break;
            }
            case -1: {
                this.setObject(n, object, -1, (int)paramDesc.getScale());
                break;
            }
            case -10: {
                this.setObject(n, object, -16, (int)paramDesc.getScale());
                break;
            }
            case -2: {
                this.setObject(n, object, -2, (int)paramDesc.getScale());
                break;
            }
            case -3: {
                this.setObject(n, object, -3, (int)paramDesc.getScale());
                break;
            }
            case -4: {
                this.setObject(n, object, -4, (int)paramDesc.getScale());
                break;
            }
            case -7: {
                this.setObject(n, object, -7, (int)paramDesc.getScale());
                break;
            }
            default: {
                throw new RuntimeException(LocalStrings.ERR_SQL_INVALID_DATA_TYPE);
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.clearResults();
        int n = this.d_lnaStmt.execute(this.d_pis);
        if (this.d_curResults != null) {
            this.d_curResults.close();
            this.d_curResults = null;
        }
        if (this.d_cis.getCount() > 0) {
            this.d_curResults = new ResultSet((Statement)this, this.d_cis, this.d_sql);
        } else {
            this.d_updateCount = n;
        }
        return this.d_curResults != null;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLException(LocalStrings.ERR_NOT_IMPL);
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.d_pisBatch == null) {
            this.d_pisBatch = new Vector();
        }
        this.d_pisBatch.addElement(this.d_pis);
        this.d_pis = new ParamInfoSet(this.d_pds);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.d_pisBatch != null) {
            this.d_pisBatch.removeAllElements();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int n = this.d_pisBatch != null ? this.d_pisBatch.size() : 0;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.d_lnaStmt.execute(this.d_pisBatch.elementAt(0));
                this.d_pisBatch.removeElement(this.d_pisBatch.elementAt(0));
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
        }
        return nArray;
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setObject(n, reader);
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.d_conn.getLNAConnection(), this.d_cis);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.d_pis.setInParameter(n, date);
        } else {
            this.d_pis.setInParameter(n, CalendarConverter.changeCalendar(date, calendar, Calendar.getInstance()));
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.d_pis.setInParameter(n, time);
        } else {
            this.d_pis.setInParameter(n, CalendarConverter.changeCalendar(time, calendar, Calendar.getInstance()));
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.d_pis.setInParameter(n, timestamp);
        } else {
            this.d_pis.setInParameter(n, CalendarConverter.changeCalendar(timestamp, calendar, Calendar.getInstance()));
        }
    }

    private Object convertObject(int n, Object object, boolean bl) throws SQLException {
        if (bl) {
            this.d_pis.getItem(n - 1).selectBinding();
        }
        short s = this.d_pis.getItem(n - 1).getDataType();
        short s2 = this.d_pis.getItem(n - 1).getBindType();
        int n2 = this.d_pis.getItem(n - 1).getPrecision();
        short s3 = this.d_pis.getItem(n - 1).getScale();
        return ObjectConverter.convertObject(object, s, s2, n2, s3);
    }

    private Object convertObject(int n, Object object) throws SQLException {
        return this.convertObject(n, object, true);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        return new ParameterMetaData(this.d_pds, this.d_pis);
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.setString(n, string);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new SQLException(LocalStrings.ERR_VALUE_OUT_OF_RANGE);
        }
        this.setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setObject(n, reader);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException(LocalStrings.ERR_LENGTH_OUT_OF_RANGE);
        }
        this.setAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException(LocalStrings.ERR_LENGTH_OUT_OF_RANGE);
        }
        this.setBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

