/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNAStatement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class LongDataInputStream
extends InputStream {
    private static final int CHUNK_SIZE = 8192;
    private LNAStatement d_lnaStmt;
    private short d_columnIndex;
    private short d_cDataType;
    private byte[] d_buf;
    private int d_pos;
    private int d_count;
    private boolean d_eof;
    private boolean d_isClosed;
    private boolean d_isNull;
    private boolean d_firstFetch;

    public LongDataInputStream(LNAStatement lNAStatement, short s, short s2) {
        this.d_lnaStmt = lNAStatement;
        this.d_columnIndex = s;
        this.d_cDataType = s2;
        this.d_isNull = false;
        this.d_firstFetch = true;
    }

    public boolean isNull() throws IOException {
        if (this.d_firstFetch) {
            this.ensureOpen();
            this.fillBuffer();
        }
        return this.d_isNull;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.d_pos == this.d_count && !this.d_eof) {
            this.fillBuffer();
        }
        return this.d_pos < this.d_count ? this.d_buf[this.d_pos++] : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n2 > 0) {
            if (this.d_pos == this.d_count && !this.d_eof) {
                this.fillBuffer();
            }
            if (this.d_pos < this.d_count) {
                int n3 = Math.min(n2, this.d_count - this.d_pos);
                System.arraycopy(this.d_buf, this.d_pos, byArray, n, n3);
                this.d_pos += n3;
                return n3;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public long skip(long l) throws IOException {
        this.ensureOpen();
        if (l > 0L) {
            long l2;
            int n;
            for (l2 = l; l2 > 0L; l2 -= (long)n) {
                if (this.d_pos == this.d_count && !this.d_eof) {
                    this.fillBuffer();
                }
                if (this.d_pos >= this.d_count) break;
                n = (int)Math.min(l2, (long)(this.d_count - this.d_pos));
                this.d_pos += n;
            }
            return l - l2;
        }
        return 0L;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.d_count - this.d_pos;
    }

    @Override
    public void close() throws IOException {
        this.d_isClosed = true;
        this.d_buf = null;
    }

    private void ensureOpen() throws IOException {
        if (this.d_isClosed) {
            throw new IOException(LocalStrings.ERR_STREAM_CLOSED);
        }
    }

    private void fillBuffer() throws IOException {
        try {
            if (this.d_buf == null) {
                this.d_buf = new byte[8192];
            }
            this.d_pos = 0;
            this.d_count = this.d_lnaStmt.getLongData(this.d_columnIndex, this.d_cDataType, this.d_buf.length, this.d_buf);
            int n = 8192;
            if (this.d_cDataType == 1) {
                --n;
            } else if (this.d_cDataType == -8) {
                n -= 2;
            }
            if (this.d_count < n) {
                this.d_eof = true;
            }
            if (this.d_firstFetch && this.d_count == -1) {
                this.d_isNull = true;
                this.d_firstFetch = false;
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }
}

