/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DBDetails;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIInfo;
import com.pervasive.psql.utilities.javadti.DTIUtils;
import com.pervasive.psql.utilities.javadti.Messages;
import com.pervasive.psql.utilities.javadti.javadti;
import com.pervasive.psql.utilities.javadti.javadtiConstants;
import java.util.logging.Logger;

public class DBCatalogInfo {
    private static Connection conObj = null;
    private static Logger logger;
    private static DBCatalogInfo dbObj;
    private static boolean bExists;
    private final int BUFFERSIZE = 512;
    private DBDetails[] dbList = null;

    static {
        dbObj = null;
        bExists = false;
    }

    private DBCatalogInfo() throws DTIException {
        logger = Logger.getLogger(DTIInfo.getLoggerName());
    }

    public static DBCatalogInfo getObj(Connection connection) throws DTIException {
        if (!bExists) {
            dbObj = new DBCatalogInfo();
            bExists = true;
        }
        if (connection != conObj) {
            conObj = connection;
            DBCatalogInfo.dbObj.dbList = null;
        }
        return dbObj;
    }

    public long getCount() throws DTIException {
        return this.getDbList().length;
    }

    private String getDBName(int n) throws DTIException {
        assert (n <= this.dbList.length) : "Invalid sequence number";
        long[] lArray = new long[]{512L};
        byte[] byArray = new byte[512];
        int n2 = javadti.JPvGetDbName(conObj.getHandle(), n, lArray, byArray);
        String string = "";
        if (n2 != DTICONSTS.P_OK) {
            logger.warning("JPvGetDbName failed: " + DTICONSTS.getErrorDesc(n2));
            throw new DTIException(n2);
        }
        string = DTIUtils.getLocaleString(byArray);
        logger.finer("JPvGetDbName Success, DatabaseName: " + string + " Size: " + lArray[0]);
        return string;
    }

    public void freeData() throws DTIException {
    }

    public String getServerName(String string) throws DTIException {
        if (string.length() == 0) {
            return "";
        }
        String string2 = "";
        long[] lArray = new long[]{512L};
        byte[] byArray = new byte[512];
        short[] sArray = new short[]{-1};
        int n = javadti.JPvGetDbServerName(conObj.getHandle(), string, lArray, byArray, sArray);
        if (n != DTICONSTS.P_OK) {
            logger.warning("JPvGetDbServerName failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        string2 = DTIUtils.getLocaleString(byArray);
        logger.finer("JPvGetDbServerName Success - Name: " + string2);
        return string2;
    }

    public String getDictionaryPath(String string) throws DTIException {
        if (string.length() == 0) {
            return "";
        }
        String string2 = "";
        long[] lArray = new long[]{512L};
        byte[] byArray = new byte[512];
        int n = javadti.JPvGetDbDictionaryPath(conObj.getHandle(), string, lArray, byArray);
        if (n != DTICONSTS.P_OK) {
            logger.warning("JPvGetDbDictionaryPath failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        string2 = DTIUtils.getLocaleString(byArray);
        logger.finer("JPvGetDbDictionaryPath Success - Path: " + string2);
        return string2;
    }

    public String getDataPath(String string) throws DTIException {
        if (string.length() == 0) {
            return "";
        }
        String string2 = "";
        long[] lArray = new long[]{512L};
        byte[] byArray = new byte[512];
        int n = javadti.JPvGetDbDataPath(conObj.getHandle(), string, lArray, byArray);
        if (n != DTICONSTS.P_OK) {
            logger.warning("JPvGetDbDataPath failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        string2 = DTIUtils.getLocaleString(byArray);
        logger.finer("JPvGetDbDataPath Success - Path: " + string2);
        return string2;
    }

    public void BuildDBList() throws DTIException {
        this.dbList = null;
        this.getDbList();
    }

    public String GetMatchDictPath(String string) throws DTIException {
        assert (string.length() > 0) : "ERROR! dataPath cannot be blank";
        this.BuildDBList();
        int n = 0;
        while (n < this.dbList.length) {
            if (this.dbList[n].getDbDataPath().compareToIgnoreCase(string) == 0) {
                return this.dbList[n].getDbDictPath();
            }
            ++n;
        }
        return "";
    }

    public void PrintDBList() throws DTIException {
        this.getDbList();
        int n = 0;
        while (n < this.dbList.length) {
            System.out.println("Name: " + this.dbList[n].getDbname());
            System.out.println("Dict Path: " + this.dbList[n].getDbDictPath());
            System.out.println("Data Path: " + this.dbList[n].getDbDataPath());
            ++n;
        }
    }

    public void createDatabase(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, int n2, boolean bl6) throws DTIException {
        int n3 = 0;
        n3 |= bl ? javadtiConstants.P_DBFLAG_RI : 0;
        n3 |= bl2 ? javadtiConstants.P_DBFLAG_BOUND : 0;
        n3 |= bl3 ? javadtiConstants.P_DBFLAG_CREATE_DDF : 0;
        int n4 = javadti.JPvCreateDatabase2(conObj.getHandle(), string, string2, string2, n3 |= bl5 ? javadtiConstants.P_DBFLAG_LONGMETADATA : 0, n2);
        if (n4 == DTICONSTS.P_OK || n4 == DTICONSTS.P_E_DUPLICATE_NAME) {
            logger.finer("Create Database Success.");
            if (bl4 && (n4 = javadti.JPvCreateDSN2(conObj.getHandle(), string, string, string, n, javadtiConstants.DSNFLAG_DEFAULT)) != DTICONSTS.P_OK) {
                throw new DTIException(n4, "PvCreateDSN2", Messages.get("dti.dsn.error"));
            }
        } else {
            logger.finer("Create Database Failed: " + DTICONSTS.getErrorDesc(n4));
            throw new DTIException(n4, "PvCreateDatabase2", "");
        }
    }

    public void modifyDatabase(String string, String string2, String string3, String string4) throws DTIException {
        this.modifyDatabase(string, string2, string3, string4, javadtiConstants.P_DBFLAG_NA);
    }

    public void modifyDatabase(String string, String string2, String string3, String string4, long l) throws DTIException {
        int n;
        if (l == (long)javadtiConstants.P_DBFLAG_NA) {
            try {
                l = this.getDBFlags(string);
            }
            catch (DTIException dTIException) {
                throw new DTIException(dTIException.getMessage());
            }
        }
        if ((n = javadti.JPvModifyDatabase(conObj.getHandle(), string, string2, string3, string4, l)) != DTICONSTS.P_OK) {
            logger.finer("Modify Database Failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        logger.finer("Modify Database Success.");
    }

    public void modifyDatabase2(String string, String string2, String string3, String string4, long l, int n) throws DTIException {
        int n2;
        if (l == (long)javadtiConstants.P_DBFLAG_NA) {
            try {
                l = this.getDBFlags(string);
            }
            catch (DTIException dTIException) {
                throw new DTIException(dTIException.getMessage());
            }
        }
        if ((n2 = javadti.JPvModifyDatabase2(conObj.getHandle(), string, string2, string3, string4, l, n)) != DTICONSTS.P_OK) {
            logger.finer("Modify Database Failed: " + DTICONSTS.getErrorDesc(n2));
            throw new DTIException(n2);
        }
        logger.finer("Modify Database Success.");
    }

    public long getDBFlags(String string) throws DTIException {
        long[] lArray = new long[1];
        int n = javadti.JPvGetDbFlags(conObj.getHandle(), string, lArray);
        if (n == DTICONSTS.P_OK) {
            logger.finer("Get DB flags Success.");
            return lArray[0];
        }
        logger.finer("Get DB flags Failed: " + DTICONSTS.getErrorDesc(n));
        throw new DTIException(n);
    }

    public int getDbCodePage(String string) throws DTIException {
        int[] nArray = new int[1];
        int n = javadti.JPvGetDbCodePage(conObj.getHandle(), string, nArray);
        if (n == DTICONSTS.P_OK) {
            logger.finer("Get DB code page Success.");
            return nArray[0];
        }
        logger.finer("Get DB code page Failed: " + DTICONSTS.getErrorDesc(n));
        throw new DTIException(n);
    }

    public void dropDatabase(String string, boolean bl) throws DTIException {
        boolean bl2 = true;
        int n = javadti.JPvDropDatabase(conObj.getHandle(), string, (char)((bl ? bl2 : false) ? 1 : 0));
        if (n != DTICONSTS.P_OK) {
            logger.finer("Drop Database Failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        logger.finer("Drop Database Success.");
    }

    private int internalInit() throws DTIException {
        long[] lArray = new long[1];
        int n = javadti.JPvGetDbNamesData(conObj.getHandle(), lArray);
        if (n != DTICONSTS.P_OK) {
            logger.warning("JPvGetDbNamesData failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n, "PvGetDbNamesData", "");
        }
        logger.finer("JPvGetDbNamesData Success, DatabaseCount: " + lArray[0]);
        return (int)lArray[0];
    }

    private void internalFree() throws DTIException {
        int n = javadti.JPvFreeDbNamesData(conObj.getHandle());
        if (n != DTICONSTS.P_OK) {
            logger.warning("JPvFreeDbNamesData failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        logger.finer("JPvFreeDbNamesData Success");
    }

    public DBDetails[] getDbList() throws DTIException {
        if (this.dbList != null) {
            return this.dbList;
        }
        try {
            int n = this.internalInit();
            this.dbList = new DBDetails[n];
            int n2 = 0;
            while (n2 < this.dbList.length) {
                this.dbList[n2] = new DBDetails(conObj);
                this.dbList[n2].setDbname(this.getDBName(n2 + 1));
                ++n2;
            }
        }
        finally {
            this.internalFree();
        }
        return this.dbList;
    }
}

