/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.PVCATEGORYINFO;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.logging.Logger;

public class Category {
    private long m_count;
    private Connection conObj = null;
    private final Logger logger;

    public Category(Connection connection, String string) {
        this.conObj = connection;
        this.logger = Logger.getLogger(string);
    }

    public long getList(long[] lArray) throws DTIException {
        long[] lArray2 = new long[]{lArray.length};
        int n = javadti.JPvGetCategoryList(this.conObj.getHandle(), lArray2, lArray);
        if (n == DTICONSTS.P_OK) {
            this.logger.finer("GetList() Category count: " + lArray2);
            this.m_count = lArray2[0];
            return this.m_count;
        }
        this.logger.finer("Category GetList() Failed" + DTICONSTS.getErrorDesc(n));
        throw new DTIException(n);
    }

    public long getCount() throws DTIException {
        long[] lArray = new long[]{100L};
        int n = javadti.JPvGetCategoryListCount(this.conObj.getHandle(), lArray);
        if (n == DTICONSTS.P_OK) {
            this.logger.finer("GetCount() Category count: " + lArray);
            this.m_count = lArray[0];
            return this.m_count;
        }
        this.logger.finer("Category GetCount() Failed" + DTICONSTS.getErrorDesc(n));
        throw new DTIException(n);
    }

    public PVCATEGORYINFO getInfo(long l) throws DTIException {
        PVCATEGORYINFO pVCATEGORYINFO = new PVCATEGORYINFO();
        int n = javadti.JPvGetCategoryInfo(this.conObj.getHandle(), l, pVCATEGORYINFO);
        if (n == DTICONSTS.P_OK) {
            this.logger.finer("GetInfo() Category Name: " + pVCATEGORYINFO.getCName());
            return pVCATEGORYINFO;
        }
        this.logger.finer("Category GetCount() Failed" + DTICONSTS.getErrorDesc(n));
        pVCATEGORYINFO.delete();
        throw new DTIException(n);
    }
}

