#!/bin/sh

echo "+++++ Checking current user rights..."

if [ "$(id -u root)" = "$(id -u)" ] ; then
    echo "Passed..."
else
    echo "ERROR: The current user id is not root (`id|awk '{print $1}'`)."
    exit 1
fi
echo

if [ "X$ACTIANZEN_ROOT" = "X" ] ; then
    ACTIANZEN_ROOT=/usr/local/actianzen
fi
export ACTIANZEN_ROOT

LIBDIR=lib

PATH=$ACTIANZEN_ROOT/bin:$PATH

if [ $(uname -s) = "Darwin" ]
then
    DYLD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    SO_EXTENSION="dylib"
else
    LD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
    SO_EXTENSION="so"
fi

USERNAME=zen-svc

for FILE in $ACTIANZEN_ROOT/$LIBDIR/libpsqlmif.${SO_EXTENSION}.[0-9]*
do
    if [ \( -f $FILE \) -a \( ! -h $FILE \) ]; then
        MIF_FILE=$FILE
        break
    fi
done
if [ "$MIF_FILE" ]; then
    # ..../libpsqlmif.so.15.10.NNN.MMM --> 15
    # ..../libpsqlmif.so.15 -> 15
    PSQL_VER=`echo $MIF_FILE | sed -e 's/^.*\.'"${SO_EXTENSION}"'\.\([0-9]*\).*$/\1/'`
else
    if [ $(uname -s) = "Darwin" ]; then
        # ..../libpsqlmif.15.dylib --> 15
        for FILE in $ACTIANZEN_ROOT/$LIBDIR/libpsqlmif.[0-9]*.dylib
        do
            if [ \( -f $FILE \) -a \( ! -h $FILE \) ]; then
                MIF_FILE=$FILE
                break
            fi
        done
        PSQL_VER=`echo $MIF_FILE | sed -e 's/^.*\.\([0-9]*\)\.dylib$/\1/'`
    fi
fi
echo "++++ MIF_FILE: $MIF_FILE (PSQL_VER $PSQL_VER)"
PS_VER=$PSQL_VER

echo +++++ Unregistering the PCOM libraries...

PSREGSVR=psregsvr

dso_unregister () {
    dso=$1
    if [ -f $ACTIANZEN_ROOT/$LIBDIR/$dso ]; then
        $ACTIANZEN_ROOT/bin/$PSREGSVR -u $ACTIANZEN_ROOT/$LIBDIR/$dso
    fi
}
dso_unregister libpctlgrb.${SO_EXTENSION}
dso_unregister libpceurop.${SO_EXTENSION}
dso_unregister libpssax.${SO_EXTENSION}
dso_unregister libpsdom.${SO_EXTENSION}
dso_unregister libpsutilrb.${SO_EXTENSION}
dso_unregister libclientrb.${SO_EXTENSION}
dso_unregister libupiapirb.${SO_EXTENSION}
dso_unregister libcsi100.${SO_EXTENSION}
dso_unregister libmkc3.${SO_EXTENSION}
dso_unregister libpvmsgrb.${SO_EXTENSION}
dso_unregister libpsqlcsm.${SO_EXTENSION}
dso_unregister libpsqlcsp.${SO_EXTENSION}
dso_unregister libdbcsipxy.${SO_EXTENSION}
dso_unregister libpscp932.${SO_EXTENSION}
dso_unregister libsrderb.${SO_EXTENSION}
echo


echo "+++++ Removing symbolic links to libraries..."

dso_unsymlink () {
    dso=$1
    ver=$2
    found="no"
    if [ -h $ACTIANZEN_ROOT/lib/$dso ]; then
        rm -f $ACTIANZEN_ROOT/lib/$dso
        found="yes"
    fi
    if [ -h $ACTIANZEN_ROOT/lib/$dso.$ver ]; then
        rm -f $ACTIANZEN_ROOT/lib/$dso.$ver
        found="yes"
    fi
    if [ "x$found" = "xno" ]; then
        echo unsymlink failed: $dso ver $ver
    fi
}
dso_unsymlink libodbc.${SO_EXTENSION} 1
if [ $(uname -s) = "Darwin" ]
then
    dso_unsymlink libodbccr.${SO_EXTENSION} 1
fi
dso_unsymlink libodbcci.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpscore.${SO_EXTENSION} $PS_VER
dso_unsymlink libpscl.${SO_EXTENSION} $PS_VER
dso_unsymlink libxlate.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqldti.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libclientlm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libels.${SO_EXTENSION}
dso_unsymlink libbtrieveC.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libbtrieveCpp.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlmif.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlnsl.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsxdebug.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpctlgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsutilrb.${SO_EXTENSION} $PS_VER
dso_unsymlink libpceurop.${SO_EXTENSION} $PS_VER
dso_unsymlink libpseucjp.${SO_EXTENSION} $PS_VER
dso_unsymlink libpscp932.${SO_EXTENSION} $PS_VER
dso_unsymlink libpssax.${SO_EXTENSION} $PS_VER
dso_unsymlink libpsdom.${SO_EXTENSION} $PS_VER
dso_unsymlink libclientrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkc3.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlmpm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libupiapirb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvmsgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcsm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcsp.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libdbcsipxy.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsrderb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libcsi100.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libels.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libenginelm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink liblegacylm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink liblicmgrrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libjnibtrv.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvjdbc2.${SO_EXTENSION} $PSQL_VER


echo

echo "+++++ Backing up $ACTIANZEN_ROOT/etc/odbc.ini..."

sync
cp -f $ACTIANZEN_ROOT/etc/odbc.ini $ACTIANZEN_ROOT/etc/odbc.ini.pkgsave
echo

# At this point it should be safe to remove files
echo "+++++ Removing Zen Client Access Files..."
rm -f $ACTIANZEN_ROOT/lib/lib*
rm -f $ACTIANZEN_ROOT/lib/pam*
rm -f $ACTIANZEN_ROOT/bin/psregsvr
rm -f $ACTIANZEN_ROOT/etc/clientaccessinstall.sh
rm -f $ACTIANZEN_ROOT/etc/clientaccessuninstall.sh

echo

echo "+++++ Uninstall has successfully completed."
echo
