/**
 * This system procedure is used to return
 * the list of udfs created, from the database specified.
 */
CREATE PROCEDURE psp_udfs
(   
	in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :udf_name        VARCHAR(255) = NULL  -- Name of the user defined function
) 

RETURNS
(
    UDF_QUALIFIER       VARCHAR (20), -- Name of the database that contains the User Defined Function
    UDF_OWNER           VARCHAR (20),  -- owner of the User Defined Function
    UDF_NAME            VARCHAR(255),      -- Name of the user defined function
    UDF_TYPE            UTINYINT,      -- Type of the user defined function
	NUM_INPUT_PARAMS    INTEGER, -- no. of input parameters
	NUM_OUTPUT_PARAMS   INTEGER, -- no. of output parameters
	NUM_RESULT_SETS     INTEGER, -- no. of columns in result set.
    REMARKS             VARCHAR(255)	-- Remarks
);

BEGIN
   -- Variable to hold the dynamic query    
    DECLARE :stmt_psp_udfs LONGVARCHAR;

    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;

     -- Check if the table name specified is a blank string
	if (rtrim(:udf_name) = '') then
		SIGNAL 'S1000', 'User-defined function name cannot be a blank string'; 
	end if;
    
	SET :database_qual = IFNULL(:database_qual,DATABASE());

	/* If udf name is not supplied or null value
	   match all */	
	SET :udf_name = IFNULL(:udf_name,'%');
	
        /* Enumerate all the udfs information */

    SET :stmt_psp_udfs = 'SELECT ''' +
						   :database_qual +
						   ''', null, ' +		
							' Xp$Name, ' +
							' Xp$Flags, ' +
							' null, ' +
							' 1, ' + 
							' 0, ' +
							' null ' +
							' FROM "' + :database_qual + '".X$Proc ' +
       						' WHERE Xp$Name LIKE ''' + :udf_name +
							''' and Xp$Flags = 1; '
    exec (:stmt_psp_udfs);
END; -- End of stored procedure.
