/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.AbstractScrollableCache;
import com.pervasive.jdbc.lna.ColumnInfoSet;
import com.pervasive.jdbc.lna.LNAStatement;
import java.sql.SQLException;

public class SensitiveResultCache
extends AbstractScrollableCache {
    public SensitiveResultCache(LNAStatement lNAStatement, ColumnInfoSet columnInfoSet, boolean bl) {
        super(lNAStatement, columnInfoSet, bl);
    }

    @Override
    public synchronized void open() throws SQLException {
        if (this.d_isClosed) {
            this.d_isClosed = false;
            this.d_nextFetchSize = this.d_fetchSize;
            this.fetchFirst();
            this.d_curRow = this.d_bufferValid ? Integer.MIN_VALUE : 0;
        }
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        super.setFetchSize(n);
        this.fetchBookmark();
    }

    @Override
    public boolean isRow(int n) throws SQLException {
        if (n == Integer.MIN_VALUE || n == Integer.MAX_VALUE || n == 0) {
            return this.d_curRow == n;
        }
        throw new SQLException(LocalStrings.ERR_SQL_OP_NOT_SUPPORTED);
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        if (this.d_curRow == 0) {
            return false;
        }
        this.cancelInsert();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (n) {
            case 1: {
                this.fetchFirst();
                this.d_curRow = 2;
                this.checkRowError();
                return true;
            }
            case -1: {
                this.fetchLast();
                this.d_curRow = -2;
                this.checkRowError();
                return true;
            }
            case -2147483648: {
                this.fetchFirst();
                if (this.d_curRow != 0) {
                    this.d_curRow = Integer.MIN_VALUE;
                }
                return false;
            }
            case 0x7FFFFFFF: {
                this.fetchLast();
                if (this.d_curRow != 0) {
                    this.d_curRow = Integer.MAX_VALUE;
                }
                return false;
            }
        }
        this.d_curRow = this.fetchAbsolute(n);
        this.checkRowError();
        return this.validRow();
    }

    @Override
    public boolean relative(int n, boolean bl) throws SQLException {
        this.cancelInsert();
        if (this.d_curRow == 0 && bl) {
            return false;
        }
        if (this.d_curRow == Integer.MIN_VALUE) {
            if (n == 1 && bl) {
                return this.checkRowError(this.absolute(1));
            }
            if (n == -1 && bl) {
                return false;
            }
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        if (this.d_curRow == Integer.MAX_VALUE) {
            if (n == -1 && bl) {
                return this.checkRowError(this.absolute(-1));
            }
            if (n == 1 && bl) {
                return false;
            }
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        if (!this.validRow()) {
            throw new SQLException(LocalStrings.ERR_SQL_INVALID_CURRENT_POSITION);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        if (n > 0) {
            bl3 = this.fetchRelativeForward(n);
            if (!bl3) {
                this.d_curRow = Integer.MAX_VALUE;
            }
        } else if (n < 0 && !(bl3 = this.fetchRelativeBackward(n))) {
            this.d_curRow = Integer.MIN_VALUE;
        }
        return this.checkRowError(bl3);
    }

    @Override
    public void insertRow() throws SQLException {
        super.insertRow();
        this.fetchBookmark();
    }

    @Override
    public void updateRow() throws SQLException {
        super.updateRow();
        this.fetchBookmark();
    }

    @Override
    public void deleteRow() throws SQLException {
        super.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        super.refreshRow();
    }

    @Override
    public short getRowStatus() throws SQLException {
        return this.validRow() ? this.d_rowStats[this.d_bufPos] : (short)3;
    }

    private boolean fetchRelativeForward(int n) throws SQLException {
        this.d_curBkmk = 0;
        int n2 = this.d_bufPos + n;
        int n3 = n2 % this.d_fetchSize;
        int n4 = n2 / this.d_fetchSize;
        short s = 0;
        if (n4 > 1) {
            s = this.d_lnaStmt.extendedFetch((short)6, n2, this.d_cis, this);
            this.d_bufPos = 0;
        } else if (n4 == 1) {
            s = this.d_lnaStmt.extendedFetch((short)6, n4 * this.d_fetchSize, this.d_cis, this);
            this.d_bufPos = n3;
        } else {
            this.d_bufPos += n;
        }
        if (s == -16 || this.d_bufPos >= this.d_bufCount) {
            this.d_bufPos = 0;
            return false;
        }
        this.d_curBkmk = this.d_rowBookmarks[this.d_bufPos];
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fetchRelativeBackward(int n) throws SQLException {
        this.d_curBkmk = 0;
        int n2 = this.d_bufPos + n;
        int n3 = n2 % (this.d_nextFetchSize + 1);
        int n4 = (n2 - (this.d_nextFetchSize - 1)) / this.d_nextFetchSize;
        short s = 0;
        if (n4 < -1) {
            s = this.d_lnaStmt.extendedFetch((short)6, n2, this.d_cis, this);
            if (s == 1) {
                this.d_bufPos = 0;
                if (this.d_overlapOffset == 0) return false;
                this.d_bufPos = this.d_fetchSize - (this.d_overlapOffset - n3);
                return false;
            }
            this.d_bufPos = 0;
        } else if (n4 == -1) {
            s = this.d_lnaStmt.extendedFetch((short)6, n4 * this.d_fetchSize, this.d_cis, this);
            if (s == 1) {
                this.d_bufPos = 0;
                if (this.d_overlapOffset == 0 || n3 == 0) return false;
                this.d_bufPos = this.d_fetchSize - (this.d_overlapOffset - n3);
            } else {
                this.d_bufPos = this.d_fetchSize + n3;
            }
        } else {
            this.d_bufPos += n;
        }
        if (s == -16 || this.d_bufPos >= this.d_bufCount || this.d_bufPos < 0) {
            this.d_bufPos = 0;
            return false;
        }
        this.d_curBkmk = this.d_rowBookmarks[this.d_bufPos];
        return true;
    }

    private int fetchAbsolute(int n) throws SQLException {
        short s = 0;
        s = this.d_lnaStmt.extendedFetch((short)5, n, this.d_cis, this);
        this.d_bufPos = 0;
        this.d_curBkmk = this.d_rowBookmarks[this.d_bufPos];
        if (s == -16) {
            if (n >= 1) {
                return Integer.MAX_VALUE;
            }
            if (n <= -1) {
                return Integer.MIN_VALUE;
            }
        }
        if (s == 1) {
            return Integer.MIN_VALUE;
        }
        if (n >= 1) {
            return 2;
        }
        if (n <= -1) {
            return -2;
        }
        return 0;
    }

    private void fetchLast() throws SQLException {
        this.d_lnaStmt.extendedFetch((short)3, 0, this.d_cis, this);
        this.d_bufPos = this.d_bufCount - 1;
        this.d_curBkmk = this.d_rowBookmarks[this.d_bufPos];
    }

    private void fetchFirst() throws SQLException {
        this.d_lnaStmt.extendedFetch((short)2, 0, this.d_cis, this);
        this.d_bufPos = 0;
        if (this.d_bufCount > 0) {
            this.d_curBkmk = this.d_rowBookmarks[this.d_bufPos];
        }
    }

    private void fetchBookmark() throws SQLException {
        if (this.d_curBkmk == 0 || this.d_curBkmk == -1) {
            return;
        }
        this.d_lnaStmt.extendedFetch((short)8, this.d_curBkmk, this.d_cis, this);
        this.d_bufPos = 0;
        if (this.d_bufCount > 0) {
            this.d_curBkmk = this.d_rowBookmarks[this.d_bufPos];
        }
    }

    @Override
    protected void setPosition(int n) throws SQLException {
        this.d_lnaStmt.setPos((short)n, (short)0, (short)0, this.d_cis, null, this.d_rowStats, null, null);
    }
}

