/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.NotificationComp;
import com.pervasive.utilities.notificationviewer.NotificationListComp;
import com.pervasive.utilities.notificationviewer.NotificationSelectionListener;
import com.pervasive.utilities.notificationviewer.NotificationSelectionManager;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.model.NotificationViewerModel;
import com.pervasive.utilities.notificationviewer.utils.GridHelper;
import com.pervasive.utilities.notificationviewer.utils.MessageCatalog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NotificationView {
    private ScrolledComposite scrolledComp;
    private Composite comp;
    private NotificationSelectionManager selectionManager = new NotificationSelectionManager();
    private NotificationViewerModel model;
    private NotificationListComp todayList;
    private NotificationListComp lastWeekList;
    private NotificationListComp olderList;

    public NotificationView(Composite composite) {
        this.scrolledComp = new ScrolledComposite(composite, 2816);
        this.comp = new Composite((Composite)this.scrolledComp, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 0;
        this.comp.setLayout((Layout)gridLayout);
        this.todayList = this.createListComp(MessageCatalog.getMsg("NotificationsPanel.TodayListHeading"), true);
        this.lastWeekList = this.createListComp(MessageCatalog.getMsg("NotificationsPanel.LastWeekListHeading"), false);
        this.olderList = this.createListComp(MessageCatalog.getMsg("NotificationsPanel.OlderListHeading"), false);
        this.scrolledComp.setContent((Control)this.comp);
        this.scrolledComp.setExpandHorizontal(true);
        this.scrolledComp.setExpandVertical(true);
        this.scrolledComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = NotificationView.this.scrolledComp.getClientArea();
                NotificationView.this.scrolledComp.setMinSize(NotificationView.this.comp.computeSize(rectangle.width, -1));
            }
        });
    }

    public void setModel(NotificationViewerModel notificationViewerModel) {
        this.model = notificationViewerModel;
    }

    public void refresh() {
        Object object;
        this.todayList.showNotifications(this.model.getTodayNotifications());
        this.lastWeekList.showNotifications(this.model.getLastWeekNotifications());
        this.olderList.showNotifications(this.model.getOlderNotifications());
        Notification notification = this.selectionManager.getSelected();
        if (notification != null) {
            this.selectionManager.clearSelected();
            object = this.findCompForNotification(notification);
            if (object != null) {
                ((NotificationComp)((Object)object)).select();
            }
        }
        object = this.scrolledComp.getOrigin();
        this.scrolledComp.pack();
        this.scrolledComp.getParent().layout(true, true);
        this.scrolledComp.setOrigin((Point)object);
    }

    private NotificationComp findCompForNotification(Notification notification) {
        NotificationComp notificationComp = this.todayList.findCompForNotification(notification);
        if (notificationComp == null && (notificationComp = this.lastWeekList.findCompForNotification(notification)) == null) {
            notificationComp = this.olderList.findCompForNotification(notification);
        }
        return notificationComp;
    }

    public void refreshToday() {
        NotificationComp notificationComp;
        Notification notification;
        this.todayList.showNotifications(this.model.getTodayNotifications());
        if (!this.todayList.isExpanded()) {
            this.todayList.expand(true);
        }
        if ((notification = this.selectionManager.getSelected()) != null && (notificationComp = this.todayList.findCompForNotification(notification)) != null) {
            this.selectionManager.clearSelected();
            notificationComp.select();
        }
        this.scrolledComp.pack();
        this.scrolledComp.getParent().layout(true, true);
    }

    public Control getControl() {
        return this.scrolledComp;
    }

    public void addNotificationSelectionListener(NotificationSelectionListener notificationSelectionListener) {
        this.selectionManager.addNotificationSelectionListener(notificationSelectionListener);
    }

    public void removeNotificationSelectionListener(NotificationSelectionListener notificationSelectionListener) {
        this.selectionManager.removeNotificationSelectionListener(notificationSelectionListener);
    }

    private NotificationListComp createListComp(String string, boolean bl) {
        NotificationListComp notificationListComp = new NotificationListComp(this.comp, this.selectionManager, string, bl);
        GridHelper.layoutFillHorizontal((Control)notificationListComp);
        return notificationListComp;
    }
}

