/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.util;

import java.text.Format;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageCatalog {
    private static ResourceBundle bundle;
    private static ThreadLocal<MessageFormat> threadLocal;

    private MessageCatalog() {
    }

    public static void init(String string) {
        bundle = ResourceBundle.getBundle(string);
    }

    public static String getMsg(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public static String getMsg(String string, Object object) {
        return MessageCatalog.getMsg(string, new Object[]{object});
    }

    public static String getMsg(String string, Object[] objectArray) {
        String string2 = MessageCatalog.getMsg(string);
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        MessageFormat messageFormat = threadLocal.get();
        messageFormat.applyPattern(string2);
        return messageFormat.format(objectArray);
    }

    public static String getMsg(String string, Object[] objectArray, int[] nArray, Format[] formatArray) {
        String string2 = MessageCatalog.getMsg(string);
        MessageFormat messageFormat = threadLocal.get();
        messageFormat.applyPattern(string2);
        for (int i = 0; i < nArray.length; ++i) {
            messageFormat.setFormatByArgumentIndex(nArray[i], formatArray[i]);
        }
        return messageFormat.format(objectArray);
    }

    public static String getMsg(String string, Object[] objectArray, String string2) {
        String string3 = null;
        try {
            string3 = MessageCatalog.getMsg(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        if (objectArray != null) {
            MessageFormat messageFormat = threadLocal.get();
            messageFormat.applyPattern(string3);
            return messageFormat.format(objectArray);
        }
        return string3;
    }

    static {
        threadLocal = new ThreadLocal<MessageFormat>(){

            @Override
            protected synchronized MessageFormat initialValue() {
                return new MessageFormat("");
            }
        };
    }
}

