/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.guipaadm;

import com.pervasive.ui.validaters.TextChangeListener;
import com.pervasive.ui.validaters.ValidationEvent;
import com.pervasive.ui.validaters.VetoEvent;
import com.pervasive.utilities.util.MessageCatalog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SegmentedTextEntry
extends Composite
implements ModifyListener,
VerifyListener,
KeyListener {
    private List<TextChangeListener> listeners = new ArrayList<TextChangeListener>();
    private int numSegments;
    private int charsPerSegment;
    private String alphabet;
    private Text[] txtCtrls;
    private boolean onClear;

    public SegmentedTextEntry(Composite composite, int n, int n2, String string) {
        this(composite, n, n2, string, null);
    }

    public SegmentedTextEntry(Composite composite, int n, int n2, String string, String string2) {
        super(composite, 0);
        this.numSegments = n;
        this.charsPerSegment = n2;
        this.alphabet = string;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n * 2 - 1 + (string2 != null ? 2 : 0);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        this.setLayoutData(gridData);
        this.setLayout((Layout)gridLayout);
        if (string2 != null) {
            Text text = new Text((Composite)this, 8);
            text.setText(string2);
            Label label = new Label((Composite)this, 64);
            label.setText("-");
        }
        int n3 = -1;
        this.txtCtrls = new Text[n];
        for (int i = 0; i < n; ++i) {
            GC gC;
            Text text;
            this.txtCtrls[i] = text = new Text((Composite)this, 2052);
            if (n3 == -1) {
                gC = new GC((Drawable)text);
                int n4 = gC.stringExtent((String)"Z").x * n2;
                n3 = text.computeSize((int)n4, (int)-1).x;
                gC.dispose();
            }
            gridData = new GridData();
            gridData.widthHint = n3;
            text.setLayoutData((Object)gridData);
            if (i < n - 1) {
                gC = new Label((Composite)this, 64);
                gC.setText("-");
            }
            text.addModifyListener((ModifyListener)this);
            text.addVerifyListener((VerifyListener)this);
            text.addKeyListener((KeyListener)this);
        }
    }

    public void clear() {
        this.onClear = true;
        for (int i = 0; i < this.txtCtrls.length; ++i) {
            this.txtCtrls[0].setText("");
        }
        this.onClear = false;
    }

    public void setText(String string) {
        Object object;
        int n;
        int n2;
        string = this.removeSeparators(string);
        int n3 = string.length() / this.charsPerSegment;
        if (string.length() % this.charsPerSegment > 0) {
            ++n3;
        }
        n3 = Math.min(n3, this.numSegments);
        for (int i = 0; i < n3; ++i) {
            n2 = i * this.charsPerSegment;
            n = Math.min(n2 + this.charsPerSegment, string.length());
            object = string.substring(n2, n);
            this.txtCtrls[i].setText((String)object);
        }
        Text text = this.txtCtrls[n3 - 1];
        n2 = text.getCharCount();
        n = Math.min(n2, this.charsPerSegment);
        object = new FocusGrabber(text, n);
        text.getDisplay().asyncExec((Runnable)object);
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.txtCtrls.length; ++i) {
            stringBuilder.append(this.txtCtrls[i].getText());
        }
        return stringBuilder.toString();
    }

    public void grabFocus() {
        for (int i = 0; i < this.txtCtrls.length; ++i) {
            int n = this.txtCtrls[i].getCharCount();
            if (n >= this.charsPerSegment) continue;
            this.txtCtrls[i].setFocus();
            this.txtCtrls[i].setSelection(n, n);
            return;
        }
        this.txtCtrls[this.txtCtrls.length - 1].setFocus();
        this.txtCtrls[this.txtCtrls.length - 1].setSelection(this.charsPerSegment, this.charsPerSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextChangedListener(TextChangeListener textChangeListener) {
        List<TextChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(textChangeListener)) {
                this.listeners.add(textChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextChangedListener(TextChangeListener textChangeListener) {
        List<TextChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(textChangeListener);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.onClear) {
            return;
        }
        Text text = (Text)modifyEvent.widget;
        int n = this.findTextField(text);
        if (text.getCharCount() == this.charsPerSegment && text.getCaretPosition() >= this.charsPerSegment) {
            if (n < this.txtCtrls.length - 1) {
                Text text2 = this.txtCtrls[n + 1];
                this.txtCtrls[n].clearSelection();
                text2.setSelection(0, 0);
                text2.setFocus();
            }
        } else if (text.getCharCount() == 0 && n > 0) {
            Text text3 = this.txtCtrls[n - 1];
            text3.setFocus();
            text3.setSelection(this.charsPerSegment, this.charsPerSegment);
        }
        if (text.getCharCount() == this.charsPerSegment && this.allSegmentsComplete()) {
            this.fireValidationEvent(new ValidationEvent((Object)this, true, ""));
        } else {
            this.fireValidationEvent(new ValidationEvent((Object)this, false, MessageCatalog.getMsg("SegmentedTextEntry.IncompleteMsg")));
        }
    }

    public void verifyText(VerifyEvent verifyEvent) {
        verifyEvent.doit = true;
        Text text = (Text)verifyEvent.widget;
        verifyEvent.text = this.removeSeparators(verifyEvent.text);
        verifyEvent.text = verifyEvent.text.toUpperCase();
        boolean bl = this.isValidText(verifyEvent.text);
        if (!bl) {
            verifyEvent.doit = false;
            this.fireVetoEvent(new VetoEvent((Object)this, true, MessageCatalog.getMsg("SegmentedTextEntry.InvalidCharMsg")));
            return;
        }
        this.fireVetoEvent(new VetoEvent((Object)this, false, ""));
        StringBuilder stringBuilder = new StringBuilder(text.getText());
        stringBuilder.delete(verifyEvent.start, verifyEvent.end);
        stringBuilder.insert(verifyEvent.start, verifyEvent.text);
        if (stringBuilder.length() > this.charsPerSegment) {
            verifyEvent.doit = false;
            this.insertVirtual(text, verifyEvent.start, verifyEvent.end, verifyEvent.text);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 8) {
            this.handleBackspace((Text)keyEvent.widget);
        } else if (keyEvent.keyCode == 0x1000003) {
            this.handleArrowLeft((Text)keyEvent.widget);
        } else if (keyEvent.keyCode == 0x1000004) {
            this.handleArrowRight((Text)keyEvent.widget);
        }
    }

    private void insertVirtual(Text text, int n, int n2, String string) {
        int n3 = this.findTextField(text);
        StringBuilder stringBuilder = new StringBuilder(this.getText());
        int n4 = n + n3 * this.charsPerSegment;
        int n5 = n2 + n3 * this.charsPerSegment;
        stringBuilder.delete(n4, n5);
        stringBuilder.insert(n4, string);
        this.setText(stringBuilder.toString());
        int n6 = n4 + string.length();
        int n7 = n6 / this.charsPerSegment;
        Text text2 = this.txtCtrls[this.txtCtrls.length - 1];
        int n8 = this.charsPerSegment;
        if (n7 < this.txtCtrls.length) {
            text2 = this.txtCtrls[n7];
            n8 = n6 % this.charsPerSegment;
        }
        FocusGrabber focusGrabber = new FocusGrabber(text2, n8);
        text2.getDisplay().asyncExec((Runnable)focusGrabber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireValidationEvent(ValidationEvent validationEvent) {
        List<TextChangeListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).validationEventOccurred(validationEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVetoEvent(VetoEvent vetoEvent) {
        List<TextChangeListener> list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).vetoEventOccurred(vetoEvent);
            }
        }
    }

    private void handleBackspace(Text text) {
        int n = this.findTextField(text);
        if (n == 0) {
            return;
        }
        if (text.getCaretPosition() == 0 && text.getCharCount() == 0) {
            Text text2 = this.txtCtrls[n - 1];
            text2.setFocus();
            text2.setSelection(this.charsPerSegment, this.charsPerSegment);
        }
    }

    private void handleArrowLeft(Text text) {
        int n = this.findTextField(text);
        if (n == 0) {
            return;
        }
        if (text.getCaretPosition() == 0) {
            Text text2 = this.txtCtrls[n - 1];
            text2.setFocus();
            text2.setSelection(this.charsPerSegment - 1, this.charsPerSegment - 1);
        }
    }

    private void handleArrowRight(Text text) {
        int n = this.findTextField(text);
        if (n == this.txtCtrls.length - 1) {
            return;
        }
        if (text.getCaretPosition() >= this.charsPerSegment - 1) {
            Text text2 = this.txtCtrls[n + 1];
            text2.setFocus();
            text2.setSelection(0, 0);
        }
    }

    private boolean isValidText(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.alphabet.contains(Character.toString(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private int findTextField(Text text) {
        for (int i = 0; i < this.txtCtrls.length; ++i) {
            if (text != this.txtCtrls[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean allSegmentsComplete() {
        for (int i = 0; i < this.txtCtrls.length; ++i) {
            if (this.txtCtrls[i].getCharCount() >= this.charsPerSegment) continue;
            return false;
        }
        return true;
    }

    private String removeSeparators(String string) {
        return string.trim().replaceAll("- *", "");
    }

    private class FocusGrabber
    implements Runnable {
        private Text txtCtrl;
        private int pos;

        public FocusGrabber(Text text, int n) {
            this.txtCtrl = text;
            this.pos = n;
        }

        @Override
        public void run() {
            this.txtCtrl.setFocus();
            this.txtCtrl.setSelection(this.pos, this.pos);
        }
    }
}

