/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.NotificationListComp;
import com.pervasive.utilities.notificationviewer.NotificationSelectionManager;
import com.pervasive.utilities.notificationviewer.NotificationViewerApp;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.utils.GridHelper;
import com.pervasive.utilities.notificationviewer.utils.MessageCatalog;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NotificationComp
extends Composite
implements MouseListener,
DisposeListener {
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(MessageCatalog.getMsg("Notification.DateFormat"));
        }
    };
    private NotificationSelectionManager selectionManager;
    private Notification notification;
    boolean selected = false;
    private CLabel imageLabel;
    private Label dateLabel;
    private Label messageTxt;

    NotificationComp(Composite composite, NotificationSelectionManager notificationSelectionManager, Notification notification) {
        super(composite, 2048);
        this.selectionManager = notificationSelectionManager;
        this.notification = notification;
        Color color = Display.getCurrent().getSystemColor(2);
        Font font = NotificationViewerApp.getFontRegistry().get("org.eclipse.jface.dialogfont");
        if (!notification.isRead()) {
            font = NotificationViewerApp.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        }
        this.setBackgroundMode(2);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 4;
        gridLayout.verticalSpacing = 4;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite((Composite)this, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 3;
        gridLayout.horizontalSpacing = 4;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillHorizontal((Control)composite2);
        Image image = this.getImageForType(notification.getErrorLevel());
        this.imageLabel = new CLabel(composite2, 0);
        this.imageLabel.setForeground(color);
        this.imageLabel.setImage(image);
        this.imageLabel.setText(notification.getCaption());
        this.imageLabel.setFont(font);
        this.dateLabel = new Label(composite2, 262208);
        this.dateLabel.setFont(font);
        this.dateLabel.setForeground(color);
        this.dateLabel.setText(this.formatDate(notification.getTimestamp()));
        this.dateLabel.setAlignment(131072);
        GridHelper.layoutFillBoth((Control)this.dateLabel, -1, -1, 0, 5);
        this.messageTxt = new Label((Composite)this, 64);
        this.messageTxt.setText(notification.getDescription());
        this.messageTxt.setFont(font);
        this.messageTxt.setForeground(color);
        GridHelper.layoutFillHorizontal((Control)this.messageTxt);
        this.addMouseListener(this);
        this.imageLabel.addMouseListener((MouseListener)this);
        this.dateLabel.addMouseListener((MouseListener)this);
        this.messageTxt.addMouseListener((MouseListener)this);
        this.addDisposeListener(this);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.imageLabel.removeMouseListener((MouseListener)this);
        this.dateLabel.removeMouseListener((MouseListener)this);
        this.messageTxt.removeMouseListener((MouseListener)this);
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void select() {
        NotificationListComp notificationListComp;
        if (!this.selected) {
            this.selected = true;
            if (!this.notification.isRead()) {
                this.notification.setRead(true);
                notificationListComp = NotificationViewerApp.getFontRegistry().get("org.eclipse.jface.dialogfont");
                this.imageLabel.setFont((Font)notificationListComp);
                this.dateLabel.setFont((Font)notificationListComp);
                this.messageTxt.setFont((Font)notificationListComp);
            }
            this.setBackground(NotificationViewerApp.getColorRegistry().get("SELECTED_ITEM_BACKGROUND"));
            this.selectionManager.componentSelected(this);
        }
        if (!(notificationListComp = (NotificationListComp)this.getParent()).isExpanded()) {
            notificationListComp.expand(true);
        }
    }

    public void deselect() {
        this.selected = false;
        this.setBackground(Display.getCurrent().getSystemColor(1));
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.select();
    }

    private Image getImageForType(int n) {
        Image image = JFaceResources.getImage((String)"dialog_messasge_info_image");
        if (n == 2) {
            image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        } else if (n == 3) {
            image = JFaceResources.getImage((String)"dialog_message_error_image");
        }
        return image;
    }

    private String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = threadLocal.get();
        return simpleDateFormat.format(date);
    }
}

