/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIInfo;
import com.pervasive.psql.utilities.javadti.DTIUtils;
import com.pervasive.psql.utilities.javadti.ENGINEINFO;
import com.pervasive.psql.utilities.javadti.PVDSNINFO;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.logging.Logger;

public class DSNInfo {
    private static long count;
    private static Connection conObj;
    private static Logger logger;
    private static DSNInfo dsnObj;
    private static boolean bExists;
    private final int BUFFERSIZE = 255;

    static {
        conObj = null;
        dsnObj = null;
        bExists = false;
    }

    private DSNInfo() throws DTIException {
        logger = Logger.getLogger(DTIInfo.getLoggerName());
    }

    public static DSNInfo getObj(Connection connection) throws DTIException {
        if (!bExists) {
            dsnObj = new DSNInfo();
        }
        conObj = connection;
        return dsnObj;
    }

    public long getCount(boolean bl) throws DTIException {
        long[] lArray = new long[1];
        char c = bl ? (char)'1' : '0';
        int n = javadti.JPvCountDSNs(conObj.getHandle(), lArray, c);
        if (n != DTICONSTS.P_OK) {
            logger.finer("JPvCountDSNs Failed");
            throw new DTIException(n);
        }
        count = lArray[0];
        logger.finer("JPvCountDSNs successfull, Count: " + count);
        return count;
    }

    public String getList(boolean bl) throws DTIException {
        long l = dsnObj.getCount(true);
        long[] lArray = new long[]{l * 255L};
        byte[] byArray = new byte[(int)lArray[0]];
        char c = bl ? (char)'1' : '0';
        String string = "";
        int n = javadti.JPvListDSNs(conObj.getHandle(), lArray, byArray, c);
        if (n != DTICONSTS.P_OK) {
            logger.finer("JPvListDSNs failed");
            throw new DTIException(n);
        }
        string = DTIUtils.getLocaleString(byArray);
        logger.finer("JPvListDSNs success, List: " + string);
        return string;
    }

    public PVDSNINFO getDetails(String string) throws DTIException {
        int[] nArray = new int[1];
        PVDSNINFO pVDSNINFO = new PVDSNINFO();
        int n = javadti.JPvGetDSNEx(conObj.getHandle(), string, pVDSNINFO, nArray);
        if (n != DTICONSTS.P_OK) {
            logger.finer("JPvGetDSNEx failed");
            throw new DTIException(n);
        }
        logger.finer("JPvGetDSNEx success Database name: " + pVDSNINFO.getDsnDBQ());
        return pVDSNINFO;
    }

    public ENGINEINFO getEngineInfo() throws DTIException {
        byte[] byArray = new byte[10];
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        ENGINEINFO eNGINEINFO = new ENGINEINFO();
        int n = javadti.JPvGetEngineInformation(conObj.getHandle(), byArray, lArray, lArray2, lArray3, lArray4);
        if (n != DTICONSTS.P_OK) {
            logger.finer("JPvGetEngineInformation failed");
            throw new DTIException(n);
        }
        eNGINEINFO.setServerClient(DTIUtils.getLocaleString(byArray));
        eNGINEINFO.setApiVer(lArray[0]);
        eNGINEINFO.setMajorVer(lArray2[0]);
        eNGINEINFO.setMinorVer(lArray3[0]);
        eNGINEINFO.setType(lArray4[0]);
        logger.finer("JPvGetEngineInformation success, Type: " + eNGINEINFO.getType());
        return eNGINEINFO;
    }
}

