/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Arrays;
import java.util.MissingResourceException;
import pervasive.database.CharsetUtils;
import pervasive.database.DBURI;
import pervasive.database.Database;
import pervasive.database.MessageCatalog;
import pervasive.database.PsqlIOException;
import pervasive.database.PsqlMalformedURIException;
import pervasive.database.PsqlSecurityException;
import pervasive.database.SCursor;

public class DBUtil {
    private static int bitness = 0;
    private static final int MAX_OWNER_NAME_BYTES = 32;
    private static final int HEX_OWNER_NAME_MIN_SIZE = 32;

    private DBUtil() {
    }

    public static void openDBResource(SCursor sCursor, DBURI dBURI, String string) throws PsqlSecurityException, PsqlIOException {
        DBUtil.openDBResource(sCursor, dBURI, string, sCursor.getKeyNumber());
    }

    public static void openDBResource(SCursor sCursor, DBURI dBURI, String string, int n) throws PsqlSecurityException, PsqlIOException {
        DBUtil.openDBResource(sCursor, 0, dBURI, string, n);
    }

    public static void openDBResource(SCursor sCursor, int n, DBURI dBURI, String string, int n2) throws PsqlSecurityException, PsqlIOException {
        if (string != null && string.length() > 0) {
            DBUtil.setOwnerName(sCursor, string);
        }
        String string2 = dBURI.toEscapedString();
        byte[] byArray = CharsetUtils.getStringBytes(string2, sCursor.getDatabase().getCharsetName());
        sCursor.setKBytes(0, byArray.length, byArray);
        sCursor.setKeySize(byArray.length + 1);
        int n3 = sCursor.BTRV(0 + n, n2);
        if (n3 != 0) {
            String string3 = DBUtil.getErrorMsg(n3, dBURI);
            throw new PsqlSecurityException(0, n3, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void login(Database database, DBURI dBURI) throws PsqlSecurityException, PsqlIOException, PsqlMalformedURIException {
        try (SCursor sCursor = database.createSCursor(1024);){
            DBUtil.login(sCursor, dBURI);
        }
    }

    public static void login(SCursor sCursor, DBURI dBURI) throws PsqlSecurityException, PsqlIOException, PsqlMalformedURIException {
        String string = dBURI.toEscapedString();
        sCursor.setKZString(0, string.length(), string);
        int n = sCursor.BTRV(78, 0);
        if (n != 0) {
            DBURI dBURI2 = new DBURI(string);
            String string2 = DBUtil.getErrorMsg(n, dBURI2);
            throw new PsqlSecurityException(78, n, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logout(Database database, DBURI dBURI) throws PsqlSecurityException, PsqlIOException, PsqlMalformedURIException {
        try (SCursor sCursor = database.createSCursor(1024);){
            DBUtil.logout(sCursor, dBURI);
        }
    }

    public static void logout(SCursor sCursor, DBURI dBURI) throws PsqlSecurityException, PsqlIOException, PsqlMalformedURIException {
        String string = dBURI.toEscapedString();
        sCursor.setKZString(0, string.length(), string);
        int n = sCursor.BTRV(78, 1);
        if (n != 0) {
            DBURI dBURI2 = new DBURI(string);
            throw new PsqlSecurityException(78, n, DBUtil.getErrorMsg(n, dBURI2));
        }
    }

    private static String getErrorMsg(int n, DBURI dBURI) {
        Object[] objectArray = new Object[]{dBURI, dBURI.getDBName(), dBURI.getUser(), dBURI.getTable(), dBURI.getDBFile(), dBURI.getFile()};
        String string = "";
        try {
            string = MessageCatalog.getMsg("security.err." + n, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    static boolean is64BitVM() {
        if (bitness == 0) {
            bitness = Integer.parseInt(System.getProperty("sun.arch.data.model", "32"));
        }
        return bitness == 64;
    }

    public static void setOwnerName(SCursor sCursor, String string) {
        if (!string.toLowerCase().startsWith("0x") || string.length() < 34) {
            sCursor.setDZString(0, 32, string);
            return;
        }
        byte[] byArray = new byte[32];
        Arrays.fill(byArray, (byte)0);
        int n = 2;
        int n2 = 0;
        while (n < string.length()) {
            byArray[n2] = (byte)Short.parseShort("" + string.charAt(n) + string.charAt(n + 1), 16);
            n += 2;
            ++n2;
        }
        sCursor.setDBytes(0, byArray.length, byArray);
    }
}

