/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.util.convert;

import com.pervasive.util.convert.ConversionException;
import com.pervasive.util.convert.StreamConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class ObjectConverter {
    public static byte[] convertBytes(Object object) throws ConversionException {
        try {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof InputStream) {
                return StreamConverter.getStreamBytes((InputStream)object);
            }
            if (object instanceof Reader) {
                return StreamConverter.getReaderString((Reader)object).getBytes();
            }
            return object.toString().getBytes();
        }
        catch (IOException iOException) {
            throw new ConversionException(iOException.toString());
        }
    }

    public static String convertString(Object object) throws ConversionException {
        try {
            if (object instanceof byte[]) {
                return new String((byte[])object);
            }
            if (object instanceof InputStream) {
                return StreamConverter.getReaderString(new InputStreamReader((InputStream)object));
            }
            if (object instanceof Reader) {
                return StreamConverter.getReaderString((Reader)object);
            }
            return object.toString();
        }
        catch (IOException iOException) {
            throw new ConversionException(iOException.toString());
        }
    }

    public static String convertString(Object object, String string) throws ConversionException {
        try {
            if (object instanceof byte[]) {
                return new String((byte[])object, string);
            }
            if (object instanceof InputStream) {
                return StreamConverter.getReaderString(new InputStreamReader((InputStream)object, string));
            }
            if (object instanceof Reader) {
                return StreamConverter.getReaderString((Reader)object);
            }
            return object.toString();
        }
        catch (IOException iOException) {
            throw new ConversionException(iOException.toString());
        }
    }

    public static boolean convertBoolean(Object object) throws ConversionException {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return false;
            }
        }
        return ObjectConverter.convertBigDecimal(object).shortValue() != 0;
    }

    public static byte convertByte(Object object) throws ConversionException {
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (byte)1 : 0;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return 1;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return 0;
            }
        }
        return ObjectConverter.convertBigDecimal(object).byteValue();
    }

    public static short convertShort(Object object) throws ConversionException {
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (short)1 : 0;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return 1;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return 0;
            }
        }
        return ObjectConverter.convertBigDecimal(object).shortValue();
    }

    public static int convertInt(Object object) throws ConversionException {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return 1;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return 0;
            }
        }
        return ObjectConverter.convertBigDecimal(object).intValue();
    }

    public static long convertLong(Object object) throws ConversionException {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return 1L;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return 0L;
            }
        }
        return ObjectConverter.convertBigDecimal(object).longValue();
    }

    public static float convertFloat(Object object) throws ConversionException {
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0f : 0.0f;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return 1.0f;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return 0.0f;
            }
        }
        return ObjectConverter.convertBigDecimal(object).floatValue();
    }

    public static double convertDouble(Object object) throws ConversionException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return 1.0;
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return 0.0;
            }
        }
        return ObjectConverter.convertBigDecimal(object).doubleValue();
    }

    public static BigDecimal convertBigDecimal(Object object) throws ConversionException {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            return new BigDecimal(object.toString());
        }
        if ((object = ObjectConverter.convertString(object).trim()) instanceof String) {
            if (((String)object).trim().equalsIgnoreCase("true")) {
                return new BigDecimal(1);
            }
            if (((String)object).trim().equalsIgnoreCase("false")) {
                return new BigDecimal(0);
            }
        }
        return new BigDecimal(ObjectConverter.convertString(object).trim());
    }

    public static Date convertDate(Object object) throws ConversionException {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Timestamp) {
            return new Date(((Timestamp)object).getTime());
        }
        return Date.valueOf(ObjectConverter.convertString(object).trim());
    }

    public static Time convertTime(Object object) throws ConversionException {
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Timestamp) {
            return new Time(((Timestamp)object).getTime());
        }
        return Time.valueOf(ObjectConverter.convertString(object).trim());
    }

    public static Timestamp convertTimestamp(Object object) throws ConversionException {
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof Time) {
            return new Timestamp(((Time)object).getTime());
        }
        return Timestamp.valueOf(ObjectConverter.convertString(object).trim());
    }

    public static InputStream convertBinaryStream(Object object) throws ConversionException {
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        return new ByteArrayInputStream(ObjectConverter.convertBytes(object));
    }

    public static Reader convertCharacterStream(Object object, String string) throws ConversionException {
        try {
            if (object instanceof Reader) {
                return (Reader)object;
            }
            if (object instanceof InputStream) {
                return new InputStreamReader((InputStream)object, string);
            }
            return new StringReader(ObjectConverter.convertString(object, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConversionException(unsupportedEncodingException.toString());
        }
    }

    public static InputStream convertAsciiStream(Object object) throws ConversionException {
        try {
            return new ByteArrayInputStream(ObjectConverter.convertString(object).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConversionException(unsupportedEncodingException.toString());
        }
    }

    public static InputStream convertUnicodeStream(Object object) throws ConversionException {
        try {
            return new ByteArrayInputStream(ObjectConverter.convertString(object).getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConversionException(unsupportedEncodingException.toString());
        }
    }
}

