/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.v2;

import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.v2.Connection;
import java.net.MalformedURLException;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static ResourceBundle verBundle;
    static int MAJOR_VERSION;
    static int MINOR_VERSION;
    static String PRODUCT_NAME;
    static String PRODUCT_VERSION;

    private static void register() {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        try {
            JDBCURL jDBCURL = new JDBCURL(string);
            if (jDBCURL.getType() != 0) {
                return new Connection(jDBCURL, properties);
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.toString());
        }
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        try {
            JDBCURL jDBCURL = new JDBCURL(string);
            return jDBCURL.getType() != 0;
        }
        catch (MalformedURLException malformedURLException) {
            throw new SQLException(malformedURLException.toString());
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[2];
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", "");
        driverPropertyInfoArray[0].description = LocalStrings.PROP_DESC_USER;
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", "");
        driverPropertyInfoArray[1].description = LocalStrings.PROP_DESC_PASSWORD;
        driverPropertyInfoArray[1].required = true;
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return Driver.getMajVer();
    }

    @Override
    public int getMinorVersion() {
        return Driver.getMinVer();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    static int getMajVer() {
        Driver.checkVersionBundle();
        return MAJOR_VERSION;
    }

    static int getMinVer() {
        Driver.checkVersionBundle();
        return MINOR_VERSION;
    }

    static String getProductVer() {
        Driver.checkVersionBundle();
        return PRODUCT_VERSION;
    }

    private static final synchronized void checkVersionBundle() {
        if (verBundle == null) {
            try {
                verBundle = ResourceBundle.getBundle("com.pervasive.jdbc.common.Version");
                MAJOR_VERSION = Integer.parseInt(verBundle.getString("DRIVER_VER_MAJ"));
                MINOR_VERSION = Integer.parseInt(verBundle.getString("DRIVER_VER_MIN"));
                PRODUCT_NAME = verBundle.getString("PRODUCT_NAME");
                PRODUCT_VERSION = verBundle.getString("PRODUCT_VER");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        Driver.register();
        verBundle = null;
        MAJOR_VERSION = 13;
        MINOR_VERSION = 10;
        PRODUCT_NAME = "Pervasive.SQL";
        PRODUCT_VERSION = "";
    }
}

