/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.DebugInputStream;
import com.pervasive.jdbc.common.DebugOutputStream;
import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNASession;
import com.pervasive.jdbc.lna.PervasiveConnectionListener;
import com.pervasive.pscs.Context;
import com.pervasive.pscs.Manager;
import com.pervasive.pscs.SystemAttribute;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.Socket;

public abstract class LNAAbstractSession
implements LNASession {
    private static final String INITIAL_ENCRYPTION_STR = " Wire Encryption version 1";
    private static byte[] INITIAL_ENCRYPTION_BYTES = null;
    protected static final int SOCKET_TIMEOUT = 60000;
    protected JDBCURL d_url;
    protected Socket d_socket;
    protected InputStream d_in;
    protected OutputStream d_out;
    protected short d_curReqNum;
    protected Object d_curReqNumLock = new Object();
    protected boolean d_open;
    protected WeakReference d_weakRefEventListener;
    protected boolean d_log;

    public LNAAbstractSession(JDBCURL jDBCURL, PervasiveConnectionListener pervasiveConnectionListener, boolean bl) {
        this.d_url = jDBCURL;
        this.d_weakRefEventListener = pervasiveConnectionListener == null ? null : new WeakReference<PervasiveConnectionListener>(pervasiveConnectionListener);
        this.d_log = bl;
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this.d_open) {
            this.d_socket = new Socket(this.d_url.getHost(), this.d_url.getPort());
            int n = this.d_url.getTimeout();
            this.d_socket.setSoTimeout(n == -1 ? 60000 : n);
            if (this.d_log) {
                this.d_in = new DebugInputStream(this.d_socket.getInputStream());
                this.d_out = new DebugOutputStream(this.d_socket.getOutputStream());
            } else {
                this.d_in = this.d_socket.getInputStream();
                this.d_out = this.d_socket.getOutputStream();
            }
            this.d_curReqNum = 0;
            this.d_open = true;
        }
    }

    @Override
    public String handshake(String string) throws IOException {
        int n;
        Object object;
        if (!this.d_open) {
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        int n2 = 255;
        byte[] byArray = new byte[n2];
        if (string != null) {
            object = string.getBytes("US-ASCII");
            n = ((byte[])object).length;
            System.arraycopy(object, 0, byArray, 0, n);
        }
        if (this.d_url.getType() != 4) {
            System.arraycopy(INITIAL_ENCRYPTION_BYTES, 0, byArray, 0, INITIAL_ENCRYPTION_BYTES.length);
        }
        this.d_out.write(byArray);
        object = new DataInputStream(this.d_in);
        ((DataInputStream)object).readFully(byArray);
        n = 0;
        if (this.serverHasWireEncryption(byArray)) {
            try {
                Context context = Manager.createContext(null, (int)0);
                context.init(this.d_in, this.d_out);
                context.setAttribute(SystemAttribute.WIRE_ENCRYPTION, (Object)new Integer(this.d_url.getWhenEncrypt()));
                context.setAttribute(SystemAttribute.ENCRYPTION_LEVEL, (Object)new Integer(this.d_url.getEncryptionLevel()));
                if (context.initiate(null, null) && this.d_url.getType() != 4) {
                    this.d_in = context.getCipherInputStream();
                    this.d_out = context.getCipherOutputStream();
                    n = 1;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(LocalStrings.ERR_WIRE_ENCRYPTION_GENERAL_FAILURE);
            }
        }
        if (n == 0 && this.d_url.getWhenEncrypt() == 1 && this.d_url.getType() != 4) {
            throw new IOException(LocalStrings.ERR_WIRE_ENCRYPTION_USAGE_MISMATCH);
        }
        return new String(byArray, "US-ASCII").trim();
    }

    private boolean serverHasWireEncryption(byte[] byArray) {
        try {
            String string = new String(byArray, "US-ASCII");
            return string.indexOf(INITIAL_ENCRYPTION_STR) != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return !this.d_open;
    }

    protected PervasiveConnectionListener getEventListener() {
        return this.d_weakRefEventListener == null ? null : (PervasiveConnectionListener)this.d_weakRefEventListener.get();
    }

    static {
        try {
            INITIAL_ENCRYPTION_BYTES = INITIAL_ENCRYPTION_STR.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

