/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.PVSQLCONNID;
import com.pervasive.psql.utilities.javadti.PVSQLCONNINFO2;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class SQLConnectionInfo {
    private static Map<Connection, SQLConnectionInfo> sqlConnectionInfoMap = new HashMap<Connection, SQLConnectionInfo>();
    private long m_bTotalConn = 0L;
    private boolean m_bInit = false;
    private int m_hConnection = -99;
    private Connection m_conn = null;
    private Logger m_logger;

    private SQLConnectionInfo(Connection connection, String string) throws DTIException {
        this.m_conn = connection;
        this.m_logger = Logger.getLogger(string);
        this.initialize(connection.getHandle());
    }

    public static SQLConnectionInfo getObj(Connection connection, String string) throws DTIException {
        SQLConnectionInfo sQLConnectionInfo = sqlConnectionInfoMap.get(connection);
        if (sQLConnectionInfo != null) {
            return sQLConnectionInfo;
        }
        sQLConnectionInfo = new SQLConnectionInfo(connection, string);
        sqlConnectionInfoMap.put(connection, sQLConnectionInfo);
        return sQLConnectionInfo;
    }

    private void initialize(int n) throws DTIException {
        this.m_hConnection = n;
        this.m_bInit = true;
    }

    public void dispose() throws DTIException {
        if (this.m_bInit) {
            this.freeData();
        }
        this.m_bTotalConn = 0L;
        Iterator<Connection> iterator = sqlConnectionInfoMap.keySet().iterator();
        Connection connection = null;
        while (iterator.hasNext()) {
            Connection connection2 = iterator.next();
            if (!connection2.equals(this.m_conn)) continue;
            connection = connection2;
            break;
        }
        if (connection != null) {
            sqlConnectionInfoMap.remove(connection);
        }
    }

    public long getCount() throws DTIException {
        assert (this.m_bInit);
        if (this.m_bInit) {
            long[] lArray = new long[]{-1L};
            int n = javadti.JPvGetSQLConnectionsData(this.m_hConnection, lArray);
            if (DTICONSTS.P_OK == n) {
                this.m_bTotalConn = lArray[0];
                this.m_logger.finer("JPvGetSQLConnectionsData Success, Connections: " + this.m_bTotalConn);
            } else {
                this.m_logger.finer("JPvGetSQLConnectionsData Failed");
                throw new DTIException(n);
            }
        }
        return this.m_bTotalConn;
    }

    public void getInfo(long l, PVSQLCONNINFO2 pVSQLCONNINFO2) throws DTIException {
        assert (l < this.m_bTotalConn) : l;
        if (this.m_bInit) {
            int n = javadti.JPvGetSQLConnectionInfo(this.m_hConnection, l, pVSQLCONNINFO2);
            if (DTICONSTS.P_OK != n) {
                this.m_logger.finer("JPvGetSQLConnectionInfo Failed");
                throw new DTIException(n);
            }
            this.m_logger.finer("JPvGetSQLConnectionInfo Success");
        }
    }

    private void freeData() throws DTIException {
        assert (this.m_bInit);
        if (this.m_bInit) {
            int n = javadti.JPvFreeSQLConnectionsData(this.m_hConnection);
            if (DTICONSTS.P_OK != n) {
                this.m_logger.finer("JPvFreeSQLConnectionsData Failed");
                throw new DTIException(n);
            }
            this.m_logger.finer("JPvFreeSQLConnectionsData Success");
        }
    }

    public void disconnectSQLConnection(PVSQLCONNID pVSQLCONNID) throws DTIException {
        assert (this.m_bInit);
        int n = javadti.JPvDisconnectSQLConnection(this.m_hConnection, pVSQLCONNID);
        if (DTICONSTS.P_OK != n) {
            this.m_logger.finer("JPvDisconnectSQLConnection Failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvDisconnectSQLConnection Success");
    }
}

