/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.Debug;
import com.pervasive.jdbc.common.JDBCURL;
import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNAAbstractSession;
import com.pervasive.jdbc.lna.LNAPacket;
import com.pervasive.jdbc.lna.LNARequest;
import com.pervasive.jdbc.lna.LNAResponse;
import com.pervasive.jdbc.lna.PervasiveConnectionListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;

public class LNASocketSession
extends LNAAbstractSession
implements Runnable {
    private Thread d_thread;
    private Hashtable d_responses = new Hashtable();
    private int d_reqCount = 0;

    public LNASocketSession(JDBCURL jDBCURL, PervasiveConnectionListener pervasiveConnectionListener, boolean bl) {
        super(jDBCURL, pervasiveConnectionListener, bl);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.d_open) {
            this.d_open = false;
            Hashtable hashtable = this.d_responses;
            synchronized (hashtable) {
                this.d_responses.notify();
            }
            this.d_in.close();
            this.d_out.close();
            this.d_socket.close();
        }
    }

    @Override
    public String handshake(String string) throws IOException {
        String string2 = super.handshake(string);
        this.d_thread = new Thread((Runnable)this, LocalStrings.LISTENER_THREAD_NAME);
        this.d_thread.setDaemon(true);
        this.d_thread.start();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LNAResponse request(LNARequest lNARequest) throws IOException {
        if (!this.d_open) {
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        LNAResponse lNAResponse = new LNAResponse();
        lNAResponse.associateWithRequest(lNARequest);
        lNAResponse.setCurrentThread();
        Integer n = null;
        Object object = this.d_curReqNumLock;
        synchronized (object) {
            short s = this.d_curReqNum;
            this.d_curReqNum = (short)(s + 1);
            n = new Integer(s);
        }
        this.d_responses.put(n, lNAResponse);
        try {
            object = this.d_out;
            synchronized (object) {
                lNARequest.setRequestNumber(n.shortValue());
                lNARequest.setNextRequest(this.d_curReqNum);
                lNARequest.writeTo(this.d_out);
                lNARequest.close();
            }
        }
        catch (IOException iOException) {
            this.d_responses.remove(n);
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        object = this.d_responses;
        synchronized (object) {
            this.d_responses.notify();
        }
        this.waitForResponse(lNAResponse);
        return lNAResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LNAResponse request(LNARequest lNARequest, LNAResponse lNAResponse) throws IOException {
        if (!this.d_open) {
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        lNAResponse.reinit();
        lNAResponse.associateWithRequest(lNARequest);
        lNAResponse.setCurrentThread();
        Integer n = null;
        Object object = this.d_curReqNumLock;
        synchronized (object) {
            short s = this.d_curReqNum;
            this.d_curReqNum = (short)(s + 1);
            n = new Integer(s);
        }
        this.d_responses.put(n, lNAResponse);
        try {
            object = this.d_out;
            synchronized (object) {
                lNARequest.setRequestNumber(n.shortValue());
                lNARequest.setNextRequest(this.d_curReqNum);
                lNARequest.writeTo(this.d_out);
                lNARequest.close();
            }
        }
        catch (IOException iOException) {
            this.d_responses.remove(n);
            throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
        }
        object = this.d_responses;
        synchronized (object) {
            this.d_responses.notify();
        }
        this.waitForResponse(lNAResponse);
        return lNAResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        short s = 0;
        boolean bl = false;
        Object var3_3 = null;
        LNAResponse lNAResponse = null;
        LNAPacket lNAPacket = null;
        while (true) {
            try {
                InputStream inputStream;
                do {
                    lNAPacket = new LNAPacket();
                    inputStream = this.d_in;
                    synchronized (inputStream) {
                        Hashtable hashtable = this.d_responses;
                        synchronized (hashtable) {
                            while (this.d_responses.isEmpty()) {
                                try {
                                    this.d_responses.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (this.d_open) continue;
                                return;
                            }
                        }
                        lNAPacket.readFrom(this.d_in);
                        s = lNAPacket.getRequestNumber();
                        lNAResponse = (LNAResponse)this.d_responses.remove(new Integer(s));
                        lNAResponse.setPacket(lNAPacket);
                        lNAResponse.readPacketData(this.d_in);
                    }
                } while (lNAResponse == null);
                inputStream = lNAResponse;
                synchronized (inputStream) {
                    lNAResponse.notify();
                }
            }
            catch (EOFException eOFException) {
                PervasiveConnectionListener pervasiveConnectionListener = this.getEventListener();
                if (pervasiveConnectionListener != null) {
                    EventObject eventObject = new EventObject(this);
                    pervasiveConnectionListener.connectionClosed(eventObject);
                }
                if (this.d_log) {
                    Debug.println(4, "EOF Error reading response.");
                    Debug.println(4, eOFException.getMessage());
                    if (Debug.out != null) {
                        eOFException.printStackTrace(Debug.out);
                    }
                }
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.notifyAllOfError();
                return;
            }
            catch (IOException iOException) {
                PervasiveConnectionListener pervasiveConnectionListener = this.getEventListener();
                if (pervasiveConnectionListener != null) {
                    EventObject eventObject = new EventObject(this);
                    pervasiveConnectionListener.connectionErrorOccurred(eventObject);
                }
                if (this.d_log) {
                    Debug.println(4, "IO Error reading response.");
                    Debug.println(4, iOException.getMessage());
                    if (Debug.out != null) {
                        iOException.printStackTrace(Debug.out);
                    }
                }
                this.notifyAllOfError();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllOfError() {
        LNAResponse lNAResponse = null;
        Hashtable hashtable = this.d_responses;
        synchronized (hashtable) {
            Enumeration enumeration = this.d_responses.elements();
            while (enumeration.hasMoreElements()) {
                LNAResponse lNAResponse2 = lNAResponse = (LNAResponse)enumeration.nextElement();
                synchronized (lNAResponse2) {
                    lNAResponse.interrupt();
                }
            }
            this.d_responses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResponse(LNAResponse lNAResponse) throws IOException {
        LNAResponse lNAResponse2 = lNAResponse;
        synchronized (lNAResponse2) {
            try {
                while (!lNAResponse.isFull()) {
                    lNAResponse.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(LocalStrings.ERR_LNA_SESSION_CLOSED);
            }
        }
    }

    public String getSockName() {
        InetAddress inetAddress = this.d_socket.getLocalAddress();
        String string = "<unknown host>";
        if (inetAddress != null) {
            string = inetAddress.getHostAddress();
            if (inetAddress instanceof Inet6Address) {
                string = "[" + string + "]";
            }
        }
        return string;
    }
}

