#!/bin/sh

echo "+++++ Checking current user rights..."

if [ "$(id -u root)" = "$(id -u)" ] ; then
    :
else
    echo "ERROR: The current user id is not root (`id|awk '{print $1}'`)."
    exit 1
fi
echo

if [ "X$ACTIANZEN_ROOT" = "X" ] ; then
    ACTIANZEN_ROOT=/usr/local/actianzen
fi

LIBDIR=lib

PATH=$ACTIANZEN_ROOT/bin:$PATH
if [ $(uname -s) = "Darwin" ]
then
    DYLD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    SO_EXTENSION="dylib"
    SU_ARGS="-l"
else
    LD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/$LIBDIR:$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
    SO_EXTENSION="so"
    SU_ARGS=
fi
export ACTIANZEN_ROOT
SU="su -"
USERNAME=zen-svc
DEMODATADB="DEMODATA"
TEMPDB="TEMPDB"

# PSQL-9715: /etc/init.d may not be available on all distributions.
if [ $(uname -s) = "Darwin" ]; then
    RUNDAEMONFILE="$ACTIANZEN_ROOT/etc/init.d/actianzen"
else
    if [ -d /etc/init.d ]
    then
        RUNDAEMONFILE="/etc/init.d/actianzen"
    else
        RUNDAEMONFILE="/etc/rc.d/init.d/actianzen"
    fi
fi

for FILE in $ACTIANZEN_ROOT/$LIBDIR/libpsqlmif.${SO_EXTENSION}.[0-9]*
do
    if [ \( -f $FILE \) -a \( ! -h $FILE \) ]; then
        MIF_FILE=$FILE
        break
    fi
done
if [ "$MIF_FILE" ]; then
    # ..../libpsqlmif.so.15.10.NNN.MMM --> 15
    # ..../libpsqlmif.so.15 -> 15
    PSQL_VER=`echo $MIF_FILE | sed -e 's/^.*\.'"${SO_EXTENSION}"'\.\([0-9]*\).*$/\1/'`
else
    if [ $(uname -s) = "Darwin" ]; then
        # ..../libpsqlmif.15.dylib --> 15
        for FILE in $ACTIANZEN_ROOT/$LIBDIR/libpsqlmif.[0-9]*.dylib
        do
            if [ \( -f $FILE \) -a \( ! -h $FILE \) ]; then
                MIF_FILE=$FILE
                break
            fi
        done
        PSQL_VER=`echo $MIF_FILE | sed -e 's/^.*\.\([0-9]*\)\.dylib$/\1/'`
    fi
fi
echo "++++ MIF_FILE: $MIF_FILE (PSQL_VER $PSQL_VER)"
PS_VER=$PSQL_VER

# If Zen isn't running.
if ! $RUNDAEMONFILE status > /dev/null ; then
    echo "+++++ Starting the Zen daemon..."
    $RUNDAEMONFILE start
    #echo
fi


echo "+++++ Removing the $DEMODATADB database..."
DEMODATADBEXIST=`echo "$ACTIANZEN_ROOT/bin/dbmaint l" | $SU $USERNAME $SU_ARGS | grep $DEMODATADB | wc -l | tr -d " "`
if [ "X$DEMODATADBEXIST" != "X0" ] ; then
    echo "$ACTIANZEN_ROOT/bin/dbmaint d -n$DEMODATADB" | $SU $USERNAME $SU_ARGS
fi
echo


echo "+++++ Removing the $TEMPDB database..."
TEMPDBEXIST=`echo "$ACTIANZEN_ROOT/bin/dbmaint l" | $SU $USERNAME $SU_ARGS | grep $TEMPDB | wc -l | tr -d " "`
if [ "X$TEMPDBEXIST" != "X0" ] ; then
    echo "$ACTIANZEN_ROOT/bin/dbmaint d -n$TEMPDB" | $SU $USERNAME $SU_ARGS
fi
echo


echo "+++++ Stopping the Zen daemon..."
$RUNDAEMONFILE force
#echo

if [ $(uname -s) = "Darwin" ]
then
    /bin/launchctl stop com.actian.mkde

    if cd /Library/LaunchDaemons
    then
        /bin/launchctl unload com.actian.mkde.plist
        rm com.actian.mkde.plist
    fi
else
    # Use "insserv" if it's available.
    if insserv -n > /dev/null 2>&1
    then
        echo "+++++ Removing Zen daemon scripts..."
        insserv -r $RUNDAEMONFILE
        rm -f /etc/init.d/rc?.d/K??actianzen
        rm -f /etc/init.d/rc?.d/S??actianzen
        rm -f $RUNDAEMONFILE
    else
        echo "+++++ Removing Zen daemon scripts..."
        if [ -d /etc/rc0.d ]; then
            RCDIR=/etc
        else
            RCDIR=/etc/rc.d
        fi
        KILLS=K92actianzen
        STARTS=S92actianzen
        rm -f $RCDIR/rc?.d/$KILLS
        rm -f $RCDIR/rc?.d/$STARTS
        rm -f $RUNDAEMONFILE

        # Reload systemd manager configuration, if available, so that
        # systemd is aware that the service no longer exists.
        if which systemctl >/dev/null 2>&1
        then
            systemctl daemon-reload
	fi
    fi
fi

echo "+++++ Unregistering the PCOM libraries..."

PSREGSVR=psregsvr
if [ -f $ACTIANZEN_ROOT/bin/psregsvr64 ] ; then
    PSREGSVR=psregsvr64
fi

dso_unregister () {
    dso=$1
    if [ -f $ACTIANZEN_ROOT/$LIBDIR/$dso ]; then
        $ACTIANZEN_ROOT/bin/$PSREGSVR -u $ACTIANZEN_ROOT/$LIBDIR/$dso
    fi
}

dso_unregister libpseucjp.${SO_EXTENSION}
dso_unregister libmkc3.${SO_EXTENSION}
dso_unregister libexp010.${SO_EXTENSION}
dso_unregister liblicmgrrb.${SO_EXTENSION}
dso_unregister liblegacylm.${SO_EXTENSION}
dso_unregister libmkderb.${SO_EXTENSION}
dso_unregister libpctlgrb.${SO_EXTENSION}
dso_unregister libcobolschemaexecmsgrb.${SO_EXTENSION}
dso_unregister libpsqlcobolschemaexec.${SO_EXTENSION}
dso_unregister libpceurop.${SO_EXTENSION}
dso_unregister libpssax.${SO_EXTENSION}
dso_unregister libpsdom.${SO_EXTENSION}
dso_unregister libpsutilrb.${SO_EXTENSION}
dso_unregister libclientrb.${SO_EXTENSION}
dso_unregister libupiapirb.${SO_EXTENSION}
dso_unregister libpvmsgrb.${SO_EXTENSION}
dso_unregister libpsqlcsm.${SO_EXTENSION}
dso_unregister libpsqlcsp.${SO_EXTENSION}
dso_unregister libdbcsipxy.${SO_EXTENSION}
dso_unregister libdcm100.${SO_EXTENSION}
dso_unregister libcsi100.${SO_EXTENSION}
dso_unregister libpscp932.${SO_EXTENSION}
dso_unregister libsrderb.${SO_EXTENSION}
echo


echo "+++++ Removing symbolic links to libraries..."

dso_unsymlink () {
    dso=$1
    ver=$2
    found="no"
    if [ -h $ACTIANZEN_ROOT/lib/$dso ]; then
        rm -f $ACTIANZEN_ROOT/lib/$dso
        found="yes"
    fi
    if [ -h $ACTIANZEN_ROOT/lib/$dso.$ver ]; then
        rm -f $ACTIANZEN_ROOT/lib/$dso.$ver
        found="yes"
    fi
    if [ -h $ACTIANZEN_ROOT/lib64/$dso ]; then
        rm -f $ACTIANZEN_ROOT/lib64/$dso
        found="yes"
    fi
    #echo checking $ACTIANZEN_ROOT/lib64/$dso.$ver
    if [ -h $ACTIANZEN_ROOT/lib64/$dso.$ver ]; then
        rm -f $ACTIANZEN_ROOT/lib64/$dso.$ver
        found="yes"
    fi
    if [ "x$found" = "xno" ]; then
        echo unsymlink failed: $dso ver $ver
    fi
}

dso_unsymlink libdbuxlt.${SO_EXTENSION} $PSQL_VER
#dso_unsymlink libiodbc.${SO_EXTENSION} 2
#dso_unsymlink libsdba.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsrde.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcobolschemaexec.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libodbc.${SO_EXTENSION} 1
if [ $(uname -s) = "Darwin" ]
then
    dso_unsymlink libodbccr.${SO_EXTENSION} 1
fi
dso_unsymlink libodbcci.${SO_EXTENSION} $PSQL_VER
dso_unsymlink pam_pvsw.${SO_EXTENSION} 1
dso_unsymlink libpscore.${SO_EXTENSION} $PS_VER
dso_unsymlink libpscl.${SO_EXTENSION} $PS_VER
dso_unsymlink libpsutilrb.${SO_EXTENSION} $PS_VER
dso_unsymlink libpceurop.${SO_EXTENSION} $PS_VER
dso_unsymlink libpseucjp.${SO_EXTENSION} $PS_VER
dso_unsymlink libpscp932.${SO_EXTENSION} $PS_VER
dso_unsymlink libpssax.${SO_EXTENSION} $PS_VER
dso_unsymlink libpsdom.${SO_EXTENSION} $PS_VER
dso_unsymlink libxlate.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqldti.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libclientlm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpasupt.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libbtrieveC.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libbtrieveCpp.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlmif.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlnsl.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsxdebug.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpctlgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libcobolschemaexecmsgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libclientrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libupiapirb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvmsgrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libdcm100.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libcsi100.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcsm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlcsp.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libdbcsipxy.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libenginelm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libels.${SO_EXTENSION} $PSQL_VER
dso_unsymlink liblegacylm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink liblicmgrrb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkdemd.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpsqlmpm.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvisr.${SO_EXTENSION} $PSQL_VER

dso_unsymlink libbdulb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libexp010.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libjavadti.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libjnibtrv.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkc3.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libmkderb.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libnotifysupt.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpam.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvjdbc2.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libpvswcore.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsqlmgr.${SO_EXTENSION} $PSQL_VER
dso_unsymlink libsrderb.${SO_EXTENSION} $PSQL_VER

echo
