/*
 * Decompiled with CFR 0.152.
 */
package pervasive.database;

import java.util.Hashtable;
import java.util.Vector;
import pervasive.database.ColumnDef;
import pervasive.database.Consts;
import pervasive.database.MessageCatalog;
import pervasive.database.Table;

public class BufferMetaData
implements Consts {
    Hashtable m_hcol = new Hashtable();
    Vector m_vcol = new Vector();
    Vector m_BLOBColumns = new Vector();
    int m_highoffs = 0;
    int m_permhighoffs = 0;
    Table m_table = null;
    int m_PrevColIsBit = 0;

    BufferMetaData(Table table) {
        this.m_table = table;
    }

    public int getColumnCount() {
        return this.m_vcol.size();
    }

    public String[] getColumnNames() {
        int n = this.m_vcol.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((ColumnDef)this.m_vcol.elementAt((int)i)).m_colname;
        }
        return stringArray;
    }

    public int findColumn(String string) {
        return this.m_vcol.indexOf(this.getColumnDef(string));
    }

    public ColumnDef getColumnDef(int n) {
        ColumnDef columnDef = null;
        try {
            columnDef = (ColumnDef)this.m_vcol.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "getColumnDef", "cNum", Integer.toString(n)));
        }
        return columnDef;
    }

    public ColumnDef getColumnDef(String string) {
        ColumnDef columnDef = (ColumnDef)this.m_hcol.get(string);
        if (columnDef == null) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "getColumnDef", "cName", string));
        }
        return columnDef;
    }

    void removeColumnDef(String string) {
        ColumnDef columnDef = (ColumnDef)this.m_hcol.remove(string);
        if (columnDef == null) {
            throw new IllegalArgumentException(MessageCatalog.getIllegalArgumentMsg(this, "removeColumnDef", "cName", string));
        }
        int n = this.m_vcol.indexOf(columnDef);
        int n2 = columnDef.m_length;
        for (int i = n + 1; i < this.m_vcol.size(); ++i) {
            ((ColumnDef)this.m_vcol.elementAt((int)i)).m_rowsetOffset -= n2;
        }
        this.m_highoffs -= n2;
        this.m_vcol.removeElement(columnDef);
    }

    void addClone(ColumnDef columnDef) {
        ColumnDef columnDef2 = (ColumnDef)columnDef.clone();
        if (columnDef2.m_type == 16 && this.m_PrevColIsBit == 1 && columnDef2.m_dec != 1) {
            --this.m_highoffs;
        }
        if (columnDef.isNullable()) {
            ++this.m_highoffs;
        }
        columnDef2.m_rowsetOffset = this.m_highoffs;
        this.m_highoffs += columnDef2.m_length;
        this.m_PrevColIsBit = columnDef2.m_type == 16 ? 1 : 0;
        this.m_vcol.addElement(columnDef2);
        this.m_hcol.put(columnDef2.m_colname, columnDef2);
        if (columnDef2.m_type == 21) {
            this.m_BLOBColumns.addElement(new Integer(this.m_vcol.indexOf(columnDef2)));
        }
    }

    void addOrig(ColumnDef columnDef) {
        if (columnDef.m_type == 16 && this.m_PrevColIsBit == 1 && columnDef.m_dec != 1) {
            --this.m_highoffs;
        }
        if (columnDef.isNullable()) {
            ++this.m_highoffs;
        }
        columnDef.m_rowsetOffset = this.m_highoffs;
        this.m_highoffs += columnDef.m_length;
        this.m_PrevColIsBit = columnDef.m_type == 16 ? 1 : 0;
        this.m_vcol.addElement(columnDef);
        this.m_hcol.put(columnDef.m_colname, columnDef);
    }

    int[] getBLOBColumns() {
        int n = this.m_BLOBColumns.size();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = ((Integer)this.m_BLOBColumns.elementAt(i)).intValue();
        }
        return nArray;
    }
}

