/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.lna;

import com.pervasive.jdbc.common.LocalStrings;
import com.pervasive.jdbc.lna.LNAResponse;
import java.io.IOException;

public class ParamDesc {
    private static final int DBMSTYPE_NULLABLE = 1;
    private static final int DBMSTYPE_UNSIGNED = 32;
    protected short d_sqlDataType;
    protected int d_precision;
    protected short d_scale;
    protected short d_paramType;
    protected int d_nullable;
    protected boolean d_unsigned;
    protected short d_cDataType;
    protected int d_maxSize;

    public void readFrom(LNAResponse lNAResponse) throws IOException {
        this.d_sqlDataType = lNAResponse.readShort();
        this.d_precision = lNAResponse.readInt();
        this.d_scale = lNAResponse.readShort();
        int n = lNAResponse.readInt();
        this.d_paramType = lNAResponse.readShort();
        this.d_nullable = (n & 1) == 1 ? 1 : 0;
        this.d_unsigned = (n & 0x20) == 32;
        this.selectBinding();
    }

    public final short getDataType() {
        return this.d_sqlDataType;
    }

    public final int getPrecision() {
        return this.d_precision;
    }

    public final short getScale() {
        return this.d_scale;
    }

    public final int getNullable() {
        return this.d_nullable;
    }

    public final short getBindType() {
        return this.d_cDataType;
    }

    public final void setBindType(short s) {
        this.d_cDataType = s;
    }

    public final int getBindSize() {
        return this.d_maxSize;
    }

    public final boolean isUnsigned() {
        return this.d_unsigned;
    }

    public void selectBinding() {
        switch (this.d_sqlDataType) {
            case 1: 
            case 12: {
                this.d_cDataType = 1;
                this.d_maxSize = this.d_precision > 0 ? this.d_precision + 1 : 255;
                break;
            }
            case -9: 
            case -8: {
                this.d_cDataType = (short)-8;
                this.d_maxSize = this.d_precision > 0 ? (this.d_precision + 1) * 2 : 254;
                break;
            }
            case 2: 
            case 3: {
                if (this.d_scale == 0 && this.d_precision <= 4) {
                    this.d_cDataType = (short)5;
                    this.d_maxSize = 2;
                    break;
                }
                if (this.d_scale == 0 && this.d_precision <= 9) {
                    this.d_cDataType = (short)4;
                    this.d_maxSize = 4;
                    break;
                }
                this.d_cDataType = 1;
                this.d_maxSize = this.d_precision > 0 ? this.d_precision + 3 : 255;
                break;
            }
            case 4: {
                this.d_cDataType = (short)(this.d_unsigned ? -18 : 4);
                this.d_maxSize = 4;
                break;
            }
            case -5: {
                this.d_cDataType = (short)(this.d_unsigned ? -27 : -25);
                this.d_maxSize = 8;
                break;
            }
            case -6: 
            case 5: {
                this.d_cDataType = (short)(this.d_unsigned ? -17 : 5);
                this.d_maxSize = 2;
                break;
            }
            case 6: 
            case 8: {
                this.d_cDataType = (short)8;
                this.d_maxSize = 8;
                break;
            }
            case 7: {
                this.d_cDataType = (short)7;
                this.d_maxSize = 4;
                break;
            }
            case 9: {
                this.d_cDataType = (short)9;
                this.d_maxSize = 6;
                break;
            }
            case 10: {
                this.d_cDataType = (short)10;
                this.d_maxSize = 6;
                break;
            }
            case 11: {
                this.d_cDataType = (short)11;
                this.d_maxSize = 16;
                break;
            }
            case -1: {
                this.d_cDataType = 1;
                this.d_maxSize = 0;
                break;
            }
            case -10: {
                this.d_cDataType = (short)-8;
                this.d_maxSize = 0;
                break;
            }
            case -3: 
            case -2: {
                this.d_cDataType = (short)-2;
                this.d_maxSize = this.d_precision > 0 ? this.d_precision : 255;
                break;
            }
            case -4: {
                this.d_cDataType = (short)-2;
                this.d_maxSize = 0;
                break;
            }
            case -7: {
                this.d_cDataType = (short)5;
                this.d_maxSize = 2;
                break;
            }
            case -11: {
                this.d_cDataType = (short)-11;
                this.d_maxSize = 16;
                break;
            }
            case 0: {
                this.d_sqlDataType = 0;
                break;
            }
            default: {
                throw new RuntimeException(LocalStrings.ERR_SQL_INVALID_DATA_TYPE);
            }
        }
    }
}

