/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.jdbc.common;

import com.pervasive.jdbc.common.Debug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DebugOutputStream
extends FilterOutputStream {
    private int d_lineCount;

    public DebugOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        this.printByte(n);
        this.print(" <eot>");
        this.newLine();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            this.printByte(byArray[i]);
        }
        this.print(" <eot>");
        this.newLine();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.printByte(byArray[i + n]);
        }
        this.print(" <eot>");
        this.newLine();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.print(" <flush>");
        this.newLine();
    }

    public String toString() {
        return "DebugOutputStream@" + Integer.toHexString(this.hashCode());
    }

    private void print(String string) {
        if (this.d_lineCount == 0) {
            Debug.print(this.toString() + ":");
        }
        Debug.print(string);
    }

    private void newLine() {
        Debug.println();
        this.d_lineCount = 0;
    }

    private void printByte(int n) {
        String string = Integer.toHexString(n & 0xFF);
        if (string.length() < 2) {
            string = "0" + string;
        }
        this.print(" " + string);
        if (++this.d_lineCount >= 16) {
            this.newLine();
        }
    }
}

