/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.utils;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GradientPainter {
    private Composite comp;
    private Color startColor;
    private Color endColor;
    private Image backgroundImage;

    public GradientPainter(Composite composite, Color color, Color color2) {
        this.comp = composite;
        this.startColor = color;
        this.endColor = color2;
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GradientPainter.this.drawBackgound();
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (GradientPainter.this.backgroundImage != null) {
                    GradientPainter.this.backgroundImage.dispose();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawBackgound() {
        Image image = this.backgroundImage;
        Display display = this.comp.getDisplay();
        Rectangle rectangle = this.comp.getClientArea();
        this.backgroundImage = new Image((Device)display, rectangle.width, rectangle.height);
        GC gC = new GC((Drawable)this.backgroundImage);
        try {
            gC.setForeground(this.startColor);
            gC.setBackground(this.endColor);
            gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            this.comp.setBackgroundImage(this.backgroundImage);
        }
        finally {
            gC.dispose();
            if (image != null) {
                image.dispose();
            }
        }
    }
}

