/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.AppHelper;
import com.pervasive.utilities.notificationviewer.DetailsView;
import com.pervasive.utilities.notificationviewer.Exe4JStartupListener;
import com.pervasive.utilities.notificationviewer.NotificationSelectionListener;
import com.pervasive.utilities.notificationviewer.NotificationView;
import com.pervasive.utilities.notificationviewer.ShutdownEventHandler;
import com.pervasive.utilities.notificationviewer.ShutdownHandler;
import com.pervasive.utilities.notificationviewer.SystemTray;
import com.pervasive.utilities.notificationviewer.actions.MarkAllReadAction;
import com.pervasive.utilities.notificationviewer.actions.ShowUnreadAction;
import com.pervasive.utilities.notificationviewer.model.Notification;
import com.pervasive.utilities.notificationviewer.utils.GridHelper;
import com.pervasive.utilities.notificationviewer.utils.MessageCatalog;
import com.pervasive.utilities.notificationviewer.utils.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NotificationViewerApp
extends ApplicationWindow
implements NotificationSelectionListener,
ControlListener {
    private boolean startInTrayOnly;
    private SystemTray systemTray;
    private Shell shell;
    private SashForm sash;
    private DetailsView detailsView;
    private Action showUnreadOnlyAction;
    private Action markAllReadAction;
    private AppHelper appHelper;

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0 && (string = MiscUtils.removeQuotes(stringArray[0])).equalsIgnoreCase("-stop")) {
            return;
        }
        MessageCatalog.init("com.pervasive.utilities.notificationviewer.resources.Messages");
        Display.setAppName((String)MessageCatalog.getMsg("AppTitle"));
        NotificationViewerApp notificationViewerApp = new NotificationViewerApp(string);
        notificationViewerApp.setBlockOnOpen(true);
        notificationViewerApp.open();
        Display.getCurrent().dispose();
    }

    public static ImageRegistry getImageRegistry() {
        return JFaceResources.getImageRegistry();
    }

    public static FontRegistry getFontRegistry() {
        return JFaceResources.getFontRegistry();
    }

    public static ColorRegistry getColorRegistry() {
        return JFaceResources.getColorRegistry();
    }

    NotificationViewerApp(String string) {
        super(null);
        if (string != null && string.equals("-tray")) {
            this.startInTrayOnly = true;
        }
        this.appHelper = new AppHelper(this);
        this.addToolBar(0x820000);
        this.addStatusLine();
        Runtime.getRuntime().addShutdownHook(new ShutdownHandler(this.appHelper));
        if (MiscUtils.isWinOS()) {
            ShutdownEventHandler shutdownEventHandler = new ShutdownEventHandler(this.appHelper);
            Thread thread = new Thread(shutdownEventHandler);
            thread.setDaemon(true);
            thread.start();
        }
    }

    protected ToolBarManager createToolBarManager(int n) {
        ToolBarManager toolBarManager = new ToolBarManager(n);
        this.showUnreadOnlyAction = new ShowUnreadAction(this.appHelper);
        this.markAllReadAction = new MarkAllReadAction(this.appHelper);
        toolBarManager.add((IAction)this.showUnreadOnlyAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.markAllReadAction);
        return toolBarManager;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.shell = shell;
        shell.setText(MessageCatalog.getMsg("AppTitle"));
        ImageRegistry imageRegistry = NotificationViewerApp.getImageRegistry();
        this.createImages(imageRegistry);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(imageRegistry.get("appIcon16"));
        arrayList.add(imageRegistry.get("appIcon24"));
        arrayList.add(imageRegistry.get("appIcon32"));
        arrayList.add(imageRegistry.get("appIcon48"));
        arrayList.add(imageRegistry.get("appIcon96"));
        arrayList.add(imageRegistry.get("appIcon128"));
        arrayList.add(imageRegistry.get("appIcon256"));
        arrayList.add(imageRegistry.get("appIcon16@2x"));
        arrayList.add(imageRegistry.get("appIcon32@2x"));
        arrayList.add(imageRegistry.get("appIcon128@2x"));
        if (NotificationViewerApp.notLinux()) {
            arrayList.add(imageRegistry.get("appIcon256@2x"));
        }
        Image[] imageArray = new Image[arrayList.size()];
        shell.setImages(arrayList.toArray(imageArray));
        ColorRegistry colorRegistry = NotificationViewerApp.getColorRegistry();
        colorRegistry.put("PANEL_HEADING_BACKGROUND", new RGB(180, 206, 239));
        colorRegistry.put("LIST_HEADING_START", new RGB(82, 123, 189));
        colorRegistry.put("LIST_HEADING_END", new RGB(140, 181, 230));
        colorRegistry.put("SELECTED_ITEM_BACKGROUND", new RGB(210, 210, 210));
        this.markAllReadAction.setImageDescriptor(NotificationViewerApp.getImageRegistry().getDescriptor("mark_all_read"));
        this.showUnreadOnlyAction.setImageDescriptor(NotificationViewerApp.getImageRegistry().getDescriptor("show_unread_only"));
        this.systemTray = new SystemTray(this, shell);
        shell.addControlListener((ControlListener)this);
        if (MiscUtils.isWinOS()) {
            try {
                Exe4JStartupListener exe4JStartupListener = new Exe4JStartupListener(this);
                exe4JStartupListener.register();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        if (this.systemTray.isTrayItemSupported() && this.startInTrayOnly) {
            this.shell.setMinimized(true);
        }
        this.shell.open();
        if (this.systemTray.isTrayItemSupported() && this.startInTrayOnly) {
            this.shell.setVisible(false);
        }
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getReturnCode();
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = this.appHelper.getInitialLocation();
        if (point2.x > Integer.MIN_VALUE) {
            return point2;
        }
        return super.getInitialLocation(point);
    }

    protected Point getInitialSize() {
        return this.appHelper.getInitialSize();
    }

    protected Control createContents(Composite composite) {
        this.sash = new SashForm(composite, 65792);
        FillLayout fillLayout = new FillLayout();
        this.sash.setLayout((Layout)fillLayout);
        NotificationView notificationView = this.createNotificationPanel((Composite)this.sash);
        Composite composite2 = this.createDetailsPanel((Composite)this.sash);
        this.sash.SASH_WIDTH = 2;
        this.sash.setWeights(this.appHelper.getSashWeights());
        composite2.addControlListener((ControlListener)this);
        this.appHelper.setViewer(notificationView);
        this.appHelper.initViewer();
        this.showUnread();
        this.showNotificationCount(this.appHelper.getNotificationCount());
        return this.sash;
    }

    private NotificationView createNotificationPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillBoth((Control)composite2);
        CLabel cLabel = new CLabel(composite2, 2048);
        GridHelper gridHelper = new GridHelper((Control)cLabel);
        gridHelper.fillHorizontal(-1, 1);
        gridHelper.setHeightHint(30);
        cLabel.setAlignment(16384);
        cLabel.setText(MessageCatalog.getMsg("NotificationsPanel.Heading"));
        FontData fontData = MiscUtils.createIncrSizeFontData(cLabel.getFont(), 1);
        NotificationViewerApp.getFontRegistry().put("PANEL_HEADING_FONT", new FontData[]{fontData});
        cLabel.setFont(NotificationViewerApp.getFontRegistry().getBold("PANEL_HEADING_FONT"));
        cLabel.setBackground(NotificationViewerApp.getColorRegistry().get("PANEL_HEADING_BACKGROUND"));
        NotificationView notificationView = new NotificationView(composite2);
        GridHelper.layoutFillBoth(notificationView.getControl());
        notificationView.addNotificationSelectionListener(this);
        return notificationView;
    }

    private Composite createDetailsPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillBoth((Control)composite2);
        CLabel cLabel = new CLabel(composite2, 2048);
        GridHelper gridHelper = new GridHelper((Control)cLabel);
        gridHelper.fillHorizontal(-1, 1);
        gridHelper.setHeightHint(30);
        cLabel.setAlignment(16384);
        cLabel.setText(MessageCatalog.getMsg("DetailsPanel.Heading"));
        cLabel.setFont(NotificationViewerApp.getFontRegistry().getBold("PANEL_HEADING_FONT"));
        cLabel.setBackground(NotificationViewerApp.getColorRegistry().get("PANEL_HEADING_BACKGROUND"));
        this.detailsView = new DetailsView(composite2);
        GridHelper.layoutFillBoth((Control)this.detailsView);
        return composite2;
    }

    public void controlMoved(ControlEvent controlEvent) {
        this.appHelper.saveWindowState();
    }

    public void controlResized(ControlEvent controlEvent) {
        this.appHelper.saveWindowState();
    }

    public void showAllRead() {
        this.systemTray.showUnreadImage(false);
        this.systemTray.setTooltip(null);
    }

    @Override
    public void notificationSelected(Notification notification) {
        if (notification != null) {
            String string = notification.getDetails();
            this.detailsView.showDetails(string != null ? string : "", notification.getOEMInfo());
            this.appHelper.markNotificationRead(notification);
        } else {
            this.detailsView.showDetails("", null);
        }
        this.showUnread();
    }

    SashForm getSash() {
        return this.sash;
    }

    void show() {
        if (this.shell.getMinimized()) {
            this.shell.setMinimized(false);
        } else if (!this.shell.isVisible()) {
            this.appHelper.reloadViewer();
            this.showNotificationCount(this.appHelper.getNotificationCount());
        }
        this.shell.setFocus();
        this.shell.setVisible(true);
    }

    public boolean isShowing() {
        return this.shell.isVisible() && !this.shell.getMinimized();
    }

    public void showUnread() {
        int n = 0;
        int n2 = this.appHelper.getUnreadNotificationsCount();
        this.systemTray.showUnreadImage(n2 > 0);
        if (n2 > 0) {
            n = this.appHelper.getCriticalUnreadNotificationsCount();
        }
        this.setHoverTooltip(n2, n);
    }

    protected void handleShellCloseEvent() {
        if (this.systemTray.isTrayItemSupported()) {
            this.shell.setVisible(false);
        } else {
            this.setReturnCode(1);
            this.close();
            this.appHelper.shutdown();
        }
    }

    public void showNotificationCount(int n) {
        String string = MessageCatalog.getMsg("StatusBar.NotificationCountMsg", n);
        this.getStatusLineManager().setMessage(string);
    }

    public void showErrorMessage(String string) {
        this.getStatusLineManager().setErrorMessage(JFaceResources.getImage((String)"dialog_message_error_image"), string);
    }

    public void showNotificationTooltip(List<Notification> list) {
        this.shell.getDisplay().asyncExec((Runnable)new DelayedNotificationTooltip(list));
    }

    public void showNotificationTooltipInternal(List<Notification> list) {
        String string = null;
        String string2 = null;
        int n = 1;
        if (list.size() == 1) {
            string = list.get(0).getDescription();
            string2 = list.get(0).getCaption();
            n = list.get(0).getErrorLevel();
        } else {
            for (Notification notification : list) {
                if (notification.getErrorLevel() <= n) continue;
                n = notification.getErrorLevel();
            }
            string2 = this.getCaptionForLevel(n);
            string = this.getMsgForLevel(n);
        }
        this.systemTray.showBalloonMessage(string, string2, n);
    }

    private void setHoverTooltip(int n, int n2) {
        String string = null;
        if (n > 0) {
            string = n2 == 0 ? MessageCatalog.getMsg("Tray.Tooltip.UnreadCnt.Msg", new Object[]{n}) : MessageCatalog.getMsg("Tray.Tooltip.Important.UnreadCnt.Msg", new Object[]{n2, n});
        }
        this.systemTray.setTooltip(string);
    }

    private String getCaptionForLevel(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = MessageCatalog.getMsg("Tray.BalloonTooltip.MultiNotification.Info.Caption");
                break;
            }
            case 2: {
                string = MessageCatalog.getMsg("Tray.BalloonTooltip.MultiNotification.Warn.Caption");
                break;
            }
            case 3: {
                string = MessageCatalog.getMsg("Tray.BalloonTooltip.MultiNotification.Error.Caption");
            }
        }
        return string;
    }

    private String getMsgForLevel(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = MessageCatalog.getMsg("Tray.BalloonTooltip.MultiNotification.Info.Msg");
                break;
            }
            case 2: {
                string = MessageCatalog.getMsg("Tray.BalloonTooltip.MultiNotification.Warn.Msg");
                break;
            }
            case 3: {
                string = MessageCatalog.getMsg("Tray.BalloonTooltip.MultiNotification.Error.Msg");
            }
        }
        return string;
    }

    private void createImages(ImageRegistry imageRegistry) {
        imageRegistry.put("appIcon16", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon16.png"));
        imageRegistry.put("appIcon16", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_16x16.png"));
        imageRegistry.put("appIcon24", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_24x24.png"));
        imageRegistry.put("appIcon32", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_32x32.png"));
        imageRegistry.put("appIcon48", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_48x48.png"));
        imageRegistry.put("appIcon96", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_96x96.png"));
        imageRegistry.put("appIcon128", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_128x128.png"));
        imageRegistry.put("appIcon256", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_256x256.png"));
        imageRegistry.put("appIcon16@2x", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_16x16_2x.png"));
        imageRegistry.put("appIcon32@2x", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_32x32_2x.png"));
        imageRegistry.put("appIcon128@2x", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_128x128_2x.png"));
        imageRegistry.put("appIcon256@2x", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/app_icon_256x256_2x.png"));
        imageRegistry.put("expand", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/expand.png"));
        imageRegistry.put("collapse", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/collapse.png"));
        imageRegistry.put("tray_unread", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/tray_unread.png"));
        imageRegistry.put("tray_no_unread", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/tray_no_unread.png"));
        imageRegistry.put("mark_all_read", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/mark_all_read.png"));
        imageRegistry.put("show_unread_only", ImageDescriptor.createFromFile(NotificationViewerApp.class, (String)"images/show_unread_only.png"));
    }

    private static boolean notLinux() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    }

    class DelayedNotificationTooltip
    implements Runnable {
        List<Notification> notifications;

        DelayedNotificationTooltip(List<Notification> list) {
            this.notifications = list;
        }

        @Override
        public void run() {
            NotificationViewerApp.this.showNotificationTooltipInternal(this.notifications);
        }
    }
}

