/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer;

import com.pervasive.utilities.notificationviewer.AppHelper;
import com.pervasive.utilities.notificationviewer.utils.MiscUtils;

public class LogMonitor
implements Runnable {
    private boolean stop = false;
    private AppHelper helper;
    private Thread thread;
    int dayOfMonth;

    public LogMonitor(AppHelper appHelper) {
        this.helper = appHelper;
        this.dayOfMonth = MiscUtils.getDayOfMonth();
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        while (!this.stop) {
            try {
                Thread.sleep(30000L);
                int n = MiscUtils.getDayOfMonth();
                if (n != this.dayOfMonth) {
                    this.dayOfMonth = n;
                    this.helper.getDisplay().asyncExec((Runnable)new RecomputeBucketsTask());
                    continue;
                }
                if (!this.helper.logFileModified()) continue;
                this.helper.getDisplay().asyncExec((Runnable)new RefreshNotificationsTask());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        this.stop = true;
        this.thread.interrupt();
    }

    class RefreshNotificationsTask
    implements Runnable {
        RefreshNotificationsTask() {
        }

        @Override
        public void run() {
            LogMonitor.this.helper.readNewNotifcations();
        }
    }

    class RecomputeBucketsTask
    implements Runnable {
        RecomputeBucketsTask() {
        }

        @Override
        public void run() {
            LogMonitor.this.helper.recomputeBuckets();
        }
    }
}

