/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.guipaadm.pages;

import com.pervasive.utilities.guipaadm.PSResultException;
import com.pervasive.utilities.guipaadm.PhoneActivationApp;
import com.pervasive.utilities.guipaadm.PhoneActivationState;
import com.pervasive.utilities.guipaadm.PhoneActivationSupport;
import com.pervasive.utilities.guipaadm.ProductKeyInfo;
import com.pervasive.utilities.guipaadm.pages.FormHtmlBuilder;
import com.pervasive.utilities.util.GridHelper;
import com.pervasive.utilities.util.MessageCatalog;
import com.pervasive.utilities.wizard.WizardPageExt;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;

public class SummaryPage
extends WizardPageExt {
    private static final int REMAINING_AUTH_SHOW_THRESHOLD = 100;
    private Text completionStatus;
    private FormText summaryTxt;
    private ScrolledComposite scrolledComp;

    public SummaryPage() {
        super("SummaryPage", MessageCatalog.getMsg("SummaryPage.Title"), MessageCatalog.getMsg("SummaryPage.Desc"), null);
        this.setPageComplete(true);
    }

    @Override
    public void createContent(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridHelper.layoutFillBoth((Control)composite2, 0, 0, 0, 0);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginTop = 10;
        composite3.setLayout((Layout)gridLayout2);
        GridHelper.layoutFillHorizontal((Control)composite3, -1, 0);
        this.completionStatus = new Text(composite3, 8);
        this.completionStatus.setFont(PhoneActivationApp.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        this.completionStatus.setForeground(PhoneActivationApp.getColorRegistry().get("wizardBlue"));
        GridHelper.layoutFillHorizontal((Control)this.completionStatus, -1, 0);
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 1;
        composite4.setLayout((Layout)gridLayout3);
        GridHelper.layoutFillBoth((Control)composite4, -1, -1, 0, 0);
        Label label = new Label(composite4, 0);
        label.setText(MessageCatalog.getMsg("SummaryPage.Details"));
        this.completionStatus.setBackground(label.getBackground());
        this.scrolledComp = new ScrolledComposite(composite4, 2560);
        this.summaryTxt = new FormText((Composite)this.scrolledComp, 0);
        this.scrolledComp.setContent((Control)this.summaryTxt);
        this.scrolledComp.setExpandHorizontal(true);
        this.scrolledComp.setExpandVertical(true);
        this.scrolledComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = SummaryPage.this.scrolledComp.getClientArea();
                SummaryPage.this.scrolledComp.setMinSize(SummaryPage.this.summaryTxt.computeSize(rectangle.width, -1));
            }
        });
        GridHelper.layoutFillBoth((Control)this.scrolledComp, 200, 0, 0, 0);
    }

    @Override
    public void populate() {
        PhoneActivationState phoneActivationState = (PhoneActivationState)this.getModel();
        FormHtmlBuilder formHtmlBuilder = new FormHtmlBuilder();
        if (phoneActivationState.hasError()) {
            this.completionStatus.setText(MessageCatalog.getMsg("SummaryPage.FailureMsg"));
            formHtmlBuilder.addParagraph(PhoneActivationSupport.getErrorString(phoneActivationState.getErrorCode()));
            formHtmlBuilder.addParagraph(this.getSummaryMessage(phoneActivationState.getErrorCode()));
            try {
                ProductKeyInfo productKeyInfo = PhoneActivationSupport.decodeProductKey(phoneActivationState.getProductKey());
                if (productKeyInfo.getKeyVersion() > 1) {
                    formHtmlBuilder.addParagraph(this.formatProductKeyInfo(productKeyInfo));
                }
            }
            catch (PSResultException pSResultException) {
                // empty catch block
            }
            formHtmlBuilder.end();
            this.summaryTxt.setText(formHtmlBuilder.toString(), true, false);
        } else {
            this.completionStatus.setText(MessageCatalog.getMsg("SummaryPage.SuccessMsg"));
            if (phoneActivationState.isActivatedOnline()) {
                short s = phoneActivationState.getRemainingUsageCount();
                formHtmlBuilder.addText(MessageCatalog.getMsg("SummaryPage.OnlineSuccessDetails"));
                if (s >= 0 && s <= 100) {
                    formHtmlBuilder.addText(MessageCatalog.getMsg("SummaryPage.OnlineAuthUsageMsg", Integer.toString(s)));
                    if (s == 0) {
                        formHtmlBuilder.addText(MessageCatalog.getMsg("SummaryPage.OnlineAuthZeroRemainMsg"));
                    }
                }
                formHtmlBuilder.addText(MessageCatalog.getMsg("SummaryPage.SuccessDetails"));
            }
            formHtmlBuilder.end();
            this.summaryTxt.setText(formHtmlBuilder.toString(), true, false);
        }
        this.scrolledComp.pack();
        this.scrolledComp.getParent().layout(true, true);
    }

    @Override
    public boolean canCancel() {
        PhoneActivationState phoneActivationState = (PhoneActivationState)this.getModel();
        return phoneActivationState.hasError();
    }

    @Override
    public boolean allowBack() {
        PhoneActivationState phoneActivationState = (PhoneActivationState)this.getModel();
        return phoneActivationState.hasError();
    }

    @Override
    public boolean isFinishPage() {
        return true;
    }

    @Override
    public void applyPage() {
    }

    private String getSummaryMessage(int n) {
        String string = null;
        if (n >= 7150 && n <= 7158) {
            string = MessageCatalog.getMsg("ErrorMsg.ELSLoadError");
        } else if (n > 7000 && n < 7200) {
            string = MessageCatalog.getMsg("ErrorMsg.InvalidProductKey");
        } else {
            string = MessageCatalog.getMsg("ErrorMsg." + n);
            if (string == null) {
                string = MessageCatalog.getMsg("ErrorMsg.Default");
            }
        }
        return string;
    }

    private String formatProductKeyInfo(ProductKeyInfo productKeyInfo) {
        return MessageCatalog.getMsg("SummaryPage.ProductInfo", new Object[]{productKeyInfo.getProductStr(), productKeyInfo.getOSPlatformStr(), productKeyInfo.getLictypeStr(), productKeyInfo.getOemid(), productKeyInfo.getUsercount()});
    }
}

