/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DBFileTable;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.MkdeClientElement;
import com.pervasive.psql.utilities.javadti.PVCLIENTID;
import com.pervasive.psql.utilities.javadti.PVMKDECLIENTHDLINFO;
import com.pervasive.psql.utilities.javadti.PVMKDECLIENTINFO;
import com.pervasive.psql.utilities.javadti.TableNotFoundException;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;

public class MkdeClient {
    private static Map<Connection, MkdeClient> clientMap = new HashMap<Connection, MkdeClient>();
    private Connection m_conn;
    private long m_nClient = -1L;
    private long m_nHandle = -1L;
    private Logger m_logger;
    private boolean m_bInitialized = false;
    private MkdeClientElement[] clientElements;

    private MkdeClient(Connection connection, String string) {
        this.m_conn = connection;
        this.m_logger = Logger.getLogger(string);
    }

    public static MkdeClient getObject(Connection connection, String string) {
        MkdeClient mkdeClient = clientMap.get(connection);
        if (mkdeClient != null) {
            return mkdeClient;
        }
        mkdeClient = new MkdeClient(connection, string);
        clientMap.put(connection, mkdeClient);
        return mkdeClient;
    }

    public MkdeClientElement[] getData(String string) throws DTIException {
        DBFileTable dBFileTable = null;
        if (string.equals("SQL")) {
            dBFileTable = new DBFileTable(this.m_conn);
        }
        this.clientElements = null;
        long l = this.getCount();
        if (l > 0L) {
            this.clientElements = new MkdeClientElement[(int)l];
            int n = 0;
            while ((long)n < l) {
                this.clientElements[n] = new MkdeClientElement();
                PVCLIENTID pVCLIENTID = new PVCLIENTID();
                this.getMkdeClientId(n, pVCLIENTID);
                this.clientElements[n].setClientId(pVCLIENTID);
                PVMKDECLIENTINFO pVMKDECLIENTINFO = new PVMKDECLIENTINFO();
                this.getMkdeClientInfo(pVCLIENTID, pVMKDECLIENTINFO);
                this.clientElements[n].setClientInfo(pVMKDECLIENTINFO);
                long l2 = this.getMkdeClientHandlesData(pVCLIENTID);
                if (l2 > 0L) {
                    PVMKDECLIENTHDLINFO[] pVMKDECLIENTHDLINFOArray = new PVMKDECLIENTHDLINFO[(int)l2];
                    int n2 = 0;
                    while ((long)n2 < l2) {
                        pVMKDECLIENTHDLINFOArray[n2] = new PVMKDECLIENTHDLINFO();
                        this.getMkdeClientHandlesInfo(pVCLIENTID, n2, pVMKDECLIENTHDLINFOArray[n2]);
                        if (string.equals("SQL")) {
                            try {
                                if (dBFileTable != null) {
                                    pVMKDECLIENTHDLINFOArray[n2].setFileName(dBFileTable.getTableName(pVMKDECLIENTHDLINFOArray[n2].getFileName()));
                                }
                            }
                            catch (DataFormatException dataFormatException) {
                                pVMKDECLIENTHDLINFOArray[n2].setFileName("");
                            }
                            catch (DTIException dTIException) {
                                pVMKDECLIENTHDLINFOArray[n2].setFileName("");
                            }
                            catch (TableNotFoundException tableNotFoundException) {
                                pVMKDECLIENTHDLINFOArray[n2].setFileName("");
                            }
                        }
                        ++n2;
                    }
                    this.clientElements[n].setClientHdlInfo(pVMKDECLIENTHDLINFOArray);
                }
                ++n;
            }
        }
        if (dBFileTable != null) {
            dBFileTable.free();
        }
        return this.clientElements;
    }

    public long getCount() throws DTIException {
        if (this.m_bInitialized) {
            this.freeData();
        }
        this.m_nClient = this.getMkdeClientsData();
        this.m_bInitialized = true;
        return this.m_nClient;
    }

    public void dispose() throws DTIException {
        this.freeData();
        Iterator<Connection> iterator = clientMap.keySet().iterator();
        Connection connection = null;
        while (iterator.hasNext()) {
            Connection connection2 = iterator.next();
            if (!connection2.equals(this.m_conn)) continue;
            connection = connection2;
            break;
        }
        if (connection != null) {
            clientMap.remove(connection);
        }
    }

    private void freeData() throws DTIException {
        if (this.m_bInitialized) {
            this.freeMkdeClientsData();
        }
        if (this.clientElements != null) {
            int n = 0;
            while (n < this.clientElements.length) {
                this.clientElements[n].dispose();
                ++n;
            }
        }
    }

    private long getMkdeClientsData() throws DTIException {
        long[] lArray = new long[1];
        int n = javadti.JPvGetMkdeClientsData(this.m_conn.getHandle(), lArray);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeClientsData failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeClientsData succeeded");
        this.m_logger.finer("Total active client: " + lArray[0]);
        return lArray[0];
    }

    public void getMkdeClientId(long l, PVCLIENTID pVCLIENTID) throws DTIException {
        int n = javadti.JPvGetMkdeClientId(this.m_conn.getHandle(), l, pVCLIENTID);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeClientId failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeClientId succeeded");
    }

    public void getMkdeClientInfo(PVCLIENTID pVCLIENTID, PVMKDECLIENTINFO pVMKDECLIENTINFO) throws DTIException {
        int n = javadti.JPvGetMkdeClientInfo(this.m_conn.getHandle(), pVCLIENTID, pVMKDECLIENTINFO);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeClientInfo failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeClientInfo succeeded");
    }

    public long getMkdeClientHandlesData(PVCLIENTID pVCLIENTID) throws DTIException {
        long[] lArray = new long[]{-1L};
        int n = javadti.JPvGetMkdeClientHandlesData(this.m_conn.getHandle(), pVCLIENTID, lArray);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeClientHandleData failed");
            throw new DTIException(n);
        }
        this.m_nHandle = lArray[0];
        this.m_logger.finer("JPvGetMkdeClientHandleData succeeded");
        this.m_logger.finer("Total MKDE client handles: " + this.m_nHandle);
        return this.m_nHandle;
    }

    public void getMkdeClientHandlesInfo(PVCLIENTID pVCLIENTID, long l, PVMKDECLIENTHDLINFO pVMKDECLIENTHDLINFO) throws DTIException {
        int n = javadti.JPvGetMkdeClientHandleInfo(this.m_conn.getHandle(), pVCLIENTID, l, pVMKDECLIENTHDLINFO);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetMkdeClientHandleInfo failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetMkdeClientHandleInfo succeeded");
    }

    private void freeMkdeClientsData() throws DTIException {
        int n = javadti.JPvFreeMkdeClientsData(this.m_conn.getHandle());
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvFreeMkdeClientData failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvFreeMkdeClientData succeeded");
    }

    public void disconnectMkdeClient(PVCLIENTID pVCLIENTID) throws DTIException {
        int n = javadti.JPvDisconnectMkdeClient(this.m_conn.getHandle(), pVCLIENTID);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvDisconnectionMkdeClient failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvDisconnectionMkdeClient succeeded");
    }
}

