/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIInfo;
import com.pervasive.psql.utilities.javadti.DTIUtils;
import com.pervasive.psql.utilities.javadti.Messages;
import com.pervasive.psql.utilities.javadti.PVFILEINFO2;
import com.pervasive.psql.utilities.javadti.TABLESTAT3;
import com.pervasive.psql.utilities.javadti.TableNotFoundException;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.Arrays;
import java.util.logging.Logger;

public class DBDictionary {
    private int handle;
    private int count = 0;
    private Logger logger;
    private final int MAX_LEN = 248;
    private final int BUFFERSIZE = 30720;
    private String[] tablelist = null;
    private Connection conObj;
    private String openSpec;
    private String user = "";
    private String pwd = "";
    private boolean initialized = false;

    public DBDictionary(String string) throws DTIException {
        this.openSpec = string;
    }

    public DBDictionary(Connection connection, String string, String string2, String string3) throws DTIException {
        this.conObj = connection;
        this.openSpec = string;
        this.user = string2;
        this.pwd = string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initialize() throws DTIException {
        if (this.initialized) {
            return;
        }
        if (this.conObj != null) {
            this.logger = Logger.getLogger(DTIInfo.getLoggerName());
            int[] nArray = new int[1];
            int n = javadti.JPvOpenDatabase(this.conObj.getHandle(), this.openSpec, this.user, this.pwd, nArray);
            if (n != DTICONSTS.P_OK) {
                this.logger.finer("JPvOpenDatabase Failed.");
                throw new DTIException(n);
            }
            this.handle = nArray[0];
            this.logger.finer("JPvOpenDatabase Success");
        } else {
            this.logger = Logger.getLogger(DTIInfo.getLoggerName());
            int[] nArray = new int[1];
            int n = javadti.JPvOpenDictionary(this.openSpec, nArray, this.user, this.pwd);
            if (n != DTICONSTS.P_OK) {
                this.logger.finer("JPvOpenDictionary Failed.");
                throw new DTIException(n);
            }
            this.handle = nArray[0];
            this.logger.finer("JPvOpenDictionary Success");
        }
        this.initialized = true;
    }

    public void free() throws DTIException {
        if (this.initialized) {
            this.initialized = false;
            int n = 0;
            n = this.conObj == null ? javadti.JPvCloseDictionary(this.handle) : javadti.JPvCloseDatabase(this.handle);
            if (n == DTICONSTS.P_OK) {
                this.logger.finer("JPvCloseDictionary/Database Success");
            } else {
                this.logger.finer("JPvCloseDictionary/Database Failed.");
                throw new DTIException(n);
            }
        }
    }

    public DBDictionary(String string, String string2, String string3) throws DTIException {
        this.openSpec = string;
        this.user = string2;
        this.pwd = string3;
    }

    public int getCount() throws DTIException {
        this.initialize();
        int[] nArray = new int[1];
        int n = javadti.JPvGetTableCount(this.handle, nArray);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvGetTableNames failed");
            throw new DTIException(n);
        }
        this.count = nArray[0];
        this.logger.finer("JPvGetTableNames success, Count: " + this.count);
        return this.count;
    }

    public String getBtrieveFileList(String string) throws DTIException {
        this.initialize();
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[1];
        byte[] byArray = new byte[30720];
        int n = 0;
        while ((n = javadti.JPvGetBtrvFileList(this.handle, string, 30720, byArray, nArray)) == DTICONSTS.PCM_SuccessWithInfo) {
            stringBuffer.append(DTIUtils.getLocaleString(byArray));
            stringBuffer.append(";");
            Arrays.fill(byArray, 0, 30719, (byte)0);
        }
        if (n != DTICONSTS.P_OK) {
            this.logger.warning("JPvGetBtrvFileList failed: " + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n);
        }
        stringBuffer.append(DTIUtils.getLocaleString(byArray));
        this.logger.finer("JPvGetBtrvFileList Success - Path: " + stringBuffer);
        return stringBuffer.toString();
    }

    public String[] getTableNames() throws DTIException {
        this.initialize();
        this.tablelist = new String[this.count];
        byte[] byArray = new byte[248];
        int n = 0;
        int[] nArray = new int[1];
        int n2 = 0;
        while (n2 < this.count) {
            n = javadti.JPvGetTableName(this.handle, n2, byArray, nArray);
            if (n != DTICONSTS.P_OK) {
                this.logger.finer("JPvGetTableName Failed");
                throw new DTIException(n);
            }
            this.tablelist[n2] = DTIUtils.getLocaleString(byArray).substring(0, nArray[0]);
            ++n2;
        }
        return this.tablelist;
    }

    public String getTableInfo(String string) throws DTIException {
        return "";
    }

    public void getFileInfo(String string) throws DTIException {
        if (this.conObj == null) {
            return;
        }
        PVFILEINFO2 pVFILEINFO2 = new PVFILEINFO2();
        try {
            javadti.JPvGetFileInfo(this.conObj.getHandle(), string, pVFILEINFO2);
        }
        finally {
            pVFILEINFO2.delete();
            pVFILEINFO2 = null;
        }
    }

    public TABLESTAT3 getTableStatInfo(String string) throws DTIException {
        if (this.conObj == null) {
            return null;
        }
        this.initialize();
        TABLESTAT3 tABLESTAT3 = new TABLESTAT3();
        int n = javadti.JPvGetTableStat(this.handle, string, tABLESTAT3);
        if (n == DTICONSTS.P_OK) {
            this.logger.finer("JPvGetTableStat success, Name: " + tABLESTAT3.getTableName());
            return tABLESTAT3;
        }
        this.logger.finer("JPvGetTableStat failed");
        throw new DTIException(Messages.get("dti.stat.error"));
    }

    public String getMatchingTable(String string) throws DTIException, TableNotFoundException {
        int n = this.getCount();
        this.getTableNames();
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = this.getTableInfo(this.tablelist[n2]);
            if (string2.compareToIgnoreCase(string) == 0) {
                return this.tablelist[n2];
            }
            ++n2;
        }
        throw new TableNotFoundException(Messages.get("dti.table.not.found", new String[]{string}));
    }

    public String getFileName(String string) {
        try {
            this.initialize();
            byte[] byArray = new byte[512];
            int[] nArray = new int[]{512};
            javadti.JPvGetFileName(this.handle, string, byArray, nArray);
            return DTIUtils.getLocaleString(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void secure(String string, long l) throws DTIException {
        this.pwd = string;
        this.secure(l);
    }

    public void secure(long l) throws DTIException {
        int n = javadti.JPvSecureDatabase2(this.conObj.getHandle(), this.openSpec, this.pwd, l);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvSecureDatabase2 failed");
            throw new DTIException(n);
        }
        this.logger.finer("JPvSecureDatabase2 success");
    }

    public void unsecure() throws DTIException {
        int n = javadti.JPvUnSecureDatabase(this.conObj.getHandle(), this.openSpec, this.user, this.pwd);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvUnSecureDatabase failed");
            throw new DTIException(n);
        }
        this.logger.finer("JPvUnSecureDatabase success");
    }

    public long isSecure() throws DTIException {
        long[] lArray = new long[1];
        int n = javadti.JPvIsDatabaseSecured(this.conObj.getHandle(), this.openSpec, lArray);
        if (n == DTICONSTS.P_OK) {
            this.logger.finer("JPvIsSecure success");
            return lArray[0];
        }
        this.logger.finer("JPvIsSecure failed");
        throw new DTIException(n);
    }
}

