#!/bin/sh

echo "+++++ Checking current user rights..."

if [ "$(id -u root)" = "$(id -u)" ] ; then
    :
else
    echo "ERROR: The current user id is not root (`id|awk '{print $1}'`)."
    exit 1
fi
echo


if [ "X$ACTIANZEN_ROOT" = "X" ] ; then
    ACTIANZEN_ROOT=/usr/local/actianzen
fi

LIBDIR=lib64

PATH=$ACTIANZEN_ROOT/bin:$PATH
if [ $(uname -s) = "Darwin" ]
then
    DYLD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    SO_EXTENSION="dylib"
else
    LD_LIBRARY_PATH=$ACTIANZEN_ROOT/bin:$ACTIANZEN_ROOT/lib:$ACTIANZEN_ROOT/lib64:$LD_LIBRARY_PATH
    SO_EXTENSION="so"
fi


echo "+++++ Removing Zen files..."
####################################################################################
#  Note: Any changes to the files to be removed must be made to the 
#        corresponding Zen_Linux.spec and Zen-Linux-Vx.spec files %postun sections. 
####################################################################################
HOMEDIR=`grep "^zen-svc:" /etc/passwd | cut -d: -f6`
rm -f  $HOMEDIR/.cshrc
rm -f  $HOMEDIR/.bash_profile
rm -f  $HOMEDIR/.bash_history
rm -f  $HOMEDIR/.bashrc

rm -f  $ACTIANZEN_ROOT/pvinst.log
rm -f  $ACTIANZEN_ROOT/LICENSE
rm -f  $ACTIANZEN_ROOT/Zen_Third_Party_Notice
rm -Rf $ACTIANZEN_ROOT/bin
rm -Rf $ACTIANZEN_ROOT/data/DEMODATA
rm -Rf $ACTIANZEN_ROOT/data/TEMPDB
rm -f  $ACTIANZEN_ROOT/data/samples/sample.btr
rm -f  $ACTIANZEN_ROOT/data/samples/upper.alt
rmdir $ACTIANZEN_ROOT/data/samples 2>/dev/null
rm -Rf $ACTIANZEN_ROOT/data/system/restore
rmdir $ACTIANZEN_ROOT/data 2>/dev/null
rm -Rf $ACTIANZEN_ROOT/docs
rm -f  $ACTIANZEN_ROOT/etc/confmig.log
rm -f  $ACTIANZEN_ROOT/etc/sqlmgr.pid
rm -f  $ACTIANZEN_ROOT/etc/preinstall.sh
rm -f  $ACTIANZEN_ROOT/etc/postinstall.sh
rm -f  $ACTIANZEN_ROOT/etc/postinstall.cfg
rm -f  $ACTIANZEN_ROOT/etc/preuninstall.sh
rm -f  $ACTIANZEN_ROOT/etc/postuninstall.sh
rm -f  $ACTIANZEN_ROOT/etc/psql-unixODBC-2.2.11.tar.gz
rm -Rf $ACTIANZEN_ROOT/etc/pipe
rm -Rf $ACTIANZEN_ROOT/etc/init.d
rm -Rf $ACTIANZEN_ROOT/lib
rm -Rf $ACTIANZEN_ROOT/lib64
rm -Rf $ACTIANZEN_ROOT/log
rm -Rf $ACTIANZEN_ROOT/jre
rm -Rf $ACTIANZEN_ROOT/man
rm -Rf $ACTIANZEN_ROOT/schemas
echo

rm -f /etc/init.d/actianzen /etc/rc.d/init.d/actianzen /usr/lib/ocf/resource.d/heartbeat/actianzen

# remove lock file directory (Debian Linux uses a different lock file directory then the other flavors of Linux)
if [ -d /var/lock/subsys ] ; then
    rm -f /var/lock/subsys/actianzen
else
    if [ $(uname -s) = "Darwin" ]
    then
        rm -f /var/tmp/actianzen
    else
        rm -f /var/state/actianzen
    fi
fi
SERVICES=/etc/services
if [ -f $SERVICES ] ; then
    sed '/PSQL MKDE daemon/d' $SERVICES > /tmp/services
    mv -f /tmp/services $SERVICES
fi
echo


echo "+++++ Removing Zen PAM settings..."

PAMCONF=/etc/pam.conf
PAMDIR=/etc/pam.d
if [ -f $PAMCONF ] ; then
    FOUND=`grep -c "^pvsw64" $PAMCONF`
    if [ $? -eq 0 ] ; then
	sed '/^pvsw64/d' $PAMCONF > /tmp/pam.conf
	mv -f /tmp/pam.conf $PAMCONF
    fi
fi
rm -f $PAMDIR/pvsw64
rm -f $PAMDIR/pvswauth
rm -f /$LIBDIR/security/pvswauth
rm -f /$LIBDIR/security/pam_pvsw.${SO_EXTENSION}*
if [ $(uname -s) = "Darwin" ]
then
    rm -f /usr/lib/pvswauth
    rm -f /usr/lib/pam_pvsw.${SO_EXTENSION}*
fi
echo

# If this is Darwin.
if [ $(uname -s) = "Darwin" ]
then
    APPLICATIONS="/Applications"

    # If there is an applications directory.
    if [ -d "$APPLICATIONS" ]
    then
        ACTIAN_ZEN_15="$APPLICATIONS/Actian Zen 15"
        UTILITIES="$ACTIAN_ZEN_15/Utilities"
        SCRIPTS="$ACTIAN_ZEN_15/Scripts"
        echo "+++++ Unpopulating the \"$ACTIAN_ZEN_15\" directory...."
        ERROR=0

        # If removing "Zen "Repair.app" fails.
        if ! rm -r "$SCRIPTS/Zen Repair.app" || ! rm "$SCRIPTS/.repair"
        then
            ERROR=1
        fi

        # If removing "Zen Authorize.app" fails.
        if ! rm -r "$SCRIPTS/Zen Authorize.app" || ! rm "$SCRIPTS/.authorize"
        then
            ERROR=1
        fi

        # If removing "Zen Licenses.app" fails.
        if ! rm -r "$SCRIPTS/Zen Licenses.app" || ! rm "$SCRIPTS/.licenses"
        then
            ERROR=1
        fi

        # If removing "Zen Deauthorize.app" fails.
        if ! rm -r "$SCRIPTS/Zen Deauthorize.app" || ! rm "$SCRIPTS/.deauthorize"
        then
            ERROR=1
        fi

        # If removing "Zen Start.app" fails.
        if ! rm -r "$SCRIPTS/Zen Start.app" || ! rm "$SCRIPTS/.start"
        then
            ERROR=1
        fi

        # If removing "Zen Status.app" fails.
        if ! rm -r "$SCRIPTS/Zen Status.app" || ! rm "$SCRIPTS/.status"
        then
            ERROR=1
        fi

        # If removing "Zen Stop.app" fails.
        if ! rm -r "$SCRIPTS/Zen Stop.app" || ! rm "$SCRIPTS/.stop"
        then
            ERROR=1
        fi

        # If removing "Zen Restart.app" fails.
        if ! rm -r "$SCRIPTS/Zen Restart.app" || ! rm "$SCRIPTS/.restart"
        then
            ERROR=1
        fi

        # If removing "messages" fails.
        if ! rm "$SCRIPTS/.messages"
        then
            ERROR=1
        fi

        # If removing ".DS_Store" fails.
        if ! rm -f "$SCRIPTS/.DS_Store"
        then
            ERROR=1
        fi

        # If removing "$SCRIPTS" fails.
        if ! rmdir "$SCRIPTS"
        then
            ERROR=1
        fi

        # If removing "Zen Phone Authorization.app" fails.
        if ! rm -r "$UTILITIES/Zen Phone Authorization.app"
        then
            ERROR=1
        fi

        # If removing "Zen Notification Viewer.app" fails.
        if ! rm -r "$UTILITIES/Zen Notification Viewer.app"
        then
            ERROR=1
        fi

        # If removing "Zen DDF Builder.app" fails.
        if ! rm -r "$UTILITIES/Zen DDF Builder.app"
        then
            ERROR=1
        fi

        # If removing ".DS_Store" fails.
        if ! rm -f "$UTILITIES/.DS_Store"
        then
            ERROR=1
            fi

        # If removing "$UTILITIES" fails.
        if ! rmdir "$UTILITIES"
        then
            ERROR=1
        fi

        # If removing "Zen Control Center.app" fails.
        if ! rm -r "$ACTIAN_ZEN_15/Zen Control Center.app"
        then
            ERROR=1
        fi

        # If removing "Zen Uninstall.app" fails.
        if ! rm -r "$ACTIAN_ZEN_15/Zen Uninstall.app" || ! rm "$ACTIAN_ZEN_15/.uninstall"
        then
            ERROR=1
        fi

        # If removing "messages" fails.
        if ! rm "$ACTIAN_ZEN_15/.messages"
        then
            ERROR=1
        fi

        # If removing ".DS_Store" fails.
        if ! rm -f "$ACTIAN_ZEN_15/.DS_Store"
        then
            ERROR=1
        fi

        # If removing "$ACTIAN_ZEN_15" fails.
        if ! rmdir "$ACTIAN_ZEN_15"
        then
            ERROR=1
        fi

        # If there were any errors.
        if [ "$ERROR" -eq 1 ]
        then
            echo "Error: Unable to correctly unpopulate the \"$ACTIAN_ZEN_15\" directory."
            exit 1
        fi

        echo
    fi
fi

echo "Uninstall has successfully completed."
echo

