/* Possible Column Attributes:
 * 1. DEFAULT 2. NULL 3. HEADING in Create View 4.Validation (Range check)
 * For the DEFAULT column attribute, one row is inserted into x$attrib. 
 * For rest of the three attributes, the PSQL Docs do not talk about it in detail.
 */
/**
 * This system procedure is used to return the list of
 * column attributes and the corresponding information 
 * in the current database.
 */
CREATE PROCEDURE psp_column_attributes
(   
	in :database_qual   VARCHAR(20) = DATABASE(), -- Name of the database
    in :table_name      VARCHAR(255) = NULL, -- Name of the table
    in :column_name     VARCHAR(255) = NULL  -- Name of the column 
)

RETURNS
(
    TABLE_QUALIFIER     VARCHAR (20), -- Name of the database that contains the table
    TABLE_OWNER         VARCHAR (20),  -- owner of the table
    TABLE_NAME          VARCHAR(255),   -- Name of the table
    COLUMN_NAME         VARCHAR(255),   -- Name of the column
    ATTRIB_TYPE         CHAR(10),    -- Type of the column attribute
    ATTRIB_SIZE         USMALLINT,  -- Size of the column attribute
    ATTRIB_VALUE        LONGVARCHAR -- Value of the column attribute
);

BEGIN
    -- Variable to hold the dynamic query
    declare :stmt_psp_column_attributes LONGVARCHAR;
    
    -- Check if the database qualifier specified is a blank string
	if (rtrim(:database_qual) = '') then
		SIGNAL 'S1000', 'Please enter a valid database name. Database name cannot be a blank string'; 
	end if;

     -- Check if the table_name specified is a blank string
	if (rtrim(:table_name) = '') then
		SIGNAL 'S1000', 'Table name cannot be a blank string'; 
	end if;

    -- Check if the table_name specified is a blank string
	if (rtrim(:column_name) = '') then
		SIGNAL 'S1000', 'Column name cannot be a blank string'; 
	end if;

	SET :database_qual = IFNULL(:database_qual, DATABASE());

	/*	If the table name is not supplied or the value is null, 
	    match all the tables */	
	SET :table_name  = IFNULL(:table_name,'%');
	
	/*	If the column name is not supplied or the value is null 
	    null match all the columns */
	SET :column_name = IFNULL(:column_name,'%');

	/* Enumerate all the column attributes */
		
	set :stmt_psp_column_attributes = ' SELECT ''' + 
			  :database_qual + 
			 ''', null, ' + 
			 ' A.Xf$Name, ' + 
			 ' B.Xe$Name, ' + 
			 ' case when (ISNUMERIC(C.Xa$Type) = 1 and C.Xa$Type = 68) or (ASCII( C.Xa$Type ) = 68) ' + 
			 	' then ' + '''DEFAULT''' + 
				' else' + 
				' case when (ISNUMERIC(C.Xa$Type) = 1 and C.Xa$Type = 79) or (ASCII( C.Xa$Type ) = 79) ' + 
					' then ' + '''COLLATE''' + 
					' else' + ' case when (ASCII( C.Xa$Type ) = 76) ' + 
						' then ' + '''L''' + 
						' else NULL' + 
						' end' + 
				' end' + 
			' end, ' + ' C.Xa$ASize, ' + ' C.Xa$Attrs ' + 
			' FROM  "' + 
			:database_qual + '".X$File A, "'  + 
			:database_qual + '".X$Field B, "' + 
			:database_qual + '".X$Attrib C ' +                  
			' WHERE A.Xf$Name LIKE ''' + :table_name + 
			''' AND A.Xf$Id = B.Xe$File AND ' + ' B.Xe$Name LIKE ''' + :column_name + 
			''' AND C.Xa$Id = B.Xe$Id; '

    exec (:stmt_psp_column_attributes);
END; -- End of stored procedure.
