/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.notificationviewer.utils;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class MiscUtils {
    private static final int DAY_IN_MILLIS = 86400000;

    public static String removeQuotes(String string) {
        String[] stringArray = string.split("\"+");
        return stringArray.length == 1 ? stringArray[0] : stringArray[1];
    }

    public static FontData createIncrSizeFontData(Font font, int n) {
        FontData fontData = font.getFontData()[0];
        fontData.setHeight(fontData.getHeight() + n);
        return fontData;
    }

    public static Font createLargerFont(Font font, int n) {
        FontData fontData = font.getFontData()[0];
        Font font2 = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight() + n, 1));
        return font2;
    }

    public static boolean isWinOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static int getDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        return calendar.get(5);
    }

    public static int daysAgo(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        long l = MiscUtils.normalize(calendar);
        calendar.setTime(date);
        long l2 = MiscUtils.normalize(calendar);
        return (int)((l - l2) / 86400000L);
    }

    private static long normalize(Calendar calendar) {
        calendar.set(11, 2);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis() + (long)calendar.get(16);
    }
}

