/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.Connection;
import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIUtils;
import com.pervasive.psql.utilities.javadti.PVBOOLSTR;
import com.pervasive.psql.utilities.javadti.PVSETTINGINFO;
import com.pervasive.psql.utilities.javadti.PVSETTINGMAP;
import com.pervasive.psql.utilities.javadti.PVSETTINGUNIT;
import com.pervasive.psql.utilities.javadti.PVVALUELIMIT;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class SettingID {
    private static final int[] REQUIRES_RESTART_SETTINGS = new int[]{26, 27, 44, 45, 48, 49, 57, 58, 61, 62, 64, 65, 66, 67, 68, 69, 73, 74, 85, 86, 87, 99, 100, 103, 110, 111, 112, 114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 126, 127, 130, 132, 133, 134, 136, 137, 138, 140, 144, 145, 146, 147, 148, 149, 168, 169, 170, 171, 172, 173, 174, 175, 177, 178, 179, 183, 201, 203, 204, 205, 210, 300, 301};
    private Logger m_logger;
    private Connection m_conObj;

    public static boolean requiresRestart(long l) {
        return Arrays.binarySearch(REQUIRES_RESTART_SETTINGS, (int)l) >= 0;
    }

    public SettingID(Connection connection, String string) {
        this.m_conObj = connection;
        this.m_logger = Logger.getLogger(string);
    }

    public boolean isAvailable(long l) {
        boolean bl = false;
        bl = javadti.JPvIsSettingAvailable(this.m_conObj.getHandle(), l) != 0;
        return bl;
    }

    public void getInfo(long l, PVSETTINGINFO pVSETTINGINFO) throws DTIException {
        int n = javadti.JPvGetSettingInfo(this.m_conObj.getHandle(), l, pVSETTINGINFO);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSettingInfo failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetSettingInfo succeeded");
    }

    public String[] getAllPossibleSelections(long l) throws DTIException {
        long[] lArray = new long[]{1L};
        lArray = this.getCountSelectionValue(l);
        long[] lArray2 = new long[(int)lArray[0]];
        int n = javadti.JPvGetAllPossibleSelections(this.m_conObj.getHandle(), l, lArray, lArray2);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetAllPossibleSelections succeeded");
            String[] stringArray = new String[(int)lArray[0]];
            int n2 = 0;
            while ((long)n2 < lArray[0]) {
                stringArray[n2] = String.valueOf(String.valueOf(lArray2[n2])) + "\t" + this.getSelectionString(l, (int)lArray2[n2]);
                ++n2;
            }
            return stringArray;
        }
        this.m_logger.finer("JPvGetAllPossibleSelections failed");
        throw new DTIException(n);
    }

    public void getUnits(long l, PVSETTINGUNIT pVSETTINGUNIT) throws DTIException {
        long[] lArray = new long[]{1L};
        long[] lArray2 = new long[]{1L};
        int n = javadti.JPvGetSettingUnitsSize(this.m_conObj.getHandle(), l, lArray, lArray2);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSettingUnitsSize succeeded");
            pVSETTINGUNIT.setBufSize(lArray[0]);
            pVSETTINGUNIT.setFbufSize(lArray2[0]);
            n = javadti.JPvGetSettingUnits(this.m_conObj.getHandle(), l, pVSETTINGUNIT);
            if (n == DTICONSTS.P_OK) {
                this.m_logger.finer("JPvGetSettingUnits succeeded");
            } else {
                this.m_logger.finer("JPvGetSettingUnits failed");
            }
        } else {
            this.m_logger.finer("JPvGetSettingUnitsSize failed");
            throw new DTIException(n);
        }
    }

    public void setValue(long l, String[] stringArray, int n) throws DTIException, NumberFormatException {
        PVSETTINGINFO pVSETTINGINFO = new PVSETTINGINFO();
        try {
            this.getInfo(l, pVSETTINGINFO);
            switch (pVSETTINGINFO.getSType()) {
                case 0: {
                    this.setBooleanValue(l, stringArray[0], n);
                    break;
                }
                case 1: {
                    this.setLongValue(l, stringArray[0], n);
                    break;
                }
                case 2: {
                    this.setStringValue(l, stringArray[0], n);
                    break;
                }
                case 3: 
                case 4: {
                    this.setSelectionValue(l, stringArray, n);
                }
            }
        }
        finally {
            pVSETTINGINFO.delete();
        }
    }

    public String[] getValue(long l, int n) throws DTIException {
        PVSETTINGINFO pVSETTINGINFO = new PVSETTINGINFO();
        try {
            this.getInfo(l, pVSETTINGINFO);
            String[] stringArray = new String[]{""};
            switch (pVSETTINGINFO.getSType()) {
                case 0: {
                    stringArray = this.getBooleanValue(l, n);
                    break;
                }
                case 1: {
                    stringArray = this.getLongValue(l, n);
                    break;
                }
                case 2: {
                    stringArray = this.getStringValue(l, n);
                    break;
                }
                case 3: 
                case 4: {
                    stringArray = this.getSelectionValue(l, n);
                }
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            pVSETTINGINFO.delete();
        }
    }

    private void checkResult(int n) throws DTIException {
        if (n != DTICONSTS.P_OK) {
            throw new DTIException(n);
        }
    }

    public Object getValueObject(long l, int n) throws DTIException {
        Object object = null;
        PVSETTINGINFO pVSETTINGINFO = new PVSETTINGINFO();
        try {
            this.getInfo(l, pVSETTINGINFO);
            switch (pVSETTINGINFO.getSType()) {
                case 0: {
                    short[] sArray = new short[]{1};
                    this.checkResult(javadti.JPvGetBooleanValue(this.m_conObj.getHandle(), l, sArray, n));
                    object = new Boolean(sArray[0] != 0);
                    break;
                }
                case 1: {
                    int[] nArray = new int[]{1};
                    this.checkResult(javadti.JPvGetLongValue(this.m_conObj.getHandle(), l, nArray, n));
                    object = new Long(nArray[0]);
                    break;
                }
                case 2: {
                    object = this.getStringValue(l, n)[0];
                    break;
                }
                case 3: {
                    object = this.getSelectionValue(l, n)[0];
                    break;
                }
                case 4: {
                    object = this.getSelectionSet(l, n);
                }
            }
        }
        finally {
            pVSETTINGINFO.delete();
        }
        return object;
    }

    public void setValueObject(long l, int n, Object object) throws DTIException {
        PVSETTINGINFO pVSETTINGINFO = new PVSETTINGINFO();
        try {
            this.getInfo(l, pVSETTINGINFO);
            switch (pVSETTINGINFO.getSType()) {
                case 0: {
                    boolean bl = (Boolean)object;
                    this.checkResult(javadti.JPvSetBooleanValue(this.m_conObj.getHandle(), l, bl ? 1 : 0, n));
                    break;
                }
                case 1: {
                    this.checkResult(javadti.JPvSetLongValue(this.m_conObj.getHandle(), l, (Integer)object, n));
                    break;
                }
                case 2: {
                    this.checkResult(javadti.JPvSetStringValue(this.m_conObj.getHandle(), l, (String)object, n));
                    break;
                }
                case 3: {
                    int[] nArray = new int[]{Integer.parseInt((String)object)};
                    this.checkResult(javadti.JPvSetSelectionValue(this.m_conObj.getHandle(), l, nArray.length, nArray, n));
                    break;
                }
                case 4: {
                    Set set = (Set)object;
                    int[] nArray = new int[set.size()];
                    int n2 = 0;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        nArray[n2++] = Integer.parseInt((String)iterator.next());
                    }
                    this.checkResult(javadti.JPvSetSelectionValue(this.m_conObj.getHandle(), l, nArray.length, nArray, n));
                }
            }
        }
        finally {
            pVSETTINGINFO.delete();
        }
    }

    public String getHelp(long l) throws DTIException {
        long[] lArray = new long[]{1L};
        int n = javadti.JPvGetSettingHelpSize(l, lArray);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSettingHelpSize failed");
            throw new DTIException(n);
        }
        this.m_logger.finer("JPvGetSettingHelpSize succeeded, Size = " + lArray[0]);
        byte[] byArray = new byte[(int)lArray[0]];
        n = javadti.JPvGetSettingHelp(l, lArray, byArray);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSettingHelp succeeded, Size = " + lArray[0] + "Value = " + byArray);
            return DTIUtils.getLocaleString(byArray);
        }
        this.m_logger.finer("JPvGetSettingHelp failed");
        throw new DTIException(n);
    }

    public void getMap(long l, PVSETTINGMAP pVSETTINGMAP) throws DTIException {
        int[] nArray = new int[]{-1};
        int[] nArray2 = new int[]{-1};
        int n = javadti.JPvGetSettingMap(l, nArray, nArray2);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSettingMap failed");
            throw new DTIException(n);
        }
        pVSETTINGMAP.setPComponentID(nArray[0]);
        pVSETTINGMAP.setPOptionID(nArray2[0]);
        this.m_logger.finer("JPvGetSettingMap succeeded");
    }

    private String[] getBooleanValue(long l, int n) throws DTIException {
        short[] sArray = new short[]{1};
        String[] stringArray = new String[]{""};
        int n2 = javadti.JPvGetBooleanValue(this.m_conObj.getHandle(), l, sArray, n);
        if (n2 == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetBooleanValue succeeded");
            PVBOOLSTR pVBOOLSTR = this.getBooleanStrings(l);
            try {
                stringArray[0] = sArray[0] == 0 ? pVBOOLSTR.getFalseStr() : pVBOOLSTR.getTrueStr();
            }
            finally {
                pVBOOLSTR.delete();
            }
            return stringArray;
        }
        this.m_logger.finer("JPvGetBooleanValue failed");
        throw new DTIException(n2);
    }

    public PVBOOLSTR getBooleanStrings(long l) throws DTIException {
        PVBOOLSTR pVBOOLSTR = null;
        pVBOOLSTR = new PVBOOLSTR();
        pVBOOLSTR.setFalseStrSize(125);
        pVBOOLSTR.setTrueStrSize(125);
        int n = javadti.JPvGetBooleanStrings(this.m_conObj.getHandle(), l, pVBOOLSTR);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetBooleanString succeeded");
            return pVBOOLSTR;
        }
        this.m_logger.finer("JPvGetBooleanString failed");
        pVBOOLSTR.delete();
        throw new DTIException(n);
    }

    private String[] getLongValue(long l, int n) throws DTIException {
        int[] nArray = new int[]{1};
        String[] stringArray = new String[]{""};
        int n2 = javadti.JPvGetLongValue(this.m_conObj.getHandle(), l, nArray, n);
        if (n2 == DTICONSTS.P_OK) {
            stringArray[0] = String.valueOf(nArray[0]);
            this.m_logger.finer("JPvGetLongValue succeeded");
            return stringArray;
        }
        this.m_logger.finer("JPvGetLongValue failed");
        throw new DTIException(n2);
    }

    private String[] getStringValue(long l, int n) throws DTIException {
        long[] lArray = new long[]{1L};
        String[] stringArray = new String[]{""};
        int n2 = javadti.JPvGetStringValueSize(this.m_conObj.getHandle(), l, lArray, n);
        if (n2 == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetStringValueSize succeeded");
            if (lArray[0] <= 0L) {
                stringArray[0] = "";
                return stringArray;
            }
        } else {
            this.m_logger.finer("JPvGetStringValueSize failed");
            throw new DTIException(n2);
        }
        byte[] byArray = new byte[(int)lArray[0]];
        n2 = javadti.JPvGetStringValue(this.m_conObj.getHandle(), l, lArray, byArray, n);
        if (n2 == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetStringValue succeeded");
            stringArray[0] = DTIUtils.getLocaleString(byArray);
            return stringArray;
        }
        this.m_logger.finer("JPvGetStringValue failed");
        throw new DTIException(n2);
    }

    private long[] getCountSelectionValue(long l) throws DTIException {
        long[] lArray = new long[]{1000L};
        int n = javadti.JPvCountSelectionItems(this.m_conObj.getHandle(), l, lArray);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetCountSelectionItems succeeded");
            lArray[0] = lArray[0] + 1L;
            return lArray;
        }
        this.m_logger.finer("JPvGetCountSelectionItems failed");
        throw new DTIException(n);
    }

    private String[] getSelectionValue(long l, int n) throws DTIException {
        long[] lArray = new long[]{1000L};
        int[] nArray = new int[(int)lArray[0]];
        int n2 = javadti.JPvGetSelectionValue(this.m_conObj.getHandle(), l, lArray, nArray, n);
        if (n2 == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSelectionValue succeeded");
            String[] stringArray = new String[(int)lArray[0]];
            int n3 = 0;
            while ((long)n3 < lArray[0]) {
                stringArray[n3] = String.valueOf(nArray[n3]);
                ++n3;
            }
            return stringArray;
        }
        this.m_logger.finer("JPvGetSelectionValue failed");
        throw new DTIException(n2);
    }

    private Set getSelectionSet(long l, int n) throws DTIException {
        long[] lArray = new long[]{1000L};
        int[] nArray = new int[(int)lArray[0]];
        int n2 = javadti.JPvGetSelectionValue(this.m_conObj.getHandle(), l, lArray, nArray, n);
        if (n2 == DTICONSTS.P_OK) {
            HashSet<String> hashSet = new HashSet<String>((int)lArray[0]);
            this.m_logger.finer("JPvGetSelectionValue succeeded");
            String[] cfr_ignored_0 = new String[(int)lArray[0]];
            int n3 = 0;
            while ((long)n3 < lArray[0]) {
                hashSet.add(String.valueOf(nArray[n3]));
                ++n3;
            }
            return hashSet;
        }
        this.m_logger.finer("JPvGetSelectionValue failed");
        throw new DTIException(n2);
    }

    public String getSelectionString(long l, int n) throws DTIException {
        long[] lArray = new long[]{1L};
        int n2 = javadti.JPvGetSelectionStringSize(this.m_conObj.getHandle(), l, n, lArray);
        if (n2 != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSelectionStringSize failed");
            throw new DTIException(n2);
        }
        this.m_logger.finer("JPvGetSelectionStringSize succeeded");
        byte[] byArray = new byte[(int)lArray[0]];
        n2 = javadti.JPvGetSelectionString(this.m_conObj.getHandle(), l, n, lArray, byArray);
        if (n2 == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetSelectionString succeeded");
            return DTIUtils.getLocaleString(byArray);
        }
        this.m_logger.finer("JPvGetSelectionString failed");
        throw new DTIException(n2);
    }

    private void setBooleanValue(long l, String string, int n) throws DTIException {
        int n2;
        block6: {
            PVBOOLSTR pVBOOLSTR = this.getBooleanStrings(l);
            n2 = -1;
            try {
                if (string.equalsIgnoreCase(pVBOOLSTR.getTrueStr()) || string.equalsIgnoreCase("true") || string.equals("1")) {
                    n2 = 1;
                    break block6;
                }
                if (string.equalsIgnoreCase(pVBOOLSTR.getFalseStr()) || string.equalsIgnoreCase("false") || string.equals("0")) {
                    n2 = 0;
                    break block6;
                }
                throw new DTIException(DTICONSTS.P_E_INVALID_SETTING_VALUE);
            }
            finally {
                pVBOOLSTR.delete();
            }
        }
        int n3 = javadti.JPvSetBooleanValue(this.m_conObj.getHandle(), l, n2, n);
        if (n3 != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvSetBooleanValue failed");
            throw new DTIException(n3);
        }
        this.m_logger.finer("JPvSetBooleanValue succeeded");
    }

    private void setLongValue(long l, String string, int n) throws DTIException, NumberFormatException {
        int n2 = Integer.parseInt(string);
        int n3 = javadti.JPvSetLongValue(this.m_conObj.getHandle(), l, n2, n);
        if (n3 != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvSetLongValue failed");
            throw new DTIException(n3);
        }
        this.m_logger.finer("JPvSetLongValue succeeded");
    }

    private void setStringValue(long l, String string, int n) throws DTIException {
        int n2;
        if (string.equalsIgnoreCase("NULL")) {
            string = "<None>";
        }
        if ((n2 = javadti.JPvSetStringValue(this.m_conObj.getHandle(), l, string, n)) != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvSetStringValue failed");
            throw new DTIException(n2);
        }
        this.m_logger.finer("JPvSetStringValue succeeded");
    }

    private void setSelectionValue(long l, String[] stringArray, int n) throws DTIException, NumberFormatException {
        if (stringArray.length > 0) {
            int[] nArray = new int[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                nArray[n2] = Integer.parseInt(stringArray[n2]);
                ++n2;
            }
            int n3 = javadti.JPvSetSelectionValue(this.m_conObj.getHandle(), l, stringArray.length, nArray, n);
            if (n3 != DTICONSTS.P_OK) {
                this.m_logger.finer("JPvSetSelectionValue failed");
                throw new DTIException(n3);
            }
        } else {
            this.m_logger.finer("Setting value array is empty");
            throw new NumberFormatException();
        }
        this.m_logger.finer("JPvSetSelectionValue succeeded");
    }

    public long getStringType(long l) throws DTIException {
        long[] lArray = new long[]{1L};
        int n = javadti.JPvGetStringType(this.m_conObj.getHandle(), l, lArray);
        if (n == DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetStringType succeeded");
            return lArray[0];
        }
        this.m_logger.finer("JPvGetStringType failed");
        throw new DTIException(n);
    }

    public void getValueLimit(long l, PVVALUELIMIT pVVALUELIMIT) throws DTIException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = javadti.JPvGetValueLimit(this.m_conObj.getHandle(), l, nArray, nArray2);
        if (n != DTICONSTS.P_OK) {
            this.m_logger.finer("JPvGetValueLimit failed");
            throw new DTIException(n);
        }
        pVVALUELIMIT.setMaxValue(nArray[0]);
        pVVALUELIMIT.setMinValue(nArray2[0]);
        this.m_logger.finer("JPvGetValueLimitsucceeded");
    }
}

