/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.psql.utilities.javadti;

import com.pervasive.psql.utilities.javadti.DTICONSTS;
import com.pervasive.psql.utilities.javadti.DTIException;
import com.pervasive.psql.utilities.javadti.DTIUtils;
import com.pervasive.psql.utilities.javadti.Messages;
import com.pervasive.psql.utilities.javadti.javadti;
import java.util.logging.Logger;

public class Connection {
    public static final Connection LOCAL_DB_CONNECTION = new Connection(-1);
    private static boolean dtiStarted;
    private String m_userName = "";
    private String m_password = "";
    private String m_serverName = "";
    private Logger logger;
    private int m_hConnection = -99;
    private boolean m_bInit = false;

    static {
        System.loadLibrary("javadti");
        javadti.setJajpEncoding(false);
    }

    private Connection(int n) {
        this.m_hConnection = n;
    }

    public Connection(String string, String string2, String string3, String string4) throws DTIException {
        this.initialize(string, string2, string3, string4);
    }

    private int initialize(String string, String string2, String string3, String string4) throws DTIException {
        if (this.m_bInit) {
            this.disconnectServer();
        }
        this.m_serverName = string;
        this.m_userName = string2;
        this.m_password = string3;
        this.m_bInit = true;
        this.logger = Logger.getLogger(string4);
        Connection.start();
        return this.connectServer();
    }

    public void dispose() throws DTIException {
        if (this.m_bInit) {
            this.disconnectServer();
            this.m_bInit = false;
        }
    }

    public static final synchronized void start() throws DTIException {
        if (dtiStarted) {
            return;
        }
        dtiStarted = true;
        int n = javadti.JPvStart();
        if (n != DTICONSTS.P_OK) {
            throw new DTIException(n);
        }
    }

    public static final synchronized void stop() {
        if (dtiStarted) {
            javadti.JPvStop();
        }
    }

    private int connectServer() throws DTIException {
        int[] nArray = new int[]{-99};
        int n = javadti.JPvConnectServer(this.m_serverName, this.m_userName, this.m_password, nArray);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvConnectServer Failed: " + DTICONSTS.getErrorDesc(n));
            this.m_hConnection = -99;
            throw new DTIException(n, Messages.get("dti.connect.failed"));
        }
        this.m_hConnection = nArray[0];
        this.logger.finer("JPvConnectServer Success.");
        this.logger.finer("ServerName:" + this.m_serverName + " UserName:" + this.m_userName + " Password:" + this.m_password + " Handle:" + this.m_hConnection);
        return this.m_hConnection;
    }

    private void disconnectServer() throws DTIException {
        int n = javadti.JPvDisconnect(this.m_hConnection);
        if (n != DTICONSTS.P_OK) {
            this.logger.finer("JPvDisconnect Failed, Error:" + DTICONSTS.getErrorDesc(n));
            throw new DTIException(n, Messages.get("dti.disconnect.failed"));
        }
        this.logger.finer("JPvDisconnect Success");
    }

    public String getServerName(int n) throws DTIException {
        byte[] byArray = new byte[n];
        long[] lArray = new long[]{n};
        int n2 = javadti.JPvGetServerName(this.m_hConnection, lArray, byArray);
        if (n2 != DTICONSTS.P_OK) {
            this.m_serverName = "";
            this.logger.finer("PvGetServerName Failed: " + DTICONSTS.getErrorDesc(n2));
            throw new DTIException(n2);
        }
        this.m_serverName = DTIUtils.getLocaleString(byArray);
        this.m_serverName.trim();
        this.logger.finer("PvGetServerName:" + this.m_serverName);
        return this.m_serverName;
    }

    public int getHandle() {
        return this.m_hConnection;
    }
}

