/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.wizard;

import com.pervasive.utilities.wizard.IPageController;
import com.pervasive.utilities.wizard.WizardPageExt;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardExt
extends Wizard {
    private Object model;
    private IPageController controller;
    private String contextId;

    public abstract void finish() throws Exception;

    public WizardExt() {
    }

    public WizardExt(String string) {
        this.setWindowTitle(string);
    }

    public int getPageCount() {
        return this.controller.getPageCount();
    }

    public IWizardPage[] getPages() {
        return this.controller.getPages();
    }

    public IWizardPage getStartingPage() {
        return this.controller.getStartingPage();
    }

    public boolean canFinish() {
        WizardPageExt wizardPageExt = (WizardPageExt)this.getCurrentPage();
        return wizardPageExt.isPageComplete() && wizardPageExt.isFinishPage();
    }

    public void setController(IPageController iPageController) {
        this.controller = iPageController;
    }

    public IPageController getController() {
        return this.controller;
    }

    public void setHelpContextId(String string) {
        this.contextId = string;
    }

    public String getHelpContextId() {
        return this.contextId;
    }

    public void setModel(Object object) {
        this.model = object;
    }

    public Object getModel() {
        return this.model;
    }

    public boolean performCancel() {
        WizardPageExt wizardPageExt = (WizardPageExt)this.getCurrentPage();
        wizardPageExt.cancelPage();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        WizardPageExt wizardPageExt = (WizardPageExt)this.getCurrentPage();
        wizardPageExt.applyPage();
        boolean bl = true;
        Cursor cursor = new Cursor(null, 1);
        Display.getCurrent().getActiveShell().setCursor(cursor);
        try {
            this.finish();
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            Shell[] shellArray = Display.getCurrent().getShells();
            for (int i = 0; i < shellArray.length; ++i) {
                if (shellArray[i] == null) continue;
                shellArray[i].setCursor(null);
            }
            cursor.dispose();
        }
        return bl;
    }

    public IWizardPage getCurrentPage() {
        return this.getContainer().getCurrentPage();
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        return this.controller.nextPage(iWizardPage);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        return this.controller.previousPage(iWizardPage);
    }
}

