/*
 * Decompiled with CFR 0.152.
 */
package com.pervasive.utilities.wizard;

import com.pervasive.utilities.wizard.IPageController;
import com.pervasive.utilities.wizard.WizardPageExt;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;

public abstract class StackBasedPageController
implements IPageController,
IPageChangingListener {
    protected List<IWizardPage> pages = new ArrayList<IWizardPage>();
    private WizardDialog wizardContainer;
    private List<Integer> pageStack = new ArrayList<Integer>();

    protected StackBasedPageController() {
        this.pageStack.add(0);
    }

    public void setContainer(IWizardContainer iWizardContainer) {
        this.wizardContainer = (WizardDialog)iWizardContainer;
        if (iWizardContainer != null) {
            this.wizardContainer.addPageChangingListener((IPageChangingListener)this);
        }
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public IWizardPage[] getPages() {
        IWizardPage[] iWizardPageArray = new IWizardPage[this.pages.size()];
        return this.pages.toArray(iWizardPageArray);
    }

    @Override
    public IWizardPage getStartingPage() {
        return this.pages.get(0);
    }

    @Override
    public IWizardPage nextPage(IWizardPage iWizardPage) {
        int n = this.pages.indexOf(iWizardPage);
        return n + 1 < this.pages.size() ? this.pages.get(n + 1) : null;
    }

    @Override
    public IWizardPage previousPage(IWizardPage iWizardPage) {
        if (this.pageStack.size() <= 1) {
            return null;
        }
        WizardPageExt wizardPageExt = (WizardPageExt)iWizardPage;
        if (!wizardPageExt.allowBack()) {
            return null;
        }
        int n = this.pageStack.get(this.pageStack.size() - 2);
        return this.pages.get(n);
    }

    public void handlePageChanging(PageChangingEvent pageChangingEvent) {
        int n;
        WizardPageExt wizardPageExt = (WizardPageExt)((Object)pageChangingEvent.getTargetPage());
        int n2 = this.pages.indexOf((Object)wizardPageExt);
        if (n2 == (n = this.pageStack.get(this.pageStack.size() - 1).intValue())) {
            return;
        }
        if (this.pageStack.size() <= 1) {
            this.pageStack.add(n2);
        } else {
            int n3 = this.pageStack.get(this.pageStack.size() - 2);
            if (n2 == n3) {
                this.pageStack.remove(this.pageStack.size() - 1);
            } else {
                this.pageStack.add(n2);
            }
        }
    }
}

